/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.operator.DynamicFilterStats;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.operator.repartition.PartitionedOutputInfo;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOperatorStats {
    private static final SplitOperatorInfo NON_MERGEABLE_INFO = new SplitOperatorInfo((Object)"some_info");
    private static final PartitionedOutputInfo MERGEABLE_INFO = new PartitionedOutputInfo(1L, 2L, 1024L);
    private static final String TEST_METRIC_NAME = "test_metric";
    private static final RuntimeMetric TEST_RUNTIME_METRIC_1 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 10L, 2L, 9L, 1L);
    private static final RuntimeMetric TEST_RUNTIME_METRIC_2 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 5L, 2L, 3L, 2L);
    private static final DynamicFilterStats TEST_DYNAMIC_FILTER_STATS_1 = new DynamicFilterStats(new HashSet<PlanNodeId>(Arrays.asList(new PlanNodeId("1"), new PlanNodeId("2"))));
    private static final DynamicFilterStats TEST_DYNAMIC_FILTER_STATS_2 = new DynamicFilterStats(new HashSet<PlanNodeId>(Arrays.asList(new PlanNodeId("2"), new PlanNodeId("3"))));
    public static final OperatorStats EXPECTED = new OperatorStats(0, 10, 1, 41, new PlanNodeId("test"), "test", 1L, 1L, new Duration(2.0, TimeUnit.NANOSECONDS), new Duration(3.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new DataSize(123.0, DataSize.Unit.BYTE), new DataSize(5.0, DataSize.Unit.BYTE), 10L, new DataSize(6.0, DataSize.Unit.BYTE), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), new DataSize(12.0, DataSize.Unit.BYTE), 13L, new DataSize(14.0, DataSize.Unit.BYTE), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), new DataSize(345.0, DataSize.Unit.BYTE), new DataSize(9.223372036854776E18, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(22.0, DataSize.Unit.BYTE), new DataSize(23.0, DataSize.Unit.BYTE), new DataSize(24.0, DataSize.Unit.BYTE), new DataSize(25.0, DataSize.Unit.BYTE), Optional.empty(), (OperatorInfo)NON_MERGEABLE_INFO, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_1))), TEST_DYNAMIC_FILTER_STATS_1, 0L, 0L, 0L, 0L);
    public static final OperatorStats MERGEABLE = new OperatorStats(0, 10, 1, 41, new PlanNodeId("test"), "test", 1L, 1L, new Duration(2.0, TimeUnit.NANOSECONDS), new Duration(3.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new DataSize(123.0, DataSize.Unit.BYTE), new DataSize(5.0, DataSize.Unit.BYTE), 10L, new DataSize(6.0, DataSize.Unit.BYTE), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), new DataSize(12.0, DataSize.Unit.BYTE), 13L, new DataSize(14.0, DataSize.Unit.BYTE), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), new DataSize(345.0, DataSize.Unit.BYTE), new DataSize(19.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(22.0, DataSize.Unit.BYTE), new DataSize(23.0, DataSize.Unit.BYTE), new DataSize(24.0, DataSize.Unit.BYTE), new DataSize(25.0, DataSize.Unit.BYTE), Optional.empty(), (OperatorInfo)MERGEABLE_INFO, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_2))), TEST_DYNAMIC_FILTER_STATS_2, 0L, 0L, 0L, 0L);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(OperatorStats.class);
        String json = codec.toJson((Object)EXPECTED);
        OperatorStats actual = (OperatorStats)codec.fromJson(json);
        TestOperatorStats.assertExpectedOperatorStats(actual);
    }

    private static void assertRuntimeMetricEquals(RuntimeMetric m1, RuntimeMetric m2) {
        Assert.assertEquals((String)m1.getName(), (String)m2.getName());
        Assert.assertEquals((long)m1.getSum(), (long)m2.getSum());
        Assert.assertEquals((long)m1.getCount(), (long)m2.getCount());
        Assert.assertEquals((long)m1.getMax(), (long)m2.getMax());
        Assert.assertEquals((long)m1.getMin(), (long)m2.getMin());
    }

    public static void assertExpectedOperatorStats(OperatorStats actual) {
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)1L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)2L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputAllocation(), (Object)new DataSize(123.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(5.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(6.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)7L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)8.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)9L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputAllocation(), (Object)new DataSize(234.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(12.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)13L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(14.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)16L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishAllocation(), (Object)new DataSize(345.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getUserMemoryReservation().toBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(20.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(21.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakSystemMemoryReservation(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(25.0, DataSize.Unit.BYTE));
        Assert.assertEquals(actual.getInfo().getClass(), SplitOperatorInfo.class);
        Assert.assertEquals((Object)((SplitOperatorInfo)actual.getInfo()).getSplitInfo(), (Object)NON_MERGEABLE_INFO.getSplitInfo());
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), TEST_RUNTIME_METRIC_1);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_1.getProducerNodeIds());
    }

    @Test
    public void testAdd() {
        OperatorStats actual = EXPECTED.add((Iterable)ImmutableList.of((Object)EXPECTED, (Object)EXPECTED));
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputAllocation(), (Object)new DataSize(369.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputAllocation(), (Object)new DataSize(702.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(36.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(42.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(300.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishAllocation(), (Object)new DataSize(1035.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getUserMemoryReservation().toBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(60.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(63.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakSystemMemoryReservation(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(75.0, DataSize.Unit.BYTE));
        Assert.assertNull((Object)actual.getInfo());
        RuntimeMetric expectedMetric = RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_1, (RuntimeMetric)TEST_RUNTIME_METRIC_1);
        expectedMetric.mergeWith(TEST_RUNTIME_METRIC_1);
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_1.getProducerNodeIds());
    }

    @Test
    public void testAddMergeable() {
        OperatorStats actual = MERGEABLE.add((Iterable)ImmutableList.of((Object)MERGEABLE, (Object)MERGEABLE));
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputAllocation(), (Object)new DataSize(369.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputAllocation(), (Object)new DataSize(702.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(36.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(42.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(300.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishAllocation(), (Object)new DataSize(1035.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(57.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(60.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(63.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakSystemMemoryReservation(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(75.0, DataSize.Unit.BYTE));
        Assert.assertEquals(actual.getInfo().getClass(), PartitionedOutputInfo.class);
        Assert.assertEquals((long)((PartitionedOutputInfo)actual.getInfo()).getPagesAdded(), (long)(3L * MERGEABLE_INFO.getPagesAdded()));
        RuntimeMetric expectedMetric = RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_2, (RuntimeMetric)TEST_RUNTIME_METRIC_2);
        expectedMetric.mergeWith(TEST_RUNTIME_METRIC_2);
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_2.getProducerNodeIds());
    }
}

