/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.TestingMemoryContext;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.DummySpillerFactory;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.InMemoryGroupedTopNBuilder;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.operator.SpillableGroupedTopNBuilder;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.spiller.TestingSpillContext;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSpillableGroupedTopNBuilder {
    @DataProvider
    public static Object[][] produceRowNumbers() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="produceRowNumbers")
    public void testThatRevokeSpillsDuringAddInput(boolean produceRowNumbers) {
        int i;
        DummySpillerFactory spillerFactory = new DummySpillerFactory();
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        Supplier<GroupByHash> groupByHashSupplier = () -> TestSpillableGroupedTopNBuilder.lambda$testThatRevokeSpillsDuringAddInput$0((List)types);
        TestingMemoryContext userMemoryContext = new TestingMemoryContext(200L);
        TestingMemoryContext revocableMemoryContext = new TestingMemoryContext(1000L);
        DriverYieldSignal driverYieldSignal = new DriverYieldSignal();
        AggregatedMemoryContext aggregatedMemoryContextForMerge = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        AggregatedMemoryContext aggregatedMemoryContextForSpill = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        TestingSpillContext spillContext = new TestingSpillContext();
        SpillableGroupedTopNBuilder spillableGroupedTopNBuilder = new SpillableGroupedTopNBuilder((List)types, (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), () -> TestSpillableGroupedTopNBuilder.lambda$testThatRevokeSpillsDuringAddInput$1((List)types, produceRowNumbers, revocableMemoryContext, groupByHashSupplier), () -> TestSpillableGroupedTopNBuilder.lambda$testThatRevokeSpillsDuringAddInput$2((List)types, produceRowNumbers, revocableMemoryContext, groupByHashSupplier), () -> Futures.immediateFuture(null), 100000L, (LocalMemoryContext)userMemoryContext, (LocalMemoryContext)revocableMemoryContext, aggregatedMemoryContextForMerge, aggregatedMemoryContextForSpill, (SpillContext)spillContext, driverYieldSignal, (SpillerFactory)spillerFactory);
        List<Page> inputPages = TestSpillableGroupedTopNBuilder.generatePages(1000, 10, 100);
        long emptyBuilderSize = spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes();
        for (i = 0; i < 20; ++i) {
            spillableGroupedTopNBuilder.processPage(inputPages.get(i)).process();
            spillableGroupedTopNBuilder.updateMemoryReservations();
        }
        spillableGroupedTopNBuilder.startMemoryRevoke();
        spillableGroupedTopNBuilder.finishMemoryRevoke();
        Assert.assertEquals((long)spillerFactory.getSpillsCount(), (long)1L);
        Assert.assertEquals((long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes(), (long)emptyBuilderSize);
        Assert.assertEquals((long)userMemoryContext.getBytes(), (long)0L);
        Assert.assertEquals((long)revocableMemoryContext.getBytes(), (long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes());
        Assert.assertEquals((long)userMemoryContext.getBytes(), (long)0L);
        for (i = 21; i < 40; ++i) {
            spillableGroupedTopNBuilder.processPage(inputPages.get(i)).process();
            spillableGroupedTopNBuilder.updateMemoryReservations();
        }
        spillableGroupedTopNBuilder.startMemoryRevoke();
        spillableGroupedTopNBuilder.finishMemoryRevoke();
        Assert.assertEquals((long)spillerFactory.getSpillsCount(), (long)2L);
        Assert.assertEquals((long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes(), (long)emptyBuilderSize);
        for (i = 41; i < 100; ++i) {
            spillableGroupedTopNBuilder.processPage(inputPages.get(i)).process();
            spillableGroupedTopNBuilder.updateMemoryReservations();
        }
        WorkProcessor result = spillableGroupedTopNBuilder.buildResult();
        while (!result.isFinished()) {
            boolean res = result.process();
            if (!res || result.isFinished()) continue;
            Page page = (Page)result.getResult();
        }
        Assert.assertEquals((long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes(), (long)emptyBuilderSize);
        spillableGroupedTopNBuilder.close();
        Assert.assertEquals((long)userMemoryContext.getBytes(), (long)0L);
        Assert.assertEquals((long)revocableMemoryContext.getBytes(), (long)0L);
    }

    @Test(dataProvider="produceRowNumbers")
    public void testNoSpilling(boolean produceRowNumbers) {
        DummySpillerFactory spillerFactory = new DummySpillerFactory();
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        Supplier<GroupByHash> groupByHashSupplier = () -> TestSpillableGroupedTopNBuilder.lambda$testNoSpilling$4((List)types);
        TestingMemoryContext userMemoryContext = new TestingMemoryContext(1000000L);
        TestingMemoryContext revocableMemoryContext = new TestingMemoryContext(1000000L);
        DriverYieldSignal driverYieldSignal = new DriverYieldSignal();
        AggregatedMemoryContext aggregatedMemoryContextForMerge = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        AggregatedMemoryContext aggregatedMemoryContextForSpill = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        TestingSpillContext spillContext = new TestingSpillContext();
        SpillableGroupedTopNBuilder spillableGroupedTopNBuilder = new SpillableGroupedTopNBuilder((List)types, (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), () -> TestSpillableGroupedTopNBuilder.lambda$testNoSpilling$5((List)types, produceRowNumbers, revocableMemoryContext, groupByHashSupplier), () -> TestSpillableGroupedTopNBuilder.lambda$testNoSpilling$6((List)types, produceRowNumbers, revocableMemoryContext, groupByHashSupplier), () -> Futures.immediateFuture(null), 100000L, (LocalMemoryContext)userMemoryContext, (LocalMemoryContext)revocableMemoryContext, aggregatedMemoryContextForMerge, aggregatedMemoryContextForSpill, (SpillContext)spillContext, driverYieldSignal, (SpillerFactory)spillerFactory);
        List<Page> inputPages = TestSpillableGroupedTopNBuilder.generatePages(100, 2, 100);
        for (int i = 0; i < 3; ++i) {
            spillableGroupedTopNBuilder.processPage(inputPages.get(i)).process();
        }
        spillableGroupedTopNBuilder.updateMemoryReservations();
        WorkProcessor outputPages = spillableGroupedTopNBuilder.buildResult();
        Assert.assertEquals((long)revocableMemoryContext.getBytes(), (long)0L);
        Assert.assertEquals((long)userMemoryContext.getBytes(), (long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes());
        boolean isResAvailable = outputPages.process();
        Assert.assertTrue((boolean)isResAvailable);
        Page resPage = (Page)outputPages.getResult();
        Assert.assertEquals((int)resPage.getPositionCount(), (int)200);
    }

    @Test(dataProvider="produceRowNumbers")
    public void testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked(boolean produceRowNumbers) {
        DummySpillerFactory spillerFactory = new DummySpillerFactory();
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        class MemoryFuture {
            ListenableFuture<?> future;

            MemoryFuture() {
            }

            public void setFuture(ListenableFuture<?> future) {
                this.future = future;
            }

            public ListenableFuture<?> getFuture() {
                return this.future;
            }
        }
        MemoryFuture memoryWaitingFuture = new MemoryFuture();
        memoryWaitingFuture.setFuture(Futures.immediateFuture(null));
        Supplier<GroupByHash> groupByHashSupplier = () -> TestSpillableGroupedTopNBuilder.lambda$testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked$9((List)types, memoryWaitingFuture);
        TestingMemoryContext userMemoryContext = new TestingMemoryContext(200L);
        TestingMemoryContext revocableMemoryContext = new TestingMemoryContext(1000L);
        DriverYieldSignal driverYieldSignal = new DriverYieldSignal();
        AggregatedMemoryContext aggregatedMemoryContextForMerge = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        AggregatedMemoryContext aggregatedMemoryContextForSpill = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        TestingSpillContext spillContext = new TestingSpillContext();
        SpillableGroupedTopNBuilder spillableGroupedTopNBuilder = new SpillableGroupedTopNBuilder((List)types, (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), () -> TestSpillableGroupedTopNBuilder.lambda$testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked$10((List)types, produceRowNumbers, revocableMemoryContext, groupByHashSupplier), () -> TestSpillableGroupedTopNBuilder.lambda$testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked$11((List)types, produceRowNumbers, revocableMemoryContext, groupByHashSupplier), memoryWaitingFuture::getFuture, 100000L, (LocalMemoryContext)userMemoryContext, (LocalMemoryContext)revocableMemoryContext, aggregatedMemoryContextForMerge, aggregatedMemoryContextForSpill, (SpillContext)spillContext, driverYieldSignal, (SpillerFactory)spillerFactory);
        List<Page> inputPages = TestSpillableGroupedTopNBuilder.generatePages(1000, 10, 100);
        long emptyBuilderSize = spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes();
        for (int i = 0; i < 20; ++i) {
            spillableGroupedTopNBuilder.processPage(inputPages.get(i)).process();
            spillableGroupedTopNBuilder.updateMemoryReservations();
        }
        spillableGroupedTopNBuilder.startMemoryRevoke();
        spillableGroupedTopNBuilder.finishMemoryRevoke();
        Assert.assertEquals((long)spillerFactory.getSpillsCount(), (long)1L);
        Assert.assertEquals((long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes(), (long)emptyBuilderSize);
        Assert.assertEquals((long)userMemoryContext.getBytes(), (long)0L);
        Assert.assertEquals((long)revocableMemoryContext.getBytes(), (long)spillableGroupedTopNBuilder.getInputInMemoryGroupedTopNBuilder().getEstimatedSizeInBytes());
        Assert.assertEquals((long)userMemoryContext.getBytes(), (long)0L);
        WorkProcessor result = spillableGroupedTopNBuilder.buildResult();
        SettableFuture currentWaitingFuture = SettableFuture.create();
        memoryWaitingFuture.setFuture((ListenableFuture<?>)currentWaitingFuture);
        Assert.assertTrue((!memoryWaitingFuture.getFuture().isDone() ? 1 : 0) != 0);
        boolean isResAvailble = result.process();
        Assert.assertFalse((boolean)isResAvailble);
        currentWaitingFuture.set(null);
        isResAvailble = result.process();
        Assert.assertTrue((boolean)isResAvailble);
    }

    private static GroupByHash createGroupByHash(List<Type> partitionTypes, List<Integer> partitionChannels) {
        return GroupByHash.createGroupByHash(partitionTypes, (int[])Ints.toArray(partitionChannels), Optional.empty(), (int)1, (boolean)false, (JoinCompiler)new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()), (UpdateMemory)UpdateMemory.NOOP);
    }

    private static List<Page> generatePages(int groupCount, int rowsPerGroup, int rowsPerPage) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        RowPagesBuilder pagesBuilder = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types);
        int nextVal = 0;
        int nextGroup = 0;
        int totalRows = 0;
        for (int i = 0; i < groupCount; ++i) {
            for (int j = 0; j < rowsPerGroup; ++j) {
                pagesBuilder.row(nextGroup++, nextVal++, "Unit test written during times of increased intensity");
                if (totalRows++ % rowsPerPage != 0) continue;
                pagesBuilder.pageBreak();
            }
        }
        return pagesBuilder.build();
    }

    private static /* synthetic */ InMemoryGroupedTopNBuilder lambda$testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked$11(List types, boolean produceRowNumbers, LocalMemoryContext revocableMemoryContext, Supplier groupByHashSupplier) {
        return new InMemoryGroupedTopNBuilder(types, (PageWithPositionComparator)new SimplePageWithPositionComparator(types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 4, produceRowNumbers, revocableMemoryContext, (GroupByHash)groupByHashSupplier.get());
    }

    private static /* synthetic */ InMemoryGroupedTopNBuilder lambda$testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked$10(List types, boolean produceRowNumbers, LocalMemoryContext revocableMemoryContext, Supplier groupByHashSupplier) {
        return new InMemoryGroupedTopNBuilder(types, (PageWithPositionComparator)new SimplePageWithPositionComparator(types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 4, produceRowNumbers, revocableMemoryContext, (GroupByHash)groupByHashSupplier.get());
    }

    private static /* synthetic */ GroupByHash lambda$testThatBuilderYieldsDuringBuildResultAndResumesWhenUnblocked$9(List types, 1MemoryFuture memoryWaitingFuture) {
        return GroupByHash.createGroupByHash((List)ImmutableList.of(types.get(0)), (int[])Ints.toArray((Collection)ImmutableList.of((Object)0)), Optional.empty(), (int)1, (boolean)false, (JoinCompiler)new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()), () -> {
            return memoryWaitingFuture.getFuture().isDone();
        });
    }

    private static /* synthetic */ InMemoryGroupedTopNBuilder lambda$testNoSpilling$6(List types, boolean produceRowNumbers, LocalMemoryContext revocableMemoryContext, Supplier groupByHashSupplier) {
        return new InMemoryGroupedTopNBuilder(types, (PageWithPositionComparator)new SimplePageWithPositionComparator(types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 4, produceRowNumbers, revocableMemoryContext, (GroupByHash)groupByHashSupplier.get());
    }

    private static /* synthetic */ InMemoryGroupedTopNBuilder lambda$testNoSpilling$5(List types, boolean produceRowNumbers, LocalMemoryContext revocableMemoryContext, Supplier groupByHashSupplier) {
        return new InMemoryGroupedTopNBuilder(types, (PageWithPositionComparator)new SimplePageWithPositionComparator(types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 4, produceRowNumbers, revocableMemoryContext, (GroupByHash)groupByHashSupplier.get());
    }

    private static /* synthetic */ GroupByHash lambda$testNoSpilling$4(List types) {
        return TestSpillableGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of(types.get(0)), (List<Integer>)ImmutableList.of((Object)0));
    }

    private static /* synthetic */ InMemoryGroupedTopNBuilder lambda$testThatRevokeSpillsDuringAddInput$2(List types, boolean produceRowNumbers, LocalMemoryContext revocableMemoryContext, Supplier groupByHashSupplier) {
        return new InMemoryGroupedTopNBuilder(types, (PageWithPositionComparator)new SimplePageWithPositionComparator(types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 4, produceRowNumbers, revocableMemoryContext, (GroupByHash)groupByHashSupplier.get());
    }

    private static /* synthetic */ InMemoryGroupedTopNBuilder lambda$testThatRevokeSpillsDuringAddInput$1(List types, boolean produceRowNumbers, LocalMemoryContext revocableMemoryContext, Supplier groupByHashSupplier) {
        return new InMemoryGroupedTopNBuilder(types, (PageWithPositionComparator)new SimplePageWithPositionComparator(types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 4, produceRowNumbers, revocableMemoryContext, (GroupByHash)groupByHashSupplier.get());
    }

    private static /* synthetic */ GroupByHash lambda$testThatRevokeSpillsDuringAddInput$0(List types) {
        return TestSpillableGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of(types.get(0)), (List<Integer>)ImmutableList.of((Object)0));
    }
}

