/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.WorkProcessor;
import com.google.common.util.concurrent.SettableFuture;
import org.testng.Assert;

public final class WorkProcessorAssertion {
    private WorkProcessorAssertion() {
    }

    public static <T> void assertBlocks(WorkProcessor<T> processor) {
        Assert.assertFalse((boolean)processor.process());
        Assert.assertTrue((boolean)processor.isBlocked());
        Assert.assertFalse((boolean)processor.isFinished());
        Assert.assertFalse((boolean)processor.process());
    }

    public static <T, V> void assertUnblocks(WorkProcessor<T> processor, SettableFuture<V> future) {
        future.set(null);
        Assert.assertFalse((boolean)processor.isBlocked());
    }

    public static <T> void assertYields(WorkProcessor<T> processor) {
        Assert.assertFalse((boolean)processor.process());
        Assert.assertFalse((boolean)processor.isBlocked());
        Assert.assertFalse((boolean)processor.isFinished());
    }

    public static <T> void assertResult(WorkProcessor<T> processor, T result) {
        Assert.assertTrue((boolean)processor.process());
        Assert.assertFalse((boolean)processor.isBlocked());
        Assert.assertFalse((boolean)processor.isFinished());
        Assert.assertEquals((Object)processor.getResult(), result);
    }

    public static <T> void assertFinishes(WorkProcessor<T> processor) {
        Assert.assertTrue((boolean)processor.process());
        Assert.assertFalse((boolean)processor.isBlocked());
        Assert.assertTrue((boolean)processor.isFinished());
        Assert.assertTrue((boolean)processor.process());
    }
}

