/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.operator.aggregation.groupByAggregations.GroupByAggregationTestUtils;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.aggregation.GroupByIdBlock;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.internal.collections.Ints;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=7)
@Measurement(iterations=20)
public class BenchmarkGroupedTypedHistogram {
    @Benchmark
    public GroupedAccumulator testSharedGroupWithLargeBlocksRunner(Data data) {
        GroupedAccumulator groupedAccumulator = data.groupedAccumulator;
        for (int i = 0; i < data.numGroups; ++i) {
            GroupByIdBlock groupByIdBlock = data.groupByIdBlocks[i];
            Page page = data.pages[i];
            groupedAccumulator.addInput(groupByIdBlock, page);
        }
        return groupedAccumulator;
    }

    private static JavaAggregationFunctionImplementation getInternalAggregationFunctionVarChar(HistogramGroupImplementation groupMode) {
        FunctionAndTypeManager functionAndTypeManager = BenchmarkGroupedTypedHistogram.getMetadata(groupMode).getFunctionAndTypeManager();
        return functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("histogram", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
    }

    private static MetadataManager getMetadata(HistogramGroupImplementation groupMode) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager((FunctionsConfig)new FunctionsConfig().setHistogramGroupImplementation(groupMode));
        return metadata;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkGroupedTypedHistogram.class.getSimpleName() + ".*").addProfiler(GCProfiler.class).build();
        new Runner(options).run();
    }

    public static enum ProbeType {
        LINEAR,
        SUM_OF_COUNT,
        SUM_OF_SQUARE;

    }

    @State(value=Scope.Thread)
    public static class Data {
        @Param(value={"10000"})
        private int numGroups;
        @Param(value={"5000"})
        private int rowCount;
        @Param(value={"0.1"})
        private float distinctFraction;
        @Param(value={"32"})
        private int rowSize;
        @Param(value={"0.5f"})
        private float mainFillRatio;
        @Param(value={"0.5f"})
        private float valueStoreFillRatio;
        @Param(value={"NEW", "LEGACY"})
        private HistogramGroupImplementation histogramGroupImplementation;
        private final Random random = new Random();
        private Page[] pages;
        private GroupByIdBlock[] groupByIdBlocks;
        private GroupedAccumulator groupedAccumulator;

        @Setup
        public void setUp() throws Exception {
            this.pages = new Page[this.numGroups];
            this.groupByIdBlocks = new GroupByIdBlock[this.numGroups];
            for (int j = 0; j < this.numGroups; ++j) {
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 0; i < this.rowCount; ++i) {
                    boolean distinctValue;
                    String str = String.valueOf(i % 10);
                    String item = IntStream.range(0, this.rowSize).mapToObj(x -> str).collect(Collectors.joining());
                    boolean bl = distinctValue = this.random.nextDouble() < (double)this.distinctFraction;
                    if (distinctValue) {
                        valueList.add(j + "-" + item);
                        continue;
                    }
                    valueList.add(item);
                }
                Block block = BlockAssertions.createStringsBlock(valueList);
                Page page = new Page(new Block[]{block});
                GroupByIdBlock groupByIdBlock = AggregationTestUtils.createGroupByIdBlock(j, page.getPositionCount());
                this.pages[j] = page;
                this.groupByIdBlocks[j] = groupByIdBlock;
            }
            JavaAggregationFunctionImplementation aggregationFunction = BenchmarkGroupedTypedHistogram.getInternalAggregationFunctionVarChar(this.histogramGroupImplementation);
            this.groupedAccumulator = this.createGroupedAccumulator(aggregationFunction);
        }

        private GroupedAccumulator createGroupedAccumulator(JavaAggregationFunctionImplementation function) {
            int[] args = GroupByAggregationTestUtils.createArgs(function);
            return GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)function, (List)Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
        }
    }
}

