/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.stat.correlation.Covariance;

public class TestDoubleCovarianceSampAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 5, start + 5 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "covar_samp";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double", (Object)"double");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        return new Covariance().covariance(AggregationTestUtils.constructDoublePrimitiveArray(start + 5, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length), true);
    }
}

