/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestDoubleRegrAggregationFunction;
import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.testng.annotations.Test;

public class TestDoubleRegrR2Aggregation
extends AbstractTestDoubleRegrAggregationFunction {
    @Override
    protected String getFunctionName() {
        return "regr_r2";
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 0) {
            return null;
        }
        if (length == 1) {
            return 0.0;
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return regression.getRSquare();
    }

    @Test
    public void testTwoSpecialCase() {
        Double[] y = new Double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        Double[] x = new Double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        this.testAggregation(null, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
        x = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        this.testAggregation(1.0, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
    }

    @Override
    protected void testNonTrivialAggregation(Double[] y, Double[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i].doubleValue(), y[i].doubleValue());
        }
        double expected = regression.getRSquare();
        Preconditions.checkArgument((Double.isFinite(expected) && expected != 0.0 ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(expected, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
    }
}

