/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchAggregationState;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchStateSerializer;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;
import org.openjdk.jol.info.GraphLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestKllSketchStateSerializer {
    @Test
    public void testDouble() {
        this.testSerializer((Type)DoubleType.DOUBLE, () -> KllItemsSketch.newHeapInstance(Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe()), (Collection)DoubleStream.iterate(0.0, i -> i + 1.0).limit(10L).boxed().collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void testString() {
        this.testSerializer((Type)VarcharType.VARCHAR, () -> KllItemsSketch.newHeapInstance(String::compareTo, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe()), Arrays.asList("abcdefghijklmnopqrstuvwxyz".split("")));
    }

    @Test
    public void testBigint() {
        this.testSerializer((Type)BigintType.BIGINT, () -> KllItemsSketch.newHeapInstance(Long::compareTo, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe()), (Collection)LongStream.iterate(0L, i -> i + 1L).limit(10L).boxed().collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void testBoolean() {
        this.testSerializer((Type)BooleanType.BOOLEAN, () -> KllItemsSketch.newHeapInstance(Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe()), (Collection)LongStream.iterate(0L, i -> i + 1L).limit(10L).mapToObj(i -> i % 2L == 0L).collect(ImmutableList.toImmutableList()));
    }

    @Test
    public void testEstimatedMemorySizeDouble() {
        this.testEstimatedMemorySize((Type)DoubleType.DOUBLE, i -> (double)i, 0.05);
    }

    @Test
    public void testEstimatedMemorySizeLong() {
        this.testEstimatedMemorySize((Type)BigintType.BIGINT, i -> (long)i, 0.05);
    }

    @Test
    public void testEstimatedMemorySizeString() {
        this.testEstimatedMemorySize((Type)VarcharType.VARCHAR, i -> "abcdefghijklmnopqrstuvwxyz".substring(0, i.hashCode() % 26), 0.05);
    }

    @Test
    public void testEstimatedMemorySizeBoolean() {
        this.testEstimatedMemorySize((Type)BooleanType.BOOLEAN, i -> i % 2 == 0, 0.5);
    }

    private <T> void testEstimatedMemorySize(Type type, Function<Integer, T> generator, double tolerance) {
        KllSketchAggregationState.Single state = new KllSketchAggregationState.Single(type);
        KllSketchAggregationState.SketchParameters parameters = KllSketchAggregationState.getSketchParameters((Type)type);
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((Comparator)parameters.getComparator(), (ArrayOfItemsSerDe)parameters.getSerde());
        ImmutableList sizes = ImmutableList.of((Object)512, (Object)2048, (Object)4096, (Object)16384);
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            IntStream.range(0, size).boxed().map(generator).forEach(arg_0 -> ((KllItemsSketch)sketch).update(arg_0));
            long trueSize = GraphLayout.parseInstance((Object)sketch).totalSize();
            state.setSketch(sketch);
            long estimatedSize = state.getEstimatedSize();
            double errorPercent = (double)Math.abs(estimatedSize - trueSize) / (double)trueSize;
            Assert.assertTrue((errorPercent < tolerance ? 1 : 0) != 0, (String)String.format("estimated memory size error for sketch stream size %d was > 5%%: %.2f", size, errorPercent));
        }
    }

    private <T> void testSerializer(Type type, Supplier<KllItemsSketch<?>> sketchSupplier, Collection<T> sketchInputs) {
        KllSketchStateSerializer serializer = new KllSketchStateSerializer(type);
        KllSketchAggregationState.Single state = new KllSketchAggregationState.Single(type);
        state.setSketch(sketchSupplier.get());
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        serializer.serialize((KllSketchAggregationState)state, blockBuilder);
        KllSketchAggregationState.Single deserialized = new KllSketchAggregationState.Single(type);
        serializer.deserialize(blockBuilder.build(), 0, (KllSketchAggregationState)deserialized);
        KllItemsSketch sketch = state.getSketch();
        KllItemsSketch<?> actual = sketchSupplier.get();
        sketchInputs.stream().forEach(i -> {
            sketch.update(i);
            actual.update(i);
        });
        blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        state.setSketch(sketch);
        serializer.serialize((KllSketchAggregationState)state, blockBuilder);
        Block serializedBlock = blockBuilder.build();
        KllSketchAggregationState.Single newState = new KllSketchAggregationState.Single(type);
        serializer.deserialize(serializedBlock, 0, (KllSketchAggregationState)newState);
        TestKllSketchStateSerializer.verifySketches(actual, newState.getSketch());
    }

    private static void verifySketches(KllItemsSketch<?> expected, KllItemsSketch<?> actual) {
        Assert.assertEquals((long[])actual.getSortedView().getCumulativeWeights(), (long[])expected.getSortedView().getCumulativeWeights(), (String)"weights are not equal");
        Assert.assertEquals((Object[])actual.getSortedView().getQuantiles(), (Object[])expected.getSortedView().getQuantiles(), (String)"quantiles are not equal");
        Assert.assertEquals((byte[])actual.toByteArray(), (byte[])expected.toByteArray());
    }
}

