/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestRealRegrAggregationFunction;
import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public class TestRealRegrCountAggregation
extends AbstractTestRealRegrAggregationFunction {
    @Override
    protected String getFunctionName() {
        return "regr_count";
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return Float.valueOf(length);
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return Float.valueOf(regression.getN());
    }

    @Override
    protected void testNonTrivialAggregation(Float[] y, Float[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData((double)x[i].floatValue(), (double)y[i].floatValue());
        }
        float expected = regression.getN();
        Preconditions.checkArgument((Float.isFinite(expected) && expected != 0.0f ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(Float.valueOf(expected), BlockAssertions.createBlockOfReals(y), BlockAssertions.createBlockOfReals(x));
    }
}

