/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestRealRegrAggregationFunction;
import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.testng.annotations.Test;

public class TestRealRegrR2Aggregation
extends AbstractTestRealRegrAggregationFunction {
    @Override
    protected String getFunctionName() {
        return "regr_r2";
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 0) {
            return null;
        }
        if (length == 1) {
            return Float.valueOf(0.0f);
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return Float.valueOf((float)regression.getRSquare());
    }

    @Test
    public void testTwoSpecialCase() {
        Float[] y = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
        Float[] x = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
        this.testAggregation(null, BlockAssertions.createBlockOfReals(y), BlockAssertions.createBlockOfReals(x));
        x = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)};
        this.testAggregation(Float.valueOf(1.0f), BlockAssertions.createBlockOfReals(y), BlockAssertions.createBlockOfReals(x));
    }

    @Override
    protected void testNonTrivialAggregation(Float[] y, Float[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData((double)x[i].floatValue(), (double)y[i].floatValue());
        }
        float expected = (float)regression.getRSquare();
        Preconditions.checkArgument((Float.isFinite(expected) && expected != 0.0f ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(Float.valueOf(expected), BlockAssertions.createBlockOfReals(y), BlockAssertions.createBlockOfReals(x));
    }
}

