/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamSummary;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestStreamSummary {
    private static final Type INT_SERIALIZED_TYPE = RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)));
    private static final Type VARCHAR_SERIALIZED_TYPE = RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)BigintType.BIGINT)));
    private static final int TEST_COMPACT_THRESHOLD_BYTES = 10;
    private static final int TEST_COMPACT_THRESHOLD_RATIO = 2;

    @DataProvider(name="streamLongDataProvider")
    private Object[][] streamLongDataProvider() {
        return new Object[][]{{new Long[]{1L, 1L, 2L, 3L, 4L}, 3, 15, ImmutableMap.of((Object)1L, (Object)2L, (Object)2L, (Object)1L, (Object)3L, (Object)1L)}, {new Long[]{14L, 14L, 11L, 13L, 13L, 13L, 14L, 14L}, 2, 4, ImmutableMap.of((Object)14L, (Object)4L, (Object)13L, (Object)3L)}, {new Long[]{80L, 54L, 32L, 4L, 67L, 68L, 68L, 15L, 38L, 30L}, 2, 4, ImmutableMap.of((Object)68L, (Object)3L, (Object)30L, (Object)3L)}, {new Long[]{29L, 51L, 84L, 60L, 32L, 54L, 82L, 30L, 53L, 57L}, 2, 3, ImmutableMap.of((Object)57L, (Object)4L, (Object)30L, (Object)3L)}};
    }

    @DataProvider(name="streamSliceDataProvider")
    private Object[][] streamStringDataProvider() {
        return new Object[][]{{new Slice[]{Slices.utf8Slice((String)"A"), Slices.utf8Slice((String)"A"), Slices.utf8Slice((String)"B"), Slices.utf8Slice((String)"C"), Slices.utf8Slice((String)"D")}, 3, 15, ImmutableMap.of((Object)Slices.utf8Slice((String)"A"), (Object)2L, (Object)Slices.utf8Slice((String)"B"), (Object)1L, (Object)Slices.utf8Slice((String)"C"), (Object)1L)}, {new Slice[]{Slices.utf8Slice((String)"1"), Slices.utf8Slice((String)"1"), Slices.utf8Slice((String)"2"), Slices.utf8Slice((String)"3"), Slices.utf8Slice((String)"4")}, 3, 15, ImmutableMap.of((Object)Slices.utf8Slice((String)"1"), (Object)2L, (Object)Slices.utf8Slice((String)"2"), (Object)1L, (Object)Slices.utf8Slice((String)"3"), (Object)1L)}, {new Slice[]{Slices.utf8Slice((String)"14"), Slices.utf8Slice((String)"14"), Slices.utf8Slice((String)"11"), Slices.utf8Slice((String)"13"), Slices.utf8Slice((String)"13"), Slices.utf8Slice((String)"13"), Slices.utf8Slice((String)"14"), Slices.utf8Slice((String)"14")}, 2, 4, ImmutableMap.of((Object)Slices.utf8Slice((String)"14"), (Object)4L, (Object)Slices.utf8Slice((String)"13"), (Object)3L)}, {new Slice[]{Slices.utf8Slice((String)"80"), Slices.utf8Slice((String)"54"), Slices.utf8Slice((String)"32"), Slices.utf8Slice((String)"4"), Slices.utf8Slice((String)"67"), Slices.utf8Slice((String)"68"), Slices.utf8Slice((String)"68"), Slices.utf8Slice((String)"15"), Slices.utf8Slice((String)"38"), Slices.utf8Slice((String)"30")}, 2, 4, ImmutableMap.of((Object)Slices.utf8Slice((String)"68"), (Object)3L, (Object)Slices.utf8Slice((String)"30"), (Object)3L)}};
    }

    @Test(dataProvider="streamLongDataProvider")
    public void testLongHistogram(Long[] dataStream, int maxBuckets, int capacity, Map<Long, Long> expectedSummary) {
        Block longsBlock = BlockAssertions.createLongsBlock(dataStream);
        StreamSummary streamSummary = this.buildStreamSummary((Type)BigintType.BIGINT, maxBuckets, capacity);
        for (int pos = 0; pos < dataStream.length; ++pos) {
            streamSummary.add(longsBlock, pos, 1L);
        }
        Map<Long, Long> buckets = this.getMapForLongType(streamSummary);
        Assert.assertEquals((int)buckets.size(), (int)expectedSummary.size());
        Assert.assertEquals(buckets, expectedSummary);
        BlockBuilder blockBuilder = INT_SERIALIZED_TYPE.createBlockBuilder(null, 10);
        streamSummary.serialize(blockBuilder);
        StreamSummary deserialize = StreamSummary.deserialize((Type)BigintType.BIGINT, (Block)((Block)INT_SERIALIZED_TYPE.getObject((Block)blockBuilder, 0)));
        Map<Long, Long> deserializedMap = this.getMapForLongType(deserialize);
        Assert.assertEquals(buckets, deserializedMap);
    }

    @Test(dataProvider="streamSliceDataProvider")
    public void testStringHistogram(Slice[] dataStream, int maxBuckets, int capacity, Map<Slice, Long> expectedSummary) {
        Block slicesBlock = BlockAssertions.createSlicesBlock(dataStream);
        StreamSummary streamSummary = this.buildStreamSummary((Type)VarcharType.VARCHAR, maxBuckets, capacity);
        for (int pos = 0; pos < dataStream.length; ++pos) {
            streamSummary.add(slicesBlock, pos, 1L);
        }
        Map<Slice, Long> buckets = this.getMapFromStreamSummaryOfSlices(streamSummary);
        Assert.assertEquals((int)buckets.size(), (int)expectedSummary.size());
        Assert.assertEquals(buckets, expectedSummary);
        BlockBuilder blockBuilder = VARCHAR_SERIALIZED_TYPE.createBlockBuilder(null, 10);
        streamSummary.serialize(blockBuilder);
        StreamSummary deserialize = StreamSummary.deserialize((Type)VarcharType.VARCHAR, (Block)((Block)VARCHAR_SERIALIZED_TYPE.getObject((Block)blockBuilder, 0)));
        Map<Slice, Long> deserializedMap = this.getMapFromStreamSummaryOfSlices(deserialize);
        Assert.assertEquals(buckets, deserializedMap);
    }

    @Test
    public void testMerge() {
        StreamSummary histogram1 = new StreamSummary((Type)BigintType.BIGINT, 3, 15);
        Long[] values = new Long[]{1L, 1L, 2L};
        int pos = 0;
        Block longsBlock = BlockAssertions.createLongsBlock(values);
        for (int i = 0; i < values.length; ++i) {
            histogram1.add(longsBlock, pos++, 1L);
        }
        StreamSummary histogram2 = new StreamSummary((Type)BigintType.BIGINT, 3, 15);
        values = new Long[]{3L, 4L};
        pos = 0;
        longsBlock = BlockAssertions.createLongsBlock(values);
        for (int i = 0; i < values.length; ++i) {
            histogram2.add(longsBlock, pos++, 1L);
        }
        histogram1.merge(histogram2);
        Map<Long, Long> buckets = this.getMapForLongType(histogram1);
        Assert.assertEquals((int)buckets.size(), (int)3);
        Assert.assertEquals(buckets, (Map)ImmutableMap.of((Object)1L, (Object)2L, (Object)2L, (Object)1L, (Object)3L, (Object)1L));
    }

    private StreamSummary buildStreamSummary(Type type, int maxBuckets, int hashCapacity) {
        StreamSummary histogram = new StreamSummary(type, maxBuckets, hashCapacity){

            protected boolean shouldCompact(long sizeInBytes, int numberOfPositionInBlock) {
                return sizeInBytes >= 10L && numberOfPositionInBlock / this.getHeapSize() >= 2;
            }
        };
        return histogram;
    }

    private Map<Long, Long> getMapForLongType(StreamSummary histogram) {
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 10);
        histogram.topK(blockBuilder);
        Block object = mapType.getObject((Block)blockBuilder, 0);
        Map<Long, Long> buckets = this.getMapFromLongBucket(object);
        return buckets;
    }

    public Map<Long, Long> getMapFromLongBucket(Block block) {
        ImmutableMap.Builder buckets = new ImmutableMap.Builder();
        for (int pos = 0; pos < block.getPositionCount(); pos += 2) {
            buckets.put((Object)block.getLong(pos), (Object)block.getLong(pos + 1));
        }
        return buckets.build();
    }

    public Map<Slice, Long> getMapFromSliceBucket(Block block) {
        ImmutableMap.Builder buckets = new ImmutableMap.Builder();
        for (int pos = 0; pos < block.getPositionCount(); pos += 2) {
            buckets.put((Object)VarcharType.VARCHAR.getSlice(block, pos), (Object)block.getLong(pos + 1));
        }
        return buckets.build();
    }

    private Map<Slice, Long> getMapFromStreamSummaryOfSlices(StreamSummary streamSummary) {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 10);
        streamSummary.topK(blockBuilder);
        Block object = mapType.getObject((Block)blockBuilder, 0);
        Map<Slice, Long> buckets = this.getMapFromSliceBucket(object);
        return buckets;
    }
}

