/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.minmaxby;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMinMaxByNAggregation {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testMaxDoubleDouble() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(new Double[]{null}), new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(3.0, 5.0), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(1.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, null, null), BlockAssertions.createDoublesBlock(null, 0.0, null, null), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(1.0), new Block[]{BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createRLEBlock(2L, 1)});
        AggregationTestUtils.assertAggregation(function, null, new Block[]{BlockAssertions.createDoublesBlock(new Double[0]), BlockAssertions.createDoublesBlock(new Double[0]), BlockAssertions.createRLEBlock(2L, 0)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.5), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(1L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.5, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinDoubleDouble() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(new Double[]{null}), new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(5.0, 3.0), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(1L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.0, (Object)5.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinDoubleVarchar() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"z", (Object)"a"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxDoubleVarchar() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createDoublesBlock(1.0, 2.0, null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"bb", (Object)"hi"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"hi", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinVarcharDouble() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)-1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)-1.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxVarcharDouble() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, null), BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)0.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)0.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinVarcharArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)4L, (Object)5L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)ImmutableList.of((Object)4L, (Object)5L))), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxVarcharArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)3L, (Object)4L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)ImmutableList.of((Object)4L, (Object)5L))), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinArrayVarchar() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"b", (Object)"x", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)2L))), BlockAssertions.createRLEBlock(3L, 4)});
    }

    @Test
    public void testMaxArrayVarchar() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"z", (Object)"x"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)2L))), BlockAssertions.createRLEBlock(3L, 4)});
    }

    @Test
    public void testOutOfBound() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT});
        try {
            AggregationTestUtils.groupedAggregation(function, new Page(new Block[]{BlockAssertions.createStringsBlock("z"), BlockAssertions.createLongsBlock(0), BlockAssertions.createLongsBlock(10001)}));
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"third argument of max_by/min_by must be less than or equal to 10000; found 10001");
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Count argument is not constant: found multiple values \\[3, 2]")
    public void testInconsistentN() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        AggregationTestUtils.groupedAggregation(function, new Page(new Block[]{BlockAssertions.createDoublesBlock(3.0, 2.0, 1.0), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createLongsBlock(2L, 2L, 3L)}));
    }

    private JavaAggregationFunctionImplementation getMaxByAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("max_by", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }

    private JavaAggregationFunctionImplementation getMinByAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("min_by", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

