/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.TestNoisyAggregationUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNoisySumGaussianShortDecimalAggregation
extends AbstractTestFunctions {
    private static final String FUNCTION_NAME = "noisy_sum_gaussian";
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)18, (int)0);
    private static final double DEFAULT_TEST_STANDARD_DEVIATION = 1.0;
    private static final BiFunction<Object, Object, Boolean> equalDoubleAssertion = (actual, expected) -> Math.abs(new Double(actual.toString()) - new Double(expected.toString())) <= 1.0E-12;

    @Test
    public void testNoisySumGaussianDecimalDefinitions() {
        this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE});
        this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testNoisySumGaussianShortDecimalInvalidNoiseScale() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        double expected = TestNoisyAggregationUtils.sumLong(values);
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale) with noiseScale < 0 which means errors", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(-123.0, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalZeroNoiseScale() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        double expected = TestNoisyAggregationUtils.sumLong(values);
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(0.0, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalZeroNoiseScaleWithNull() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1L, true);
        double expected = TestNoisyAggregationUtils.sumLong(values);
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale) with noiseScale=0 and 1 null row which means no noise", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(0.0, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalSomeNoiseScale() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        double expected = TestNoisyAggregationUtils.sumLong(values);
        AggregationTestUtils.assertAggregation(noisySumGaussian, TestNoisyAggregationUtils.notEqualDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale) with noiseScale > 0 which means some noise", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(1.0, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalSomeNoiseScaleWithinSomeStd() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE});
        BiFunction<Object, Object, Boolean> withinSomeStdAssertion = (actual, expected) -> {
            double actualValue = new Double(actual.toString());
            double expectedValue = new Double(expected.toString());
            return expectedValue - 50.0 <= actualValue && actualValue <= expectedValue + 50.0;
        };
        int numRows = 1000;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        double expected2 = TestNoisyAggregationUtils.sumLong(values);
        AggregationTestUtils.assertAggregation(noisySumGaussian, withinSomeStdAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale) within some std from mean", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(1.0, numRows)}), expected2);
    }

    @Test
    public void testNoisySumGaussianLongDecimalNoiseScaleVsNormalSum() {
        int numRows = 10;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("decimal");
        String query1 = String.format("SELECT SUM(%s) FROM %s", columnName, data);
        String query2 = String.format("SELECT %s(%s, %f) FROM %s", FUNCTION_NAME, columnName, 0.0, data);
        List<MaterializedRow> actualRows = this.runQuery(query1);
        double result1 = Double.parseDouble(actualRows.get(0).getField(0).toString());
        actualRows = this.runQuery(query2);
        double result2 = Double.parseDouble(actualRows.get(0).getField(0).toString());
        Assert.assertEquals((double)result2, (double)result1);
    }

    @Test
    public void testNoisySumGaussianShortDecimalClippingZeroNoiseScale() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 47.0;
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, lower, upper) with noiseScale=0 which means no noise, and clipping", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testNoisySumGaussianShortDecimalClippingInvalidBound() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, false);
        double lower = 2.0;
        double upper = -8.0;
        double expected = 45.0;
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, lower, upper) with clipping lower > upper ", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalClippingZeroNoiseScaleWithNull() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1L, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 45.0;
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, lower, upper) with noiseScale=0 which means no noise, and clipping, with null values", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalClippingSomeNoiseScale() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1L, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 45.0;
        AggregationTestUtils.assertAggregation(noisySumGaussian, TestNoisyAggregationUtils.notEqualDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, lower, upper) with noiseScale > 0 which means some noise", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(1.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalClippingSomeNoiseScaleWithinSomeStd() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        BiFunction<Object, Object, Boolean> withinSomeStdDoubleAssertion = (actual, expected) -> {
            double actualValue = new Double(actual.toString());
            double expectedValue = new Double(expected.toString());
            return expectedValue - 50.0 <= actualValue && actualValue <= expectedValue + 50.0;
        };
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1L, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected2 = 45.0;
        AggregationTestUtils.assertAggregation(noisySumGaussian, withinSomeStdDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, lower, upper) within some std from mean", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(1.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected2);
    }

    @Test
    public void testNoisySumGaussianShortDecimalClippingRandomSeed() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, false);
        double lower = 2.0;
        double upper = 5.0;
        double expected = 48.4961467597545;
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, lower, upper, randomSeed)", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(12.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianLongDecimalNoInputRowsWithoutGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("decimal");
        String query = "SELECT noisy_sum_gaussian(" + columnName + ", 0) + 1 FROM " + data + " WHERE false";
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)1);
        Assert.assertNull((Object)actualRows.get(0).getField(0));
    }

    @Test
    public void testNoisySumGaussianLongDecimalNoInputRowsWithGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("decimal");
        String query = "SELECT noisy_sum_gaussian(" + columnName + ", 0) + 1 FROM " + data + " WHERE false GROUP BY " + columnName;
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)0);
    }

    @Test
    public void testNoisySumGaussianShortDecimalZeroNoiseScaleZeroRandomSeed() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1L, false);
        double expected = TestNoisyAggregationUtils.sumLong(values);
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, randomSeed) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(0L, numRows)}), expected);
    }

    @Test
    public void testNoisySumGaussianShortDecimalSomeNoiseScaleFixedRandomSeed() {
        JavaAggregationFunctionImplementation noisySumGaussian = this.getFunction(new Type[]{SHORT_DECIMAL_TYPE, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1L, false);
        AggregationTestUtils.assertAggregation(noisySumGaussian, equalDoubleAssertion, "Test noisy_sum_gaussian(short decimal, noiseScale, randomSeed) with noiseScale=0 which means no noise and a random seed", new Page(new Block[]{BlockAssertions.createShortDecimalsBlock(TestNoisyAggregationUtils.toNullableStringList(values)), BlockAssertions.createRLEBlock(12.0, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), 55.496146759754);
    }

    private List<MaterializedRow> runQuery(String query) {
        LocalQueryRunner runner = new LocalQueryRunner(this.session);
        MaterializedResult actualResults = runner.execute(query).toTestTypes();
        return actualResults.getMaterializedRows();
    }

    private JavaAggregationFunctionImplementation getFunction(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(FUNCTION_NAME, TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

