/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.reservoirsample;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class TestReservoirSampleAggregation {
    protected FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();

    @Test
    public void testNoInitialSample() {
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)5L, (Object)ImmutableList.of((Object)1.0, (Object)1.0)), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.nullBlock(), 5), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(0L), 5), TestReservoirSampleAggregation.doubleBlock(1.0, 1.0, 1.0, 1.0, 1.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(2), 5));
    }

    @Test
    public void testLarge() {
        int sampleSize = 5000;
        int inputSize = 15000;
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)inputSize, IntStream.range(0, sampleSize).mapToObj(x -> 1.0).collect(Collectors.toList())), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.nullBlock(), inputSize), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(0L), inputSize), TestReservoirSampleAggregation.doubleBlock(IntStream.range(0, inputSize).mapToDouble(x -> 1.0).toArray()), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(sampleSize), inputSize));
    }

    @DataProvider(name="invalidSampleSize")
    public Object[][] invalidSampleParameters() {
        return new Object[][]{{0}, {-1}};
    }

    @Test(dataProvider="invalidSampleSize", expectedExceptions={IllegalArgumentException.class})
    @Parameters(value={"sampleSize"})
    public void testInvalidSampleSize(int sampleSize) {
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)-1L, (Object)ImmutableList.of((Object)1.0, (Object)1.0)), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.nullBlock(), 5), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(0L), 5), TestReservoirSampleAggregation.doubleBlock(1.0, 1.0, 1.0, 1.0, 1.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(sampleSize), 5));
    }

    @Test
    public void testInitialSampleSameSize() {
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)15L, (Object)ImmutableList.of((Object)1.0, (Object)1.0)), TestReservoirSampleAggregation.arrayOfBlock((Type)DoubleType.DOUBLE, TestReservoirSampleAggregation.doubleArrayBlock(1.0, 1.0), 5), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(10L), 5), TestReservoirSampleAggregation.doubleBlock(1.0, 1.0, 1.0, 1.0, 1.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(2), 5));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitialSampleWrongSize() {
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)15L, (Object)ImmutableList.of((Object)1.0, (Object)1.0)), TestReservoirSampleAggregation.arrayOfBlock((Type)DoubleType.DOUBLE, TestReservoirSampleAggregation.doubleArrayBlock(1.0, 1.0, 2.0), 5), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(10L), 5), TestReservoirSampleAggregation.doubleBlock(1.0, 1.0, 1.0, 1.0, 1.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(2), 5));
    }

    @Test
    public void testInitialSampleSmallerThanMaxSize() {
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)6L, (Object)ImmutableList.of((Object)1.0, (Object)1.0)), TestReservoirSampleAggregation.arrayOfBlock((Type)DoubleType.DOUBLE, TestReservoirSampleAggregation.doubleArrayBlock(1.0), 5), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(1L), 5), TestReservoirSampleAggregation.doubleBlock(1.0, 1.0, 1.0, 1.0, 1.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(2), 5));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitialSampleSeenCountSmallerThanInitialSample() {
        AggregationTestUtils.assertAggregation(this.getDoubleFunction(), (Object)ImmutableList.of((Object)6L, (Object)ImmutableList.of((Object)1.0, (Object)1.0)), TestReservoirSampleAggregation.arrayOfBlock((Type)DoubleType.DOUBLE, TestReservoirSampleAggregation.doubleArrayBlock(1.0, 1.0), 5), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(1L), 5), TestReservoirSampleAggregation.doubleBlock(1.0, 1.0, 1.0, 1.0, 1.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(2), 5));
    }

    @Test
    public void testValidResults() {
        Object result = AggregationTestUtils.executeAggregation(this.getDoubleFunction(), TestReservoirSampleAggregation.copyBlock((Type)UnknownType.UNKNOWN, TestReservoirSampleAggregation.nullBlock(), 10), TestReservoirSampleAggregation.copyBlock((Type)BigintType.BIGINT, TestReservoirSampleAggregation.bigintBlock(0L), 10), TestReservoirSampleAggregation.doubleBlock(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0), TestReservoirSampleAggregation.copyBlock((Type)IntegerType.INTEGER, TestReservoirSampleAggregation.intBlock(4), 10));
        Set items = IntStream.range(0, 10).boxed().map(Integer::doubleValue).collect(Collectors.toSet());
        Assert.assertTrue((boolean)(result instanceof List));
        List resultItems = (List)result;
        Long processedCount = (Long)resultItems.get(0);
        Assert.assertEquals((Object)processedCount, (Object)items.size());
        List sample = (List)resultItems.get(1);
        Assert.assertTrue((boolean)items.containsAll(sample));
    }

    private JavaAggregationFunctionImplementation getFunction(Type ... arguments) {
        return this.functionAndTypeManager.getJavaAggregateFunctionImplementation(this.functionAndTypeManager.lookupFunction("reservoir_sample", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }

    private JavaAggregationFunctionImplementation getDoubleFunction() {
        return this.getFunction(new Type[]{new ArrayType((Type)DoubleType.DOUBLE), BigintType.BIGINT, DoubleType.DOUBLE, IntegerType.INTEGER});
    }

    private static Block bigintBlock(long value) {
        return BigintType.BIGINT.createBlockBuilder(null, 1).writeLong(value).build();
    }

    private static Block intBlock(int ... values) {
        BlockBuilder blockBuilder = IntegerType.INTEGER.createBlockBuilder(null, values.length);
        Arrays.stream(values).forEach(value -> IntegerType.INTEGER.writeLong(blockBuilder, (long)value));
        return blockBuilder.build();
    }

    private static Block doubleBlock(double ... values) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, values.length);
        Arrays.stream(values).forEach(value -> DoubleType.DOUBLE.writeDouble(blockBuilder, value));
        return blockBuilder.build();
    }

    private static Block doubleArrayBlock(double ... values) {
        BlockBuilder builder = DoubleType.DOUBLE.createBlockBuilder(null, values.length);
        Arrays.stream(values).forEach(value -> DoubleType.DOUBLE.writeDouble(builder, value));
        return builder.build();
    }

    private static Block arrayOfBlock(Type innerType, Block value, int count) {
        ArrayType arrayType = new ArrayType(innerType);
        BlockBuilder builder = arrayType.createBlockBuilder(null, count);
        for (int i = 0; i < count; ++i) {
            builder.appendStructure(value);
        }
        return builder.build();
    }

    private static Block nullBlock() {
        return DoubleType.DOUBLE.createBlockBuilder(null, 1).appendNull().build();
    }

    private static Block copyBlock(Type type, Block value, int positionCount) {
        BlockBuilder builder = type.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            type.appendTo(value, 0, builder);
        }
        return builder.build();
    }
}

