/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testng.annotations.Test;

public class TestArrayIntersectFunction
extends AbstractTestFunctions {
    @Test
    public void testVarchar() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[CAST('x' as VARCHAR), 'y', 'z'], ARRAY['x', 'y'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"x", (Object)"y"));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc'], ARRAY ['abc', 'bcd'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc"));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc', 'abc'], ARRAY ['abc', 'abc'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc"));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['foo', 'bar', 'baz'], ARRAY ['foo', 'test', 'bar'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"foo", (Object)"bar"));
    }

    @Test
    public void testBigint() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[CAST(1 as BIGINT), 5, 3], ARRAY[5])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [CAST(5 AS BIGINT), CAST(5 AS BIGINT)], ARRAY [CAST(1 AS BIGINT), CAST(5 AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L));
    }

    @Test
    public void testInteger() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[1, 5, 3], ARRAY[3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5], ARRAY [5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1, 2, 5, 5, 6], ARRAY [5, 5, 6, 6, 7, 8])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5, (Object)6));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [IF (RAND() < 1.0E0, 7, 1) , 2], ARRAY [7])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)7));
    }

    @Test
    public void testDouble() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1, 5], ARRAY [1.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1.0E0, 5.0E0], ARRAY [5.0E0, 5.0E0, 6.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.0));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [8.3E0, 1.6E0, 4.1E0, 5.2E0], ARRAY [4.0E0, 5.2E0, 8.3E0, 9.7E0, 3.5E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.2, (Object)8.3));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5.1E0, 7, 3.0E0, 4.8E0, 10], ARRAY [6.5E0, 10.0E0, 1.9E0, 5.1E0, 3.9E0, 4.8E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)10.0, (Object)5.1, (Object)4.8));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[1.1E0, 5.4E0, 3.9E0], ARRAY[5, 5.4E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.4));
    }

    @Test
    public void testDecimal() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY [2.3, 2.3, 2.2], ARRAY[2.2, 2.3])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayIntersectFunction.decimal("2.3"), (Object)TestArrayIntersectFunction.decimal("2.2")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [2.330, 1.900, 2.330], ARRAY [2.3300, 1.9000])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)5, (int)4)), ImmutableList.of((Object)TestArrayIntersectFunction.decimal("2.3300"), (Object)TestArrayIntersectFunction.decimal("1.9000")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [2, 3], ARRAY[2.0, 3.0])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)11, (int)1)), ImmutableList.of((Object)TestArrayIntersectFunction.decimal("00000000002.0"), (Object)TestArrayIntersectFunction.decimal("00000000003.0")));
    }

    @Test
    public void testBoolean() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true], ARRAY [true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, false], ARRAY [true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, true], ARRAY [true, true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[true, false, null], ARRAY[true, null])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true, null));
    }

    @Test
    public void testRow() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 456), (123, 789)], ARRAY[(123, 456), (123, 456), (123, 789)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))), ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, 789)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[ARRAY[123, 456], ARRAY[123, 789]], ARRAY[ARRAY[123, 456], ARRAY[123, 456], ARRAY[123, 789]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, 789)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'cde')], ARRAY[(123, 'abc'), (123, 'cde')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, "cde")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'cde'), NULL], ARRAY[(123, 'abc'), (123, 'cde')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, "cde")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'cde'), NULL, NULL], ARRAY[(123, 'abc'), (123, 'cde'), NULL])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), Arrays.asList(Arrays.asList(123, "abc"), Arrays.asList(123, "cde"), null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'abc')], ARRAY[(123, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc')], ARRAY[(123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of());
    }

    @Test
    public void testIndeterminateRows() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, NULL)], ARRAY[(123, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, null)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(NULL, 'abc'), (123, 'abc')], ARRAY[(123, 'abc'),(NULL, 'abc')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(null, "abc"), Arrays.asList(123, "abc")));
    }

    @Test
    public void testIndeterminateArrays() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[ARRAY[123, 456], ARRAY[123, NULL]], ARRAY[ARRAY[123, 456], ARRAY[123, NULL]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, null)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[ARRAY[NULL, 456], ARRAY[123, 456]], ARRAY[ARRAY[123, 456],ARRAY[NULL, 456]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(null, 456), Arrays.asList(123, 456)));
    }

    @Test
    public void testUnboundedRetainedSize() {
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_INTERSECT(ARRAY ['foo', 'bar', 'baz'], ARRAY ['foo', 'test', 'bar'])");
    }

    @Test
    public void testEmptyArrays() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY[], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY[], ARRAY[1, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5, 6], ARRAY [])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc'], ARRAY [])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY ['abc', 'bcd'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [false])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of());
    }

    @Test
    public void testEmptyResults() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1], ARRAY [5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [CAST(1 AS BIGINT)], ARRAY [CAST(5 AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, true], ARRAY [false])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5], ARRAY [1.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("ARRAY_INTERSECT(NULL, NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_INTERSECT(ARRAY[NULL], NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_INTERSECT(NULL, ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_INTERSECT(ARRAY[NULL], ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Integer[]{null}));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[], ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY[NULL], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [NULL], ARRAY [NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0, 0, 1, NULL], ARRAY [0, 0, 1, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(0, 1, null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0, 0], ARRAY [0, 0, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)0));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [CAST(0 AS BIGINT), CAST(0 AS BIGINT)], ARRAY [CAST(0 AS BIGINT), NULL])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)0L));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0.0E0], ARRAY [NULL])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0.0E0, NULL], ARRAY [0.0E0, NULL])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(0.0, null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, true, false, false, NULL], ARRAY [true, false, false, NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true, false, null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [false, false], ARRAY [false, false, NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc'], ARRAY [NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [''], ARRAY ['', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), ImmutableList.of((Object)""));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['', NULL], ARRAY ['', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), Arrays.asList("", null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [NULL], ARRAY ['abc', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Collections.singletonList(null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc', NULL, 'xyz', NULL], ARRAY [NULL, 'abc', NULL, NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null));
    }

    @Test
    public void testDuplicates() {
        this.assertFunction("array_intersect(ARRAY[1, 5, 3, 5, 1], ARRAY[3, 3, 5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5, (Object)3));
        this.assertFunction("array_intersect(ARRAY[CAST(1 as BIGINT), 5, 5, 3, 3, 3, 1], ARRAY[3, 5])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L, (Object)3L));
        this.assertFunction("array_intersect(ARRAY[CAST('x' as VARCHAR), 'x', 'y', 'z'], ARRAY['x', 'y', 'x'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"x", (Object)"y"));
        this.assertFunction("array_intersect(ARRAY[true, false, null, true, false, null], ARRAY[true, true, true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true));
    }

    @Test
    public void testSqlFunctions() {
        this.assertFunction("array_intersect(ARRAY[ARRAY[1, 3, 5], ARRAY[2, 3, 5], ARRAY[3, 3, 3, 6]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("array_intersect(ARRAY[null, ARRAY[], ARRAY[1, 2, 3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("array_intersect(ARRAY[ARRAY[], null, ARRAY[1, 2, 3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("array_intersect(ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("array_intersect(null)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_intersect(ARRAY[ARRAY[], ARRAY[1, 2, 3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_intersect(ARRAY[ARRAY[1, 2, 3], null])", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("array_intersect(ARRAY[ARRAY[DOUBLE'1.1', DOUBLE'2.2', DOUBLE'3.3'], ARRAY[DOUBLE'1.1', DOUBLE'3.4'], ARRAY[DOUBLE'1.0', DOUBLE'1.1', DOUBLE'1.2']])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.1));
        this.assertFunction("array_intersect(ARRAY[ARRAY[ARRAY[1], ARRAY[2]], ARRAY[ARRAY[2], ARRAY[3]]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)2)));
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"x", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"y", (Type)DoubleType.DOUBLE)));
        String t = rowType.toString();
        this.assertFunction("array_intersect(ARRAY[ARRAY[CAST((1.0, 2.0) AS " + t + "), CAST((2.0, 3.0) AS " + t + ")], ARRAY[CAST((0.0, 1.0) AS " + t + "), CAST((1.0, 2.0) AS " + t + ")]])", (Type)new ArrayType((Type)rowType), ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0)));
    }
}

