/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixType;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestIpPrefixFunctions
extends AbstractTestFunctions {
    @DataProvider(name="public-ip-provider")
    public Object[] publicIpProvider() {
        return new Object[]{"6.7.8.9", "157.240.200.99", "8.8.8.8", "128.1.2.8", "2a03:2880:f031:12:face:b00c:0:2", "2600:1406:6c00::173c:ad43", "2607:f8b0:4007:818::2004"};
    }

    @DataProvider(name="private-ip-provider")
    public Object[][] privateIpProvider() {
        return new Object[][]{{"0.0.0.0"}, {"0.255.255.255"}, {"10.0.0.0"}, {"10.255.255.255"}, {"100.64.0.0"}, {"100.127.255.255"}, {"127.0.0.0"}, {"127.255.255.255"}, {"169.254.0.0"}, {"169.254.255.255"}, {"172.16.0.0"}, {"172.31.255.255"}, {"192.0.0.0"}, {"192.0.0.255"}, {"192.0.2.0"}, {"192.0.2.255"}, {"192.88.99.0"}, {"192.88.99.255"}, {"192.168.0.0"}, {"192.168.255.255"}, {"198.18.0.0"}, {"198.19.255.255"}, {"198.51.100.0"}, {"198.51.100.255"}, {"203.0.113.0"}, {"203.0.113.255"}, {"240.0.0.0"}, {"255.255.255.255"}, {"::"}, {"::"}, {"::1"}, {"::1"}, {"100::"}, {"100::ffff:ffff:ffff:ffff"}, {"64:ff9b:1::"}, {"64:ff9b:1:ffff:ffff:ffff:ffff:ffff"}, {"2001:2::"}, {"2001:2:0:ffff:ffff:ffff:ffff:ffff"}, {"2001:db8::"}, {"2001:db8:ffff:ffff:ffff:ffff:ffff:ffff"}, {"2001::"}, {"2001:1ff:ffff:ffff:ffff:ffff:ffff:ffff"}, {"5f00::"}, {"5f00:ffff:ffff:ffff:ffff:ffff:ffff:ffff"}, {"fe80::"}, {"febf:ffff:ffff:ffff:ffff:ffff:ffff:ffff"}, {"fc00::"}, {"fdff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"}, {"10.1.2.3"}, {"100.64.3.2"}, {"192.168.55.99"}, {"2001:0DB8:0000:0000:face:b00c:0000:0000"}, {"0100:0000:0000:0000:ffff:ffff:0000:0000"}};
    }

    @Test
    public void testIpAddressIpPrefix() {
        this.assertFunction("IP_PREFIX(IPADDRESS '1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX(IPADDRESS '1.2.3.4', 32)", (Type)IpPrefixType.IPPREFIX, "1.2.3.4/32");
        this.assertFunction("IP_PREFIX(IPADDRESS '1.2.3.4', 0)", (Type)IpPrefixType.IPPREFIX, "0.0.0.0/0");
        this.assertFunction("IP_PREFIX(IPADDRESS '::ffff:1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 64)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::/64");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 127)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::16/127");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 128)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::17/128");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 0)", (Type)IpPrefixType.IPPREFIX, "::/0");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '::ffff:1.2.3.4', -1)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '::ffff:1.2.3.4', 33)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '64:ff9b::10', -1)", "IPv6 subnet size must be in range [0, 128]");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '64:ff9b::10', 129)", "IPv6 subnet size must be in range [0, 128]");
    }

    @Test
    public void testStringIpPrefix() {
        this.assertFunction("IP_PREFIX('1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX('1.2.3.4', 32)", (Type)IpPrefixType.IPPREFIX, "1.2.3.4/32");
        this.assertFunction("IP_PREFIX('1.2.3.4', 0)", (Type)IpPrefixType.IPPREFIX, "0.0.0.0/0");
        this.assertFunction("IP_PREFIX('::ffff:1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 64)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::/64");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 127)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::16/127");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 128)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::17/128");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 0)", (Type)IpPrefixType.IPPREFIX, "::/0");
        this.assertInvalidFunction("IP_PREFIX('::ffff:1.2.3.4', -1)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX('::ffff:1.2.3.4', 33)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX('64:ff9b::10', -1)", "IPv6 subnet size must be in range [0, 128]");
        this.assertInvalidFunction("IP_PREFIX('64:ff9b::10', 129)", "IPv6 subnet size must be in range [0, 128]");
        this.assertInvalidCast("IP_PREFIX('localhost', 24)", "Cannot cast value to IPADDRESS: localhost");
        this.assertInvalidCast("IP_PREFIX('64::ff9b::10', 24)", "Cannot cast value to IPADDRESS: 64::ff9b::10");
        this.assertInvalidCast("IP_PREFIX('64:face:book::10', 24)", "Cannot cast value to IPADDRESS: 64:face:book::10");
        this.assertInvalidCast("IP_PREFIX('123.456.789.012', 24)", "Cannot cast value to IPADDRESS: 123.456.789.012");
    }

    @Test
    public void testIpSubnetMin() {
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '1.2.3.4/24')", (Type)IpAddressType.IPADDRESS, "1.2.3.0");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '1.2.3.4/32')", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/64')", (Type)IpAddressType.IPADDRESS, "64:ff9b::");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/127')", (Type)IpAddressType.IPADDRESS, "64:ff9b::16");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/128')", (Type)IpAddressType.IPADDRESS, "64:ff9b::17");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/0')", (Type)IpAddressType.IPADDRESS, "::");
    }

    @Test
    public void testIpSubnetMax() {
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '1.2.3.128/26')", (Type)IpAddressType.IPADDRESS, "1.2.3.191");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '192.168.128.4/32')", (Type)IpAddressType.IPADDRESS, "192.168.128.4");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '10.1.16.3/9')", (Type)IpAddressType.IPADDRESS, "10.127.255.255");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '2001:db8::16/127')", (Type)IpAddressType.IPADDRESS, "2001:db8::17");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '2001:db8::16/128')", (Type)IpAddressType.IPADDRESS, "2001:db8::16");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '64:ff9b::17/64')", (Type)IpAddressType.IPADDRESS, "64:ff9b::ffff:ffff:ffff:ffff");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '64:ff9b::17/72')", (Type)IpAddressType.IPADDRESS, "64:ff9b::ff:ffff:ffff:ffff");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '64:ff9b::17/0')", (Type)IpAddressType.IPADDRESS, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
    }

    @Test
    public void testIpSubnetRange() {
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '1.2.3.160/24')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"1.2.3.0", (Object)"1.2.3.255"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '1.2.3.128/31')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"1.2.3.128", (Object)"1.2.3.129"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '10.1.6.46/32')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"10.1.6.46", (Object)"10.1.6.46"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '10.1.6.46/0')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"0.0.0.0", (Object)"255.255.255.255"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '64:ff9b::17/64')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"64:ff9b::", (Object)"64:ff9b::ffff:ffff:ffff:ffff"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '64:ff9b::52f4/120')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"64:ff9b::5200", (Object)"64:ff9b::52ff"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '64:ff9b::17/128')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"64:ff9b::17", (Object)"64:ff9b::17"));
    }

    @Test
    public void testIsSubnetOf() {
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPADDRESS '1.2.3.129')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPADDRESS '1.2.5.1')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/32', IPADDRESS '1.2.3.128')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/0', IPADDRESS '192.168.5.1')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPADDRESS '64:ff9b::ffff:ff')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPADDRESS '64:ffff::17')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '192.168.3.131/26', IPPREFIX '192.168.3.144/30')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPPREFIX '1.2.5.1/30')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPPREFIX '1.2.3.128/26')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPPREFIX '64:ff9b::ff:25/80')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPPREFIX '64:ffff::17/64')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '2804:431:b000::/37', IPPREFIX '2804:431:b000::/38')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '2804:431:b000::/38', IPPREFIX '2804:431:b000::/37')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '170.0.52.0/22', IPPREFIX '170.0.52.0/24')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '170.0.52.0/24', IPPREFIX '170.0.52.0/22')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIpv4PrefixCollapse() {
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/24', IPPREFIX '192.168.1.0/24'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/23"));
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.1.0/24', IPPREFIX '192.168.0.0/24', IPPREFIX '192.168.2.0/24', IPPREFIX '192.168.9.0/24'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/23", (Object)"192.168.2.0/24", (Object)"192.168.9.0/24"));
    }

    @Test
    public void testIpv6PrefixCollapse() {
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '2620:10d:c090::/48', IPPREFIX '2620:10d:c091::/48'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"2620:10d:c090::/47"));
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '2804:13c:4d6:e200::/56', IPPREFIX '2804:13c:4d6:dd00::/56', IPPREFIX '2804:13c:4d6:dc00::/56', IPPREFIX '2804:13c:4d6:de00::/56'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"2804:13c:4d6:dc00::/55", (Object)"2804:13c:4d6:de00::/56", (Object)"2804:13c:4d6:e200::/56"));
    }

    @Test
    public void testIpPrefixCollapseIpv4SingleIPs() {
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.1/32', IPPREFIX '192.168.33.1/32'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.1/32", (Object)"192.168.33.1/32"));
    }

    @Test
    public void testIpPrefixCollapseIpv6SingleIPs() {
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '2620:10d:c090:400::5:a869/128', IPPREFIX '2620:10d:c091:400::5:a869/128'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"2620:10d:c090:400::5:a869/128", (Object)"2620:10d:c091:400::5:a869/128"));
    }

    @Test
    public void testIpPrefixCollapseSinglePrefixReturnsSamePrefix() {
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/22'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/22"));
    }

    @Test
    public void testIpPrefixCollapseOverlappingPrefixes() {
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/22', IPPREFIX '192.168.0.0/24'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/22"));
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/22', IPPREFIX '192.168.2.0/24'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/22"));
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/22', IPPREFIX '192.168.3.0/24'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/22"));
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '10.0.64.0/18', IPPREFIX '10.2.0.0/15', IPPREFIX '10.0.0.0/8', IPPREFIX '11.0.0.0/8', IPPREFIX '172.168.32.0/20', IPPREFIX '172.168.0.0/18'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"10.0.0.0/7", (Object)"172.168.0.0/18"));
        this.assertFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '10.0.0.0/8', IPPREFIX '10.0.0.0/7'])", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"10.0.0.0/7"));
    }

    @Test
    public void testIpPrefixCollapseEmptyArrayInput() {
        this.assertFunction("IP_PREFIX_COLLAPSE(CAST(ARRAY[] AS ARRAY(IPPREFIX)))", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of());
    }

    @Test
    public void testIpPrefixCollapseNullInput() {
        this.assertFunction("IP_PREFIX_COLLAPSE(CAST(NULL AS ARRAY(IPPREFIX)))", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), null);
    }

    @Test
    public void testIpPrefixCollapseNoNullPrefixesError() {
        this.assertInvalidFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/22', CAST(NULL AS IPPREFIX)])", "ip_prefix_collapse does not support null elements");
    }

    @Test
    public void testIpPrefixCollapseMixedIpVersionError() {
        this.assertInvalidFunction("IP_PREFIX_COLLAPSE(ARRAY[IPPREFIX '192.168.0.0/22', IPPREFIX '2409:4043:251a:d200::/56'])", "All IPPREFIX elements must be the same IP version.");
    }

    @Test(dataProvider="private-ip-provider")
    public void testIsPrivateTrue(String ipAddress) {
        this.assertFunction("IS_PRIVATE_IP(IPADDRESS '" + ipAddress + "')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test(dataProvider="public-ip-provider")
    public void testIsPrivateIpFalse(String ipAddress) {
        this.assertFunction("IS_PRIVATE_IP(IPADDRESS '" + ipAddress + "')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIsPrivateIpNull() {
        this.assertFunction("IS_PRIVATE_IP(NULL)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testIpPrefixSubnets() {
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '192.168.1.0/24', 25)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.1.0/25", (Object)"192.168.1.128/25"));
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '192.168.0.0/24', 26)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.0.0/26", (Object)"192.168.0.64/26", (Object)"192.168.0.128/26", (Object)"192.168.0.192/26"));
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '2A03:2880:C000::/34', 37)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"2a03:2880:c000::/37", (Object)"2a03:2880:c800::/37", (Object)"2a03:2880:d000::/37", (Object)"2a03:2880:d800::/37", (Object)"2a03:2880:e000::/37", (Object)"2a03:2880:e800::/37", (Object)"2a03:2880:f000::/37", (Object)"2a03:2880:f800::/37"));
    }

    @Test
    public void testIpPrefixSubnetsReturnSelf() {
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '192.168.1.0/24', 24)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"192.168.1.0/24"));
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '2804:431:b000::/38', 38)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of((Object)"2804:431:b000::/38"));
    }

    @Test
    public void testIpPrefixSubnetsNewPrefixLengthLongerReturnsEmpty() {
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '192.168.0.0/24', 23)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of());
        this.assertFunction("IP_PREFIX_SUBNETS(IPPREFIX '64:ff9b::17/64', 48)", (Type)new ArrayType((Type)IpPrefixType.IPPREFIX), ImmutableList.of());
    }

    @Test
    public void testIpPrefixSubnetsInvalidPrefixLengths() {
        this.assertInvalidFunction("IP_PREFIX_SUBNETS(IPPREFIX '192.168.0.0/24', -1)", "Invalid prefix length for IPv4: -1");
        this.assertInvalidFunction("IP_PREFIX_SUBNETS(IPPREFIX '192.168.0.0/24', 33)", "Invalid prefix length for IPv4: 33");
        this.assertInvalidFunction("IP_PREFIX_SUBNETS(IPPREFIX '64:ff9b::17/64', -1)", "Invalid prefix length for IPv6: -1");
        this.assertInvalidFunction("IP_PREFIX_SUBNETS(IPPREFIX '64:ff9b::17/64', 129)", "Invalid prefix length for IPv6: 129");
    }
}

