/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapTopNKeysComparatorFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 2, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)4, (Object)5));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 2, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)6, (Object)5));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY['x', 'y', 'z'], ARRAY[1, 2, 3]), 3, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"z", (Object)"y", (Object)"x"));
    }

    @Test
    public void testNLargerThanMapSize() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 8, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)4, (Object)5, (Object)6));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 9, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)6, (Object)5, (Object)4));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY['x', 'y', 'z'], ARRAY[1, 2, 3]), 10, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"z", (Object)"y", (Object)"x"));
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY['abc', 'ab', 'a', 'b'], ARRAY[1, 2, 3, 4]), 10, (x, y) -> CASE WHEN LENGTH(x) > LENGTH(y) THEN 1 WHEN LENGTH(x) < LENGTH(y) THEN -1 WHEN x > y THEN 1 WHEN x < y THEN -1 ELSE -1 END)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc", (Object)"ab", (Object)"b", (Object)"a"));
    }

    @Test
    public void testNegativeN() {
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), -1, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), -2, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY['x', 'y', 'z'], ARRAY[1, 2, 3]), -3, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
    }

    @Test
    public void testZeroN() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 0, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 0, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY['x', 'y', 'z'], ARRAY[1, 2, 3]), 0, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of());
    }

    @Test
    public void testEmpty() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[], ARRAY[]), 1, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("MAP_TOP_N_KEYS(NULL, 1, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
    }

    @Test
    public void testComplexKeys() {
        this.assertFunction("MAP_TOP_N_KEYS(MAP(ARRAY[ROW('x', 1), ROW('y', 2), ROW('z', 3)], ARRAY[1, 2, 3]), 3, (x, y) -> IF(x[1] < y[1], 1, IF(x[1] = y[1], 0, -1)))", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)1), (Object)ImmutableList.of((Object)"y", (Object)2), (Object)ImmutableList.of((Object)"z", (Object)3)));
    }

    @Test
    public void testBadLambda() {
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 1, (x, y) -> 10)", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1");
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 2, null)", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("MAP_TOP_N_KEYS(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 3, (x, y) -> IF(x = 'test', 1, -1))", SemanticErrorCode.TYPE_MISMATCH);
    }
}

