/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.queryplan;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.queryplan.TestJsonPrestoQueryPlanFunctionUtils;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.Test;

public class TestJsonPrestoQueryPlanFunctions
extends AbstractTestFunctions {
    @Test
    public void testJsonPlanIds() {
        this.assertFunction("json_presto_query_plan_ids(null)", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
        this.assertFunction("json_presto_query_plan_ids(json '" + TestJsonPrestoQueryPlanFunctionUtils.joinPlan.replaceAll("'", "''") + "')", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"253", (Object)"313", (Object)"314", (Object)"8", (Object)"251", (Object)"284", (Object)"230", (Object)"252"));
    }

    @Test
    public void testJsonPlanNodeChildren() {
        this.assertFunction("json_presto_query_plan_node_children(null, null)", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
        this.assertFunction("json_presto_query_plan_node_children(null, '1')", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
        this.assertFunction("json_presto_query_plan_node_children(json '" + TestJsonPrestoQueryPlanFunctionUtils.joinPlan.replaceAll("'", "''") + "', '314')", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of());
        this.assertFunction("json_presto_query_plan_node_children(json '" + TestJsonPrestoQueryPlanFunctionUtils.joinPlan.replaceAll("'", "''") + "', '230')", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"251", (Object)"284"));
        this.assertFunction("json_presto_query_plan_node_children(json '" + TestJsonPrestoQueryPlanFunctionUtils.joinPlan.replaceAll("'", "''") + "', 'nonkey')", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
    }

    @Test
    public void testJsonScrubPlan() {
        this.assertFunction("json_presto_query_plan_scrub(json '" + TestJsonPrestoQueryPlanFunctionUtils.joinPlan.replaceAll("'", "''") + "')", (Type)JsonType.JSON, "{\n  \"0\" : {\n    \"plan\" : {\n      \"id\" : \"PLANID\",\n      \"name\" : \"Output\",\n      \"identifier\" : \"IDENTIFIER\",\n      \"details\" : \"DETAILS\",\n      \"children\" : [ {\n        \"id\" : \"PLANID\",\n        \"name\" : \"RemoteSource\",\n        \"identifier\" : \"IDENTIFIER\",\n        \"details\" : \"DETAILS\",\n        \"children\" : [ ],\n        \"remoteSources\" : [ \"1\" ],\n        \"estimates\" : [ ]\n      } ],\n      \"remoteSources\" : [ ],\n      \"estimates\" : [ ]\n    }\n  },\n  \"1\" : {\n    \"plan\" : {\n      \"id\" : \"PLANID\",\n      \"name\" : \"InnerJoin\",\n      \"identifier\" : \"IDENTIFIER\",\n      \"details\" : \"DETAILS\",\n      \"children\" : [ {\n        \"id\" : \"PLANID\",\n        \"name\" : \"RemoteSource\",\n        \"identifier\" : \"IDENTIFIER\",\n        \"details\" : \"DETAILS\",\n        \"children\" : [ ],\n        \"remoteSources\" : [ \"2\" ],\n        \"estimates\" : [ ]\n      }, {\n        \"id\" : \"PLANID\",\n        \"name\" : \"LocalExchange\",\n        \"identifier\" : \"IDENTIFIER\",\n        \"details\" : \"DETAILS\",\n        \"children\" : [ {\n          \"id\" : \"PLANID\",\n          \"name\" : \"RemoteSource\",\n          \"identifier\" : \"IDENTIFIER\",\n          \"details\" : \"DETAILS\",\n          \"children\" : [ ],\n          \"remoteSources\" : [ \"3\" ],\n          \"estimates\" : [ ]\n        } ],\n        \"remoteSources\" : [ ],\n        \"estimates\" : [ ]\n      } ],\n      \"remoteSources\" : [ ],\n      \"estimates\" : [ ]\n    }\n  },\n  \"2\" : {\n    \"plan\" : {\n      \"id\" : \"PLANID\",\n      \"name\" : \"ScanProject\",\n      \"identifier\" : \"tableName=r\",\n      \"details\" : \"DETAILS\",\n      \"children\" : [ ],\n      \"remoteSources\" : [ ],\n      \"estimates\" : [ ]\n    }\n  },\n  \"3\" : {\n    \"plan\" : {\n      \"id\" : \"PLANID\",\n      \"name\" : \"ScanProject\",\n      \"identifier\" : \"tableName=s\",\n      \"details\" : \"DETAILS\",\n      \"children\" : [ ],\n      \"remoteSources\" : [ ],\n      \"estimates\" : [ ]\n    }\n  }\n}");
    }

    @Test
    public void testJsonFunctionsInvalidPlans() {
        String invalidJsonPlan = "{   \"id\" : \"9\",   \"name\" : \"Output\"}";
        this.assertFunction("json_presto_query_plan_ids(json '" + invalidJsonPlan.replaceAll("'", "''") + "')", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
        this.assertFunction("json_presto_query_plan_node_children(json '" + invalidJsonPlan.replaceAll("'", "''") + "', 'nonkey')", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
    }
}

