/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapKeysByTopNValuesFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3, (Object)2));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)-3, (Object)-2));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of((Object)"cd"));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 3)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)6, (int)2)), ImmutableList.of((Object)TestMapKeysByTopNValuesFunction.decimal("1000.99"), (Object)TestMapKeysByTopNValuesFunction.decimal("99.50"), (Object)TestMapKeysByTopNValuesFunction.decimal("123.00")));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY['abc', 'cbc', 'cbd'], ARRAY[1, 1, 1]), 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"cbd", (Object)"cbc", (Object)"abc"));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY['ab', 'bc', 'cd', 'de', 'ee', 'ef', 'ac', 'ad'], ARRAY[1, 2, 2, 2, 4, 5, 5, 6]), 5)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of((Object)"ad", (Object)"ef", (Object)"ac", (Object)"ee", (Object)"de"));
    }

    @Test
    public void testNegativeN() {
        this.assertInvalidFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[100, 200, 300], ARRAY[4, 5, 6]), -3)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), -1)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY['a', 'b', 'c'], ARRAY[4, 5, 6]), -2)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
    }

    @Test
    public void testZeroN() {
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 0)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of());
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 0)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)6, (int)2)), ImmutableList.of());
    }

    @Test
    public void testEmpty() {
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[], ARRAY[]), 5)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(NULL, 1)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
    }

    @Test
    public void testComplexKeys() {
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[ROW('x', 1), ROW('y', 2)], ARRAY[1, 2]), 1)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"y", (Object)2)));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[ROW('x', 1), ROW('x', -2)], ARRAY[2, 1]), 1)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)1)));
        this.assertFunction("MAP_KEYS_BY_TOP_N_VALUES(MAP(ARRAY[ROW('x', 1), ROW('x', -2), ROW('y', 1)], ARRAY[100, 200, null]), 3)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)-2), (Object)ImmutableList.of((Object)"x", (Object)1), (Object)ImmutableList.of((Object)"y", (Object)1)));
    }
}

