/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapTopNFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), 2)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)3, (Object)6, (Object)2, (Object)5));
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 2)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)-3, (Object)6, (Object)-2, (Object)5));
        this.assertFunction("MAP_TOP_N(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 1)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)"cd", (Object)"z"));
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 3)", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)6, (int)2), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)TestMapTopNFunction.decimal("1000.99"), (Object)"z", (Object)TestMapTopNFunction.decimal("99.50"), (Object)"y", (Object)TestMapTopNFunction.decimal("123.00"), (Object)"x"));
    }

    @Test
    public void testNegativeN() {
        this.assertInvalidFunction("MAP_TOP_N(MAP(ARRAY[100, 200, 300], ARRAY[4, 5, 6]), -3)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), -1)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N(MAP(ARRAY['a', 'b', 'c'], ARRAY[4, 5, 6]), -2)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
    }

    @Test
    public void testZeroN() {
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), 0)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("MAP_TOP_N(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), 0)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of());
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), 0)", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)6, (int)2), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of());
    }

    @Test
    public void testEmpty() {
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[], ARRAY[]), 5)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("MAP_TOP_N(NULL, 1)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), null);
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>(){
            {
                this.put(4, 4);
                this.put(3, 1);
                this.put(5, null);
            }
        };
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[1, 2, 3, 4, 5], ARRAY[NULL, NULL, 1, 4, NULL]), 3)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), expected);
        HashMap<String, Integer> expectedStringKey = new HashMap<String, Integer>(){
            {
                this.put("ef", 6);
                this.put("cd", 4);
                this.put("ab", -1);
                this.put("hi", null);
            }
        };
        this.assertFunction("MAP_TOP_N(MAP(ARRAY['ab', 'bc', 'ef', 'cd', 'hi'], ARRAY[-1, NULL, 6, 4, NULL]), 4)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)IntegerType.INTEGER), expectedStringKey);
    }

    @Test
    public void testComplexKeys() {
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[ROW('x', 1), ROW('y', 2)], ARRAY[1, 2]), 1)", (Type)StructuralTestUtil.mapType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER))), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)ImmutableList.of((Object)"y", (Object)2), (Object)2));
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[ROW('x', 1), ROW('x', -2)], ARRAY[2, 1]), 1)", (Type)StructuralTestUtil.mapType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER))), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)ImmutableList.of((Object)"x", (Object)1), (Object)2));
        this.assertFunction("MAP_TOP_N(MAP(ARRAY[ROW('x', 1), ROW('x', -2), ROW('y', 1)], ARRAY[100, 200, null]), 3)", (Type)StructuralTestUtil.mapType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER))), (Type)IntegerType.INTEGER), TestMapTopNFunction.asMap(Arrays.asList(ImmutableList.of((Object)"x", (Object)-2), ImmutableList.of((Object)"x", (Object)1), ImmutableList.of((Object)"y", (Object)1)), Arrays.asList(200, 100, null)));
    }
}

