/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.MockHttpServletRequest;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpRequestSessionContext {
    private static final JsonCodec<SqlFunctionId> SQL_FUNCTION_ID_JSON_CODEC = JsonCodec.jsonCodec(SqlFunctionId.class);
    private static final JsonCodec<SqlInvokedFunction> SQL_INVOKED_FUNCTION_JSON_CODEC = JsonCodec.jsonCodec(SqlInvokedFunction.class);
    private static final SqlFunctionId SQL_FUNCTION_ID_ADD = TestHttpRequestSessionContext.createSqlFunctionIdAdd();
    private static final SqlInvokedFunction SQL_FUNCTION_ADD = TestHttpRequestSessionContext.createFunctionAdd();
    private static final String SERIALIZED_SQL_FUNCTION_ID_ADD = SQL_FUNCTION_ID_JSON_CODEC.toJson((Object)SQL_FUNCTION_ID_ADD);
    private static final String SERIALIZED_SQL_FUNCTION_ADD = SQL_INVOKED_FUNCTION_JSON_CODEC.toJson((Object)SQL_FUNCTION_ADD);
    private static final SqlFunctionId SQL_FUNCTION_ID_ADD1_TO_INT_ARRAY = TestHttpRequestSessionContext.createSqlFunctionIdAdd1ToIntArray();
    private static final SqlInvokedFunction SQL_FUNCTION_ADD_1_TO_INT_ARRAY = TestHttpRequestSessionContext.createFunctionAdd1ToIntArray();
    private static final String SERIALIZED_SQL_FUNCTION_ID_ADD_1_TO_INT_ARRAY = SQL_FUNCTION_ID_JSON_CODEC.toJson((Object)SQL_FUNCTION_ID_ADD1_TO_INT_ARRAY);
    private static final String SERIALIZED_SQL_FUNCTION_ADD_1_to_INT_ARRAY = SQL_INVOKED_FUNCTION_JSON_CODEC.toJson((Object)SQL_FUNCTION_ADD_1_TO_INT_ARRAY);

    @Test
    public void testSessionContext() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"client-info").put((Object)"X-Presto-Session", (Object)"query_max_memory=1GB").put((Object)"X-Presto-Session", (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from foo,query2=select * from bar").put((Object)"X-Presto-Role", (Object)"foo_connector=ALL").put((Object)"X-Presto-Role", (Object)"bar_connector=NONE").put((Object)"X-Presto-Role", (Object)"foobar_connector=ROLE{role}").put((Object)"X-Presto-Extra-Credential", (Object)"test.token.foo=bar").put((Object)"X-Presto-Extra-Credential", (Object)"test.token.abc=xyz").put((Object)"X-Presto-Session-Function", (Object)String.format("%s=%s,%s=%s", TestHttpRequestSessionContext.urlEncode(SERIALIZED_SQL_FUNCTION_ID_ADD), TestHttpRequestSessionContext.urlEncode(SERIALIZED_SQL_FUNCTION_ADD), TestHttpRequestSessionContext.urlEncode(SERIALIZED_SQL_FUNCTION_ID_ADD_1_TO_INT_ARRAY), TestHttpRequestSessionContext.urlEncode(SERIALIZED_SQL_FUNCTION_ADD_1_to_INT_ARRAY))).build(), "testRemote", (Map<String, Object>)ImmutableMap.of());
        HttpRequestSessionContext context = new HttpRequestSessionContext((HttpServletRequest)request, new SqlParserOptions());
        Assert.assertEquals((String)context.getSource(), (String)"testSource");
        Assert.assertEquals((String)context.getCatalog(), (String)"testCatalog");
        Assert.assertEquals((String)context.getSchema(), (String)"testSchema");
        Assert.assertEquals((Object)context.getIdentity(), (Object)new Identity("testUser", Optional.empty()));
        Assert.assertEquals((String)context.getClientInfo(), (String)"client-info");
        Assert.assertEquals((String)context.getLanguage(), (String)"zh-TW");
        Assert.assertEquals((String)context.getTimeZoneId(), (String)"Asia/Taipei");
        Assert.assertEquals((Map)context.getSystemProperties(), (Map)ImmutableMap.of((Object)"query_max_memory", (Object)"1GB", (Object)"join_distribution_type", (Object)"partitioned", (Object)"hash_partition_count", (Object)"43"));
        Assert.assertEquals((Map)context.getPreparedStatements(), (Map)ImmutableMap.of((Object)"query1", (Object)"select * from foo", (Object)"query2", (Object)"select * from bar"));
        Assert.assertEquals((Map)context.getIdentity().getRoles(), (Map)ImmutableMap.of((Object)"foo_connector", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty()), (Object)"bar_connector", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty()), (Object)"foobar_connector", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))));
        Assert.assertEquals((Map)context.getIdentity().getExtraCredentials(), (Map)ImmutableMap.of((Object)"test.token.foo", (Object)"bar", (Object)"test.token.abc", (Object)"xyz"));
        Assert.assertEquals((Map)context.getSessionFunctions(), (Map)ImmutableMap.of((Object)SQL_FUNCTION_ID_ADD, (Object)SQL_FUNCTION_ADD, (Object)SQL_FUNCTION_ID_ADD1_TO_INT_ARRAY, (Object)SQL_FUNCTION_ADD_1_TO_INT_ARRAY));
    }

    @Test(expectedExceptions={WebApplicationException.class})
    public void testPreparedStatementsHeaderDoesNotParse() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"null").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=abcdefg").build(), "testRemote", (Map<String, Object>)ImmutableMap.of());
        new HttpRequestSessionContext((HttpServletRequest)request, new SqlParserOptions());
    }

    @Test
    public void testPreparedStatementsSpecialCharacters() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"null").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from tbl:ns").build(), "testRemote", (Map<String, Object>)ImmutableMap.of());
        SqlParserOptions options = new SqlParserOptions();
        options.allowIdentifierSymbol(EnumSet.allOf(IdentifierSymbol.class));
        new HttpRequestSessionContext((HttpServletRequest)request, options);
    }

    @Test
    public void testExtraCredentials() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"client-info").put((Object)"X-Presto-Session", (Object)"query_max_memory=1GB").put((Object)"X-Presto-Session", (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from foo,query2=select * from bar").put((Object)"X-Presto-Role", (Object)"foo_connector=ALL").put((Object)"X-Presto-Role", (Object)"bar_connector=NONE").put((Object)"X-Presto-Role", (Object)"foobar_connector=ROLE{role}").put((Object)"X-Presto-Extra-Credential", (Object)("test.token.key1=" + TestHttpRequestSessionContext.urlEncode("bar=ab===,d"))).put((Object)"X-Presto-Extra-Credential", (Object)"test.token.key2=bar=ab===").put((Object)"X-Presto-Extra-Credential", (Object)("test.json=" + TestHttpRequestSessionContext.urlEncode("{\"a\" : \"b\", \"c\" : \"d=\"}") + ", test.token.key3 = abc=cd")).put((Object)"X-Presto-Extra-Credential", (Object)"test.token.abc=xyz").build(), "testRemote", (Map<String, Object>)ImmutableMap.of());
        HttpRequestSessionContext context = new HttpRequestSessionContext((HttpServletRequest)request, new SqlParserOptions());
        Assert.assertEquals((Map)context.getIdentity().getExtraCredentials(), (Map)ImmutableMap.builder().put((Object)"test.token.key1", (Object)"bar=ab===,d").put((Object)"test.token.key2", (Object)"bar=ab===").put((Object)"test.token.key3", (Object)"abc=cd").put((Object)"test.json", (Object)"{\"a\" : \"b\", \"c\" : \"d=\"}").put((Object)"test.token.abc", (Object)"xyz").build());
    }

    @Test
    public void testAuthorizedIdentity() {
        AuthorizedIdentity authorizedIdentity = new AuthorizedIdentity("username", "reasonForSelect", Boolean.valueOf(false));
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").build(), "testRemote", (Map<String, Object>)ImmutableMap.of((Object)"presto.authorized-identity", (Object)authorizedIdentity));
        HttpRequestSessionContext context = new HttpRequestSessionContext((HttpServletRequest)request, new SqlParserOptions());
        Assert.assertEquals((Object)context.getAuthorizedIdentity(), Optional.of(authorizedIdentity));
    }

    protected static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SqlFunctionId createSqlFunctionIdAdd() {
        return new SqlFunctionId(QualifiedObjectName.valueOf((String)"presto.session.add"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"integer"), (Object)TypeSignature.parseTypeSignature((String)"integer")));
    }

    public static SqlInvokedFunction createFunctionAdd() {
        return new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("presto", "session"), (String)"add"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer")), (Object)new Parameter("y", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "add", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN x + y", FunctionVersion.notVersioned());
    }

    public static SqlFunctionId createSqlFunctionIdAdd1ToIntArray() {
        return new SqlFunctionId(QualifiedObjectName.valueOf((String)"presto.session.add_1_int"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(int)")));
    }

    public static SqlInvokedFunction createFunctionAdd1ToIntArray() {
        return new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("presto", "session"), (String)"add_1_int"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"array(int)"))), TypeSignature.parseTypeSignature((String)"array(int)"), "add 1 to all elements of array", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN transform(x, x -> x + 1)", FunctionVersion.notVersioned());
    }
}

