/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.FullJsonResponseHandler;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.StatusResponseHandler;
import com.facebook.airlift.http.client.UnexpectedResponseException;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.TimeZoneNotSupportedException;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.TestHttpRequestSessionContext;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestServer {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private static final SqlFunctionId SQL_FUNCTION_ID_ADD = TestHttpRequestSessionContext.createSqlFunctionIdAdd();
    private static final SqlInvokedFunction SQL_FUNCTION_ADD = TestHttpRequestSessionContext.createFunctionAdd();
    private static final String SERIALIZED_SQL_FUNCTION_ID_ADD = JsonCodec.jsonCodec(SqlFunctionId.class).toJson((Object)SQL_FUNCTION_ID_ADD);
    private static final String SERIALIZED_SQL_FUNCTION_ADD = JsonCodec.jsonCodec(SqlInvokedFunction.class).toJson((Object)SQL_FUNCTION_ADD);
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeMethod
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.client = new JettyHttpClient();
    }

    @AfterMethod
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testInvalidSessionError() {
        String invalidTimeZone = "this_is_an_invalid_time_zone";
        Request request = Request.Builder.preparePost().setHeader("X-Presto-User", "user").setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Time-Zone", invalidTimeZone).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        QueryError queryError = queryResults.getError();
        Assert.assertNotNull((Object)queryError);
        TimeZoneNotSupportedException expected = new TimeZoneNotSupportedException(invalidTimeZone);
        Assert.assertEquals((String)queryError.getMessage(), (String)expected.getMessage());
    }

    @Test
    public void testServerStarts() {
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/query")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.OK.getStatusCode());
    }

    @Test
    public void testBinaryResults() {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").replaceParameter("binaryResults", new String[]{"true"}).build();
        Request request = Request.Builder.preparePost().setUri(uri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Client-Info", "{\"clientVersion\":\"testVersion\"}").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        ImmutableList.Builder data = ImmutableList.builder();
        while (queryResults.getNextUri() != null) {
            Request nextRequest = Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build();
            queryResults = (QueryResults)this.client.execute(nextRequest, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
            Assert.assertNull((Object)queryResults.getData());
            if (queryResults.getBinaryData() == null) continue;
            data.addAll(queryResults.getBinaryData());
        }
        if (queryResults.getError() != null) {
            Assert.fail((String)queryResults.getError().toString());
        }
        ImmutableList encodedPages = data.build();
        Assert.assertEquals((int)1, (int)encodedPages.size());
        byte[] decodedPage = Base64.getDecoder().decode((String)encodedPages.get(0));
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager();
        PagesSerde pagesSerde = new PagesSerdeFactory((BlockEncodingSerde)blockEncodingSerde, false, false).createPagesSerde();
        BasicSliceInput pageInput = new BasicSliceInput(Slices.wrappedBuffer((byte[])decodedPage, (int)0, (int)decodedPage.length));
        SerializedPage serializedPage = PagesSerdeUtil.readSerializedPage((SliceInput)pageInput);
        Page page = pagesSerde.deserialize(serializedPage);
        Assert.assertEquals((int)1, (int)page.getChannelCount());
        Assert.assertEquals((int)1, (int)page.getPositionCount());
        Slice slice = VarcharType.VARCHAR.getSlice(page.getBlock(0), 0);
        Assert.assertEquals((String)slice.toStringUtf8(), (String)"system");
    }

    @Test
    public void testQuery() {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Client-Info", "{\"clientVersion\":\"testVersion\"}").addHeader("X-Presto-Session", "query_max_memory=1GB").addHeader("X-Presto-Session", "join_distribution_type=partitioned,hash_partition_count = 43").addHeader("X-Presto-Prepared-Statement", "foo=select * from bar").addHeader("X-Presto-Session-Function", String.format("%s=%s", TestHttpRequestSessionContext.urlEncode(SERIALIZED_SQL_FUNCTION_ID_ADD), TestHttpRequestSessionContext.urlEncode(SERIALIZED_SQL_FUNCTION_ADD))).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        ImmutableList.Builder data = ImmutableList.builder();
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
            if (queryResults.getData() == null) continue;
            data.addAll(queryResults.getData());
        }
        if (queryResults.getError() != null) {
            Assert.fail((String)queryResults.getError().toString());
        }
        BasicQueryInfo queryInfo = this.server.getQueryManager().getQueryInfo(new QueryId(queryResults.getId()));
        Assert.assertEquals((Map)queryInfo.getSession().getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((String)((String)queryInfo.getSession().getClientInfo().get()), (String)"{\"clientVersion\":\"testVersion\"}");
        Assert.assertEquals((Map)queryInfo.getSession().getPreparedStatements(), (Map)ImmutableMap.builder().put((Object)"foo", (Object)"select * from bar").build());
        Assert.assertEquals((Map)queryInfo.getSession().getSessionFunctions(), (Map)ImmutableMap.of((Object)SQL_FUNCTION_ID_ADD, (Object)SQL_FUNCTION_ADD));
        ImmutableList rows = data.build();
        Assert.assertEquals((Collection)rows, (Collection)ImmutableList.of((Object)ImmutableList.of((Object)"system")));
    }

    @Test
    public void testQueryWithPreMintedQueryIdAndSlug() {
        QueryId queryId = new QueryIdGenerator().createNextQueryId();
        String slug = "xxx";
        Request request = Request.Builder.preparePut().setUri(this.uriFor("/v1/statement/", queryId, slug)).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        Assert.assertEquals((String)queryResults.getNextUri().getQuery(), (String)"slug=xxx");
        Assert.assertEquals((String)queryResults.getNextUri().getPath(), (String)String.format("/v1/statement/queued/%s/1", queryId));
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        if (queryResults.getError() != null) {
            Assert.fail((String)queryResults.getError().toString());
        }
        Assert.assertEquals((Object)this.server.getDispatchManager().getQueryInfo(queryId).getQueryId(), (Object)queryId);
    }

    @Test
    public void testPutStatementIdempotency() {
        QueryId queryId = new QueryIdGenerator().createNextQueryId();
        Request request = Request.Builder.preparePut().setUri(this.uriFor("/v1/statement/", queryId, "slug")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").build();
        this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        if (queryResults.getError() != null) {
            Assert.fail((String)queryResults.getError().toString());
        }
    }

    @Test(expectedExceptions={UnexpectedResponseException.class}, expectedExceptionsMessageRegExp="Expected response code to be \\[.*\\], but was 409")
    public void testPutStatementWithDifferentSlugFails() {
        QueryId queryId = new QueryIdGenerator().createNextQueryId();
        Request request = Request.Builder.preparePut().setUri(this.uriFor("/v1/statement/", queryId, "slug")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").build();
        this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        Request badRequest = Request.Builder.fromRequest((Request)request).setUri(this.uriFor("/v1/statement/", queryId, "different_slug")).build();
        this.client.execute(badRequest, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
    }

    @Test(expectedExceptions={UnexpectedResponseException.class}, expectedExceptionsMessageRegExp="Expected response code to be \\[.*\\], but was 409")
    public void testPutStatementAfterGetFails() {
        QueryId queryId = new QueryIdGenerator().createNextQueryId();
        Request request = Request.Builder.preparePut().setUri(this.uriFor("/v1/statement/", queryId, "slug")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
    }

    @Test
    public void testTransactionSupport() {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Transaction-Id", "none").build();
        FullJsonResponseHandler.JsonResponse queryResults = (FullJsonResponseHandler.JsonResponse)this.client.execute(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        ImmutableList.Builder data = ImmutableList.builder();
        while (true) {
            if (((QueryResults)queryResults.getValue()).getData() != null) {
                data.addAll(((QueryResults)queryResults.getValue()).getData());
            }
            if (((QueryResults)queryResults.getValue()).getNextUri() == null) break;
            queryResults = (FullJsonResponseHandler.JsonResponse)this.client.execute(Request.Builder.prepareGet().setUri(((QueryResults)queryResults.getValue()).getNextUri()).build(), (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        if (((QueryResults)queryResults.getValue()).getError() != null) {
            Assert.fail((String)((QueryResults)queryResults.getValue()).getError().toString());
        }
        Assert.assertNotNull((Object)queryResults.getHeader("X-Presto-Started-Transaction-Id"));
    }

    @Test
    public void testNoTransactionSupport() {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        Assert.assertNotNull((Object)queryResults.getError());
        Assert.assertEquals((int)queryResults.getError().getErrorCode(), (int)StandardErrorCode.INCOMPATIBLE_CLIENT.toErrorCode().getCode());
    }

    @Test
    public void testStatusPing() {
        Request request = Request.Builder.prepareHead().setUri(this.uriFor("/v1/status")).setFollowRedirects(false).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Status code");
        Assert.assertEquals((String)response.getHeader("Content-Type"), (String)"application/json", (String)"Content Type");
    }

    public URI uriFor(String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath(path).build();
    }

    public URI uriFor(String path, QueryId queryId, String slug) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath(path).appendPath(queryId.getId()).addParameter("slug", new String[]{slug}).build();
    }
}

