/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.presto.server.InternalAuthenticationManager;
import com.facebook.presto.server.MockContainerRequestContext;
import com.facebook.presto.server.TaskResource;
import com.facebook.presto.server.security.InternalAuthenticationFilter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.hash.Hashing;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInternalAuthenticationFilter {
    @Test
    public void testJwtAuthenticationRejectsWithNoBearerTokenJwtEnabled() {
        String sharedSecret = "secret";
        boolean internalJwtEnabled = true;
        InternalAuthenticationManager internalAuthenticationManager = new InternalAuthenticationManager(Optional.of(sharedSecret), "nodeId", internalJwtEnabled);
        InternalAuthenticationFilter internalAuthenticationFilter = new InternalAuthenticationFilter(internalAuthenticationManager, new ResourceInfoBuilder(TaskResource.class, null, null).build());
        MockContainerRequestContext containerRequestContext = new MockContainerRequestContext((ListMultimap<String, String>)ImmutableListMultimap.of());
        internalAuthenticationFilter.filter((ContainerRequestContext)containerRequestContext);
        Assert.assertEquals((int)containerRequestContext.getResponse().getStatus(), (int)401);
        Assert.assertEquals((String)"Unauthorized", (String)containerRequestContext.getResponse().getStatusInfo().getReasonPhrase());
    }

    @Test
    public void testJwtAuthenticationPassesWithNoBearerTokenJwtDisabledNoAuthenticators() {
        String sharedSecret = "secret";
        boolean internalJwtEnabled = false;
        InternalAuthenticationManager internalAuthenticationManager = new InternalAuthenticationManager(Optional.of(sharedSecret), "nodeId", internalJwtEnabled);
        InternalAuthenticationFilter internalAuthenticationFilter = new InternalAuthenticationFilter(internalAuthenticationManager, new ResourceInfoBuilder(TaskResource.class, null, null).build());
        MockContainerRequestContext containerRequestContext = new MockContainerRequestContext((ListMultimap<String, String>)ImmutableListMultimap.of());
        internalAuthenticationFilter.filter((ContainerRequestContext)containerRequestContext);
        Assert.assertEquals((int)containerRequestContext.getResponse().getStatus(), (int)200);
        Assert.assertFalse((boolean)internalAuthenticationFilter.getPrincipal().isPresent());
    }

    @Test
    public void testJwtAuthenticationPassesWithBearerTokenJwtEnabled() {
        String sharedSecret = "secret";
        String principalString = "456";
        boolean internalJwtEnabled = true;
        InternalAuthenticationManager internalAuthenticationManager = new InternalAuthenticationManager(Optional.of(sharedSecret), "nodeId", internalJwtEnabled);
        InternalAuthenticationFilter internalAuthenticationFilter = new InternalAuthenticationFilter(internalAuthenticationManager, new ResourceInfoBuilder(TaskResource.class, null, null).build());
        String jwtToken = Jwts.builder().signWith(SignatureAlgorithm.HS256, Hashing.sha256().hashString((CharSequence)"secret", StandardCharsets.UTF_8).asBytes()).setSubject(principalString).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
        MockContainerRequestContext containerRequestContext = new MockContainerRequestContext((ListMultimap<String, String>)ImmutableListMultimap.of((Object)"X-Presto-Internal-Bearer", (Object)jwtToken));
        internalAuthenticationFilter.filter((ContainerRequestContext)containerRequestContext);
        Assert.assertTrue((boolean)internalAuthenticationFilter.getPrincipal().isPresent());
        Assert.assertEquals((String)((Principal)internalAuthenticationFilter.getPrincipal().get()).toString(), (String)principalString);
        Assert.assertEquals((int)containerRequestContext.getResponse().getStatus(), (int)200);
    }

    @Test
    public void testJwtAuthenticationRejectsWithBearerTokenJwtDisabled() {
        String sharedSecret = "secret";
        String principalString = "456";
        boolean internalJwtEnabled = false;
        InternalAuthenticationManager internalAuthenticationManager = new InternalAuthenticationManager(Optional.of(sharedSecret), "nodeId", internalJwtEnabled);
        InternalAuthenticationFilter internalAuthenticationFilter = new InternalAuthenticationFilter(internalAuthenticationManager, new ResourceInfoBuilder(TaskResource.class, null, null).build());
        String jwtToken = Jwts.builder().signWith(SignatureAlgorithm.HS256, Hashing.sha256().hashString((CharSequence)"secret", StandardCharsets.UTF_8).asBytes()).setSubject(principalString).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
        MockContainerRequestContext containerRequestContext = new MockContainerRequestContext((ListMultimap<String, String>)ImmutableListMultimap.of((Object)"X-Presto-Internal-Bearer", (Object)jwtToken));
        internalAuthenticationFilter.filter((ContainerRequestContext)containerRequestContext);
        Assert.assertEquals((int)containerRequestContext.getResponse().getStatus(), (int)401);
        Assert.assertEquals((String)"Unauthorized", (String)containerRequestContext.getResponse().getStatusInfo().getReasonPhrase());
        Assert.assertFalse((boolean)internalAuthenticationFilter.getPrincipal().isPresent());
    }

    private static class ResourceInfoBuilder {
        private final Class<?> clazz;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        ResourceInfoBuilder(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        ResourceInfo build() {
            return new ResourceInfo(){

                public Method getResourceMethod() {
                    if (methodName == null || methodName.isEmpty()) {
                        return null;
                    }
                    Method method = null;
                    try {
                        method = clazz.getMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return method;
                }

                public Class<?> getResourceClass() {
                    return clazz;
                }
            };
        }
    }
}

