/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.presto.server.MockHttpServletRequest;
import com.facebook.presto.server.security.JsonWebTokenAuthenticator;
import com.facebook.presto.server.security.JsonWebTokenConfig;
import com.facebook.presto.server.security.ServletSecurityUtils;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Principal;
import java.util.Base64;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestJsonWebTokenAuthenticator {
    private static final String KEY_ID_FOO = "foo";
    private static final String TEST_PRINCIPAL = "testPrincipal";
    private Path temporaryDirectory;
    private Path keyFile;
    private JsonWebTokenConfig jsonWebTokenConfig;

    @BeforeTest
    public void setup() throws IOException {
        this.temporaryDirectory = com.google.common.io.Files.createTempDir().toPath();
        this.keyFile = this.temporaryDirectory.resolve("foo.key");
        byte[] key = Base64.getMimeEncoder().encode(Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256).getEncoded());
        com.google.common.io.Files.write((byte[])key, (File)this.keyFile.toFile());
        this.jsonWebTokenConfig = new JsonWebTokenConfig().setKeyFile(this.keyFile.toAbsolutePath().toString());
    }

    @AfterTest(alwaysRun=true)
    public void cleanup() throws IOException {
        MoreFiles.deleteRecursively((Path)this.temporaryDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testJsonWebTokenWithAuthorizedUserClaim() throws IOException, AuthenticationException {
        AuthorizedIdentity authorizedIdentity = new AuthorizedIdentity("user", "reasonForSelect", Boolean.valueOf(false));
        String jsonWebToken = TestJsonWebTokenAuthenticator.createJsonWebToken(this.keyFile, TEST_PRINCIPAL, authorizedIdentity);
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.of((Object)"Authorization", (Object)("Bearer " + jsonWebToken)), "remoteAddress", (Map<String, Object>)ImmutableMap.of());
        Principal principal = new JsonWebTokenAuthenticator(this.jsonWebTokenConfig).authenticate((HttpServletRequest)request);
        Assert.assertEquals((String)principal.getName(), (String)TEST_PRINCIPAL);
        Assert.assertEquals(ServletSecurityUtils.authorizedIdentity((HttpServletRequest)request).get(), (Object)authorizedIdentity);
    }

    private static String createJsonWebToken(Path keyFile, String principal, AuthorizedIdentity authorizedIdentity) throws IOException {
        byte[] key = Base64.getMimeDecoder().decode(Files.readAllBytes(keyFile.toAbsolutePath()));
        return Jwts.builder().signWith(SignatureAlgorithm.HS256, key).setHeaderParam("kid", (Object)KEY_ID_FOO).setSubject(principal).claim("presto.authorized-identity", (Object)authorizedIdentity).compact();
    }
}

