/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockSerdeUtil;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.functionNamespace.json.JsonFileBasedFunctionNamespaceManagerFactory;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.scalar.ApplyFunction;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.AggregationFunctionMetadata;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.util.AnalyzerUtil;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExpressionInterpreter {
    public static final SqlInvokedFunction SQUARE_UDF_CPP = new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("json", "test_schema"), (String)"square"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"bigint"))), TypeSignature.parseTypeSignature((String)"bigint"), "Integer square", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setLanguage(RoutineCharacteristics.Language.CPP).build(), "", FunctionVersion.notVersioned());
    public static final SqlInvokedFunction AVG_UDAF_CPP = new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("json", "test_schema"), (String)"avg"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"double"))), TypeSignature.parseTypeSignature((String)"double"), "Returns mean of doubles", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setLanguage(RoutineCharacteristics.Language.CPP).build(), "", FunctionVersion.notVersioned(), FunctionKind.AGGREGATE, Optional.of(new AggregationFunctionMetadata(TypeSignature.parseTypeSignature((String)"ROW(double, int)"), false)));
    private static final int TEST_VARCHAR_TYPE_LENGTH = 17;
    private static final TypeProvider SYMBOL_TYPES = TypeProvider.viewOf((Map)ImmutableMap.builder().put((Object)"bound_integer", (Object)IntegerType.INTEGER).put((Object)"bound_long", (Object)BigintType.BIGINT).put((Object)"bound_string", (Object)VarcharType.createVarcharType((int)17)).put((Object)"bound_varbinary", (Object)VarbinaryType.VARBINARY).put((Object)"bound_double", (Object)DoubleType.DOUBLE).put((Object)"bound_boolean", (Object)BooleanType.BOOLEAN).put((Object)"bound_date", (Object)DateType.DATE).put((Object)"bound_time", (Object)TimeType.TIME).put((Object)"bound_timestamp", (Object)TimestampType.TIMESTAMP).put((Object)"bound_pattern", (Object)VarcharType.VARCHAR).put((Object)"bound_null_string", (Object)VarcharType.VARCHAR).put((Object)"bound_decimal_short", (Object)DecimalType.createDecimalType((int)5, (int)2)).put((Object)"bound_decimal_long", (Object)DecimalType.createDecimalType((int)23, (int)3)).put((Object)"time", (Object)BigintType.BIGINT).put((Object)"unbound_integer", (Object)IntegerType.INTEGER).put((Object)"unbound_long", (Object)BigintType.BIGINT).put((Object)"unbound_long2", (Object)BigintType.BIGINT).put((Object)"unbound_long3", (Object)BigintType.BIGINT).put((Object)"unbound_string", (Object)VarcharType.VARCHAR).put((Object)"unbound_double", (Object)DoubleType.DOUBLE).put((Object)"unbound_boolean", (Object)BooleanType.BOOLEAN).put((Object)"unbound_date", (Object)DateType.DATE).put((Object)"unbound_time", (Object)TimeType.TIME).put((Object)"unbound_array", (Object)new ArrayType((Type)BigintType.BIGINT)).put((Object)"unbound_timestamp", (Object)TimestampType.TIMESTAMP).put((Object)"unbound_interval", (Object)IntervalDayTimeType.INTERVAL_DAY_TIME).put((Object)"unbound_pattern", (Object)VarcharType.VARCHAR).put((Object)"unbound_null_string", (Object)VarcharType.VARCHAR).build());
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TestingRowExpressionTranslator TRANSLATOR = new TestingRowExpressionTranslator(METADATA);
    private static final BlockEncodingSerde blockEncodingSerde = new BlockEncodingManager();

    @BeforeClass
    public void setup() {
        METADATA.getFunctionAndTypeManager().registerBuiltInFunctions((List)ImmutableList.of((Object)ApplyFunction.APPLY_FUNCTION));
        this.setupJsonFunctionNamespaceManager(METADATA.getFunctionAndTypeManager());
    }

    @Test
    public void testAnd() {
        TestExpressionInterpreter.assertOptimizedEquals("true and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("false and true", "false");
        TestExpressionInterpreter.assertOptimizedEquals("false and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("false and null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null and true", "null");
        TestExpressionInterpreter.assertOptimizedEquals("null and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string='z' and true", "unbound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string='z' and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true and unbound_string='z'", "unbound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("false and unbound_string='z'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' and bound_long=1+1", "bound_string='z' and bound_long=2");
        TestExpressionInterpreter.assertOptimizedEquals("random() > 0 and random() > 0", "random() > 0 and random() > 0");
    }

    @Test
    public void testOr() {
        TestExpressionInterpreter.assertOptimizedEquals("true or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("true or false", "true");
        TestExpressionInterpreter.assertOptimizedEquals("false or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("false or false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true or null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null or null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("false or null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("null or false", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' or false", "bound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("true or bound_string='z'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("false or bound_string='z'", "bound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' or bound_long=1+1", "bound_string='z' or bound_long=2");
        TestExpressionInterpreter.assertOptimizedEquals("random() > 0 or random() > 0", "random() > 0 or random() > 0");
    }

    @Test
    public void testComparison() {
        TestExpressionInterpreter.assertOptimizedEquals("null = null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' = 'b'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' = 'a'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'a' = null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("null = 'a'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer = 1234", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer = 12340000000", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long = BIGINT '1234'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long = 1234", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_double = 12.34", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string = 'hello'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long = unbound_long", "1234 = unbound_long");
        TestExpressionInterpreter.assertOptimizedEquals("10151082135029368 = 10151082135029369", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_varbinary = X'a b'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_varbinary = X'a d'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1.1 = 1.1", "true");
        TestExpressionInterpreter.assertOptimizedEquals("9876543210.9874561203 = 9876543210.9874561203", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_short = 123.45", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_long = 12345678901234567890.123", "true");
    }

    @Test
    public void testIsDistinctFrom() {
        TestExpressionInterpreter.assertOptimizedEquals("null is distinct from null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from 4", "true");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from BIGINT '4'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from 4000000000", "true");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from 3", "false");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null is distinct from 3", "true");
        TestExpressionInterpreter.assertOptimizedEquals("10151082135029368 is distinct from 10151082135029369", "true");
        TestExpressionInterpreter.assertOptimizedEquals("1.1 is distinct from 1.1", "false");
        TestExpressionInterpreter.assertOptimizedEquals("9876543210.9874561203 is distinct from NULL", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_short is distinct from NULL", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_long is distinct from 12345678901234567890.123", "false");
    }

    @Test
    public void testIsNull() {
        TestExpressionInterpreter.assertOptimizedEquals("null is null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("1 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("10000000000 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("BIGINT '1' is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1.0 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null+1 is null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string is null", "unbound_string is null");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_long+(1+1) is null", "unbound_long+2 is null");
        TestExpressionInterpreter.assertOptimizedEquals("1.1 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("9876543210.9874561203 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_short is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_long is null", "false");
    }

    @Test
    public void testIsNotNull() {
        TestExpressionInterpreter.assertOptimizedEquals("null is not null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("10000000000 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("BIGINT '1' is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("1.0 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'a' is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("true is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null+1 is not null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string is not null", "unbound_string is not null");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_long+(1+1) is not null", "unbound_long+2 is not null");
        TestExpressionInterpreter.assertOptimizedEquals("1.1 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("9876543210.9874561203 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_short is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_long is not null", "true");
    }

    @Test
    public void testNullIf() {
        TestExpressionInterpreter.assertOptimizedEquals("nullif(true, true)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(true, false)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(null, false)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(true, null)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("nullif('a', 'a')", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif('a', 'b')", "'a'");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(null, 'b')", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif('a', null)", "'a'");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 2)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, BIGINT '2')", "1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 20000000000)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.0E0, 1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(10000000000.0E0, 10000000000)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.1E0, 1)", "1.1E0");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.1E0, 1.1E0)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 2-1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(null, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, null)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(unbound_long, 1)", "nullif(unbound_long, 1)");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(unbound_long, unbound_long2)", "nullif(unbound_long, unbound_long2)");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(unbound_long, unbound_long2+(1+1))", "nullif(unbound_long, unbound_long2+2)");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.1, 1.2)", "1.1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(9876543210.9874561203, 9876543210.9874561203)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(bound_decimal_short, 123.45)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(bound_decimal_long, 12345678901234567890.123)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(ARRAY[CAST(1 AS BIGINT)], ARRAY[CAST(1 AS BIGINT)]) IS NULL", "true");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(ARRAY[CAST(1 AS BIGINT)], ARRAY[CAST(NULL AS BIGINT)]) IS NULL", "false");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(ARRAY[CAST(NULL AS BIGINT)], ARRAY[CAST(NULL AS BIGINT)]) IS NULL", "false");
    }

    @Test
    public void testNegative() {
        TestExpressionInterpreter.assertOptimizedEquals("-(1)", "-1");
        TestExpressionInterpreter.assertOptimizedEquals("-(BIGINT '1')", "BIGINT '-1'");
        TestExpressionInterpreter.assertOptimizedEquals("-(unbound_long+1)", "-(unbound_long+1)");
        TestExpressionInterpreter.assertOptimizedEquals("-(1+1)", "-2");
        TestExpressionInterpreter.assertOptimizedEquals("-(1+ BIGINT '1')", "BIGINT '-2'");
        TestExpressionInterpreter.assertOptimizedEquals("-(CAST(NULL AS BIGINT))", "null");
        TestExpressionInterpreter.assertOptimizedEquals("-(unbound_long+(1+1))", "-(unbound_long+2)");
        TestExpressionInterpreter.assertOptimizedEquals("-(1.1+1.2)", "-2.3");
        TestExpressionInterpreter.assertOptimizedEquals("-(9876543210.9874561203-9876543210.9874561203)", "CAST(0 AS DECIMAL(20,10))");
        TestExpressionInterpreter.assertOptimizedEquals("-(bound_decimal_short+123.45)", "-246.90");
        TestExpressionInterpreter.assertOptimizedEquals("-(bound_decimal_long-12345678901234567890.123)", "CAST(0 AS DECIMAL(20,10))");
    }

    @Test
    public void testNot() {
        TestExpressionInterpreter.assertOptimizedEquals("not true", "false");
        TestExpressionInterpreter.assertOptimizedEquals("not false", "true");
        TestExpressionInterpreter.assertOptimizedEquals("not null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("not 1=1", "false");
        TestExpressionInterpreter.assertOptimizedEquals("not 1=BIGINT '1'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("not 1!=1", "true");
        TestExpressionInterpreter.assertOptimizedEquals("not unbound_long=1", "not unbound_long=1");
        TestExpressionInterpreter.assertOptimizedEquals("not unbound_long=(1+1)", "not unbound_long=2");
    }

    @Test
    public void testFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals("abs(-5)", "5");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-10-5)", "15");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-bound_integer + 1)", "1233");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-bound_long + 1)", "1233");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-bound_long + BIGINT '1')", "1233");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-bound_long)", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("abs(unbound_long)", "abs(unbound_long)");
        TestExpressionInterpreter.assertOptimizedEquals("abs(unbound_long + 1)", "abs(unbound_long + 1)");
        TestExpressionInterpreter.assertOptimizedEquals("cast(json_parse(unbound_string) as map(varchar, varchar))", "cast(json_parse(unbound_string) as map(varchar, varchar))");
        TestExpressionInterpreter.assertOptimizedEquals("cast(json_parse(unbound_string) as array(varchar))", "cast(json_parse(unbound_string) as array(varchar))");
        TestExpressionInterpreter.assertOptimizedEquals("cast(json_parse(unbound_string) as row(bigint, varchar))", "cast(json_parse(unbound_string) as row(bigint, varchar))");
    }

    @Test
    public void testNonDeterministicFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals("random()", "random()");
        Object value = TestExpressionInterpreter.evaluate("random()", false);
        Assert.assertTrue((boolean)(value instanceof Double));
        double randomValue = (Double)value;
        Assert.assertTrue((0.0 <= randomValue && randomValue < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testCppFunctionCall() {
        METADATA.getFunctionAndTypeManager().createFunction(SQUARE_UDF_CPP, false);
        TestExpressionInterpreter.assertOptimizedEquals("json.test_schema.square(-5)", "json.test_schema.square(-5)");
    }

    @Test
    public void testCppAggregateFunctionCall() {
        METADATA.getFunctionAndTypeManager().createFunction(AVG_UDAF_CPP, false);
        TestExpressionInterpreter.assertOptimizedEquals("json.test_schema.avg(1.0)", "json.test_schema.avg(1.0)");
    }

    private void setupJsonFunctionNamespaceManager(FunctionAndTypeManager functionAndTypeManager) {
        functionAndTypeManager.addFunctionNamespaceFactory((FunctionNamespaceManagerFactory)new JsonFileBasedFunctionNamespaceManagerFactory());
        functionAndTypeManager.loadFunctionNamespaceManager("json_file", "json", (Map)ImmutableMap.of((Object)"supported-function-languages", (Object)"CPP", (Object)"function-implementation-type", (Object)"CPP"));
    }

    @Test
    public void testBetween() {
        TestExpressionInterpreter.assertOptimizedEquals("3 between 2 and 4", "true");
        TestExpressionInterpreter.assertOptimizedEquals("2 between 3 and 4", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null between 2 and 4", "null");
        TestExpressionInterpreter.assertOptimizedEquals("3 between null and 4", "null");
        TestExpressionInterpreter.assertOptimizedEquals("3 between 2 and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'cc' between 'b' and 'd'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'b' between 'cc' and 'd'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null between 'b' and 'd'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'cc' between null and 'd'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'cc' between 'b' and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer between 1000 and 2000", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer between 3 and 4", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between 1000 and 2000", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between 3 and 4", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between bound_integer and (bound_long + 1)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string between 'e' and 'i'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string between 'a' and 'b'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between unbound_long and 2000 + 1", "1234 between unbound_long and 2001");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string between unbound_string and 'bar'", String.format("CAST('hello' AS VARCHAR(%s)) between unbound_string and 'bar'", 17));
        TestExpressionInterpreter.assertOptimizedEquals("1.15 between 1.1 and 1.2", "true");
        TestExpressionInterpreter.assertOptimizedEquals("9876543210.98745612035 between 9876543210.9874561203 and 9876543210.9874561204", "true");
        TestExpressionInterpreter.assertOptimizedEquals("123.455 between bound_decimal_short and 123.46", "true");
        TestExpressionInterpreter.assertOptimizedEquals("12345678901234567890.1235 between bound_decimal_long and 12345678901234567890.123", "false");
    }

    @Test
    public void testExtract() {
        DateTime dateTime = new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        double seconds = (double)dateTime.getMillis() / 1000.0;
        TestExpressionInterpreter.assertOptimizedEquals("extract (YEAR from from_unixtime(" + seconds + "))", "2001");
        TestExpressionInterpreter.assertOptimizedEquals("extract (QUARTER from from_unixtime(" + seconds + "))", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MONTH from from_unixtime(" + seconds + "))", "8");
        TestExpressionInterpreter.assertOptimizedEquals("extract (WEEK from from_unixtime(" + seconds + "))", "34");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOW from from_unixtime(" + seconds + "))", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOY from from_unixtime(" + seconds + "))", "234");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DAY from from_unixtime(" + seconds + "))", "22");
        TestExpressionInterpreter.assertOptimizedEquals("extract (HOUR from from_unixtime(" + seconds + "))", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MINUTE from from_unixtime(" + seconds + "))", "4");
        TestExpressionInterpreter.assertOptimizedEquals("extract (SECOND from from_unixtime(" + seconds + "))", "5");
        TestExpressionInterpreter.assertOptimizedEquals("extract (TIMEZONE_HOUR from from_unixtime(" + seconds + ", 7, 9))", "7");
        TestExpressionInterpreter.assertOptimizedEquals("extract (TIMEZONE_MINUTE from from_unixtime(" + seconds + ", 7, 9))", "9");
        TestExpressionInterpreter.assertOptimizedEquals("extract (YEAR from bound_timestamp)", "2001");
        TestExpressionInterpreter.assertOptimizedEquals("extract (QUARTER from bound_timestamp)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MONTH from bound_timestamp)", "8");
        TestExpressionInterpreter.assertOptimizedEquals("extract (WEEK from bound_timestamp)", "34");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOW from bound_timestamp)", "2");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOY from bound_timestamp)", "233");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DAY from bound_timestamp)", "21");
        TestExpressionInterpreter.assertOptimizedEquals("extract (HOUR from bound_timestamp)", "16");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MINUTE from bound_timestamp)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("extract (SECOND from bound_timestamp)", "5");
        TestExpressionInterpreter.assertOptimizedEquals("extract (YEAR from unbound_timestamp)", "extract (YEAR from unbound_timestamp)");
        TestExpressionInterpreter.assertOptimizedEquals("extract (SECOND from bound_timestamp + INTERVAL '3' SECOND)", "8");
    }

    @Test
    public void testIn() {
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, 4, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, 4, 9, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, null, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'foo' in ('bar', 'baz', 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'foo' in ('bar', 'baz', 'buz', 'blah')", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'foo' in ('bar', null, 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null in (2, null, 3, 5)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer in (2, 1234, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer in (2, 4, 3, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1234 in (2, bound_integer, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("99 in (2, bound_integer, 3, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_integer in (2, bound_integer, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 1234, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 4, 3, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1234 in (2, bound_long, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("99 in (2, bound_long, 3, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, bound_long, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string in ('bar', 'hello', 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string in ('bar', 'baz', 'foo', 'blah')", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'hello' in ('bar', bound_string, 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'baz' in ('bar', bound_string, 'foo', 'blah')", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 1234, unbound_long, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string in ('bar', 'hello', unbound_string, 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 4, unbound_long, unbound_long2, 9)", "1234 in (unbound_long, unbound_long2)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_long in (2, 4, bound_long, unbound_long2, 5)", "unbound_long in (2, 4, 1234, unbound_long2, 5)");
        TestExpressionInterpreter.assertOptimizedEquals("1.15 in (1.1, 1.2, 1.3, 1.15)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("9876543210.98745612035 in (9876543210.9874561203, 9876543210.9874561204, 9876543210.98745612035)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_short in (123.455, 123.46, 123.45)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_long in (12345678901234567890.123, 9876543210.9874561204, 9876543210.98745612035)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_decimal_long in (9876543210.9874561204, null, 9876543210.98745612035)", "null");
    }

    @Test
    public void testInComplexTypes() {
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[null] IN (ARRAY[null])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[1] IN (ARRAY[null])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[null] IN (ARRAY[1])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[1, null] IN (ARRAY[1, null])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[1, null] IN (ARRAY[2, null])", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[1, null] IN (ARRAY[1, null], ARRAY[2, null])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[1, null] IN (ARRAY[1, null], ARRAY[2, null], ARRAY[1, null])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ARRAY[ARRAY[1, 2], ARRAY[3, 4]] in (ARRAY[ARRAY[1, 2], ARRAY[3, NULL]])", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1) IN (ROW(1))", "true");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1) IN (ROW(2))", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1) IN (ROW(2), ROW(1), ROW(2))", "true");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1) IN (null)", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1) IN (null, ROW(1))", "true");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1, null) IN (ROW(2, null), null)", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(null) IN (ROW(null))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1) IN (ROW(null))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(null) IN (ROW(1))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1, null) IN (ROW(1, null))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1, null) IN (ROW(2, null))", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1, null) IN (ROW(1, null), ROW(2, null))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("ROW(1, null) IN (ROW(1, null), ROW(2, null), ROW(1, null))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[1]) IN (MAP(ARRAY[1], ARRAY[1]))", "true");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[1]) IN (null)", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[1]) IN (null, MAP(ARRAY[1], ARRAY[1]))", "true");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[1]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]))", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[2, null]), null)", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 3], ARRAY[1, null]))", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[null]) IN (MAP(ARRAY[1], ARRAY[null]))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[1]) IN (MAP(ARRAY[1], ARRAY[null]))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1], ARRAY[null]) IN (MAP(ARRAY[1], ARRAY[1]))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 3], ARRAY[1, null]))", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[2, null]))", "false");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]), MAP(ARRAY[1, 2], ARRAY[2, null]))", "null");
        TestExpressionInterpreter.assertEvaluatedEquals("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]), MAP(ARRAY[1, 2], ARRAY[2, null]), MAP(ARRAY[1, 2], ARRAY[1, null]))", "null");
    }

    @Test
    public void testCurrentTimestamp() {
        double current = (double)SessionTestUtils.TEST_SESSION.getStartTime() / 1000.0;
        TestExpressionInterpreter.assertOptimizedEquals("current_timestamp = from_unixtime(" + current + ")", "true");
        double future = current + (double)TimeUnit.MINUTES.toSeconds(1L);
        TestExpressionInterpreter.assertOptimizedEquals("current_timestamp > from_unixtime(" + future + ")", "false");
    }

    @Test
    public void testCurrentUser() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("current_user", "'" + SessionTestUtils.TEST_SESSION.getUser() + "'");
    }

    @Test
    public void testCastToString() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as VARCHAR(20))", "'123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as VARCHAR(20))", "'-123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '123' as VARCHAR)", "'123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(12300000000 as VARCHAR)", "'12300000000'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-12300000000 as VARCHAR)", "'-12300000000'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0E0 as VARCHAR)", "'123.0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0E0 as VARCHAR)", "'-123.0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456E0 as VARCHAR)", "'123.456'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456E0 as VARCHAR)", "'-123.456'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as VARCHAR)", "'true'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as VARCHAR)", "'false'");
        TestExpressionInterpreter.assertOptimizedEquals("cast('xyz' as VARCHAR)", "'xyz'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(cast('abcxyz' as VARCHAR(3)) as VARCHAR(5))", "'abc'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as VARCHAR)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(1.1 as VARCHAR)", "'1.1'");
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestExpressionInterpreter.assertEvaluatedEquals("CAST(12300000000 AS varchar(11))", "'12300000000'");
        TestExpressionInterpreter.assertEvaluatedEquals("CAST(12300000000 AS varchar(50))", "'12300000000'");
        try {
            TestExpressionInterpreter.evaluate("CAST(12300000000 AS varchar(3))", true);
            Assert.fail((String)"Expected to throw an INVALID_CAST_ARGUMENT exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)"Value 12300000000 cannot be represented as varchar(3)");
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
        try {
            TestExpressionInterpreter.evaluate("CAST(-12300000000 AS varchar(3))", true);
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)"Value -12300000000 cannot be represented as varchar(3)");
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    @Test
    public void testCastToBoolean() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(12300000000 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-12300000000 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '0' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast('true' as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast('false' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast('t' as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast('f' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast('1' as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast('0' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as BOOLEAN)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.45E0 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.45E0 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0.0E0 as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0.00 as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(7.8 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(12345678901234567890.123 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(00000000000000000000.000 as BOOLEAN)", "false");
    }

    @Test
    public void testCastToBigint() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as BIGINT)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '0' as BIGINT)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '123' as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '-123' as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0E0 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0E0 as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456E0 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456E0 as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as BIGINT)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as BIGINT)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123' as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123' as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as BIGINT)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(DECIMAL '1.01' as BIGINT)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("cast(DECIMAL '7.8' as BIGINT)", "8");
        TestExpressionInterpreter.assertOptimizedEquals("cast(DECIMAL '1234567890.123' as BIGINT)", "1234567890");
        TestExpressionInterpreter.assertOptimizedEquals("cast(DECIMAL '00000000000000000000.000' as BIGINT)", "0");
    }

    @Test
    public void testCastToInteger() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as INTEGER)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as INTEGER)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as INTEGER)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '0' as INTEGER)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '123' as INTEGER)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '-123' as INTEGER)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0E0 as INTEGER)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0E0 as INTEGER)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456E0 as INTEGER)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456E0 as INTEGER)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as INTEGER)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as INTEGER)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123' as INTEGER)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123' as INTEGER)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as INTEGER)", "null");
    }

    @Test
    public void testCastToDouble() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as DOUBLE)", "0.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as DOUBLE)", "123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as DOUBLE)", "-123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(BIGINT '0' as DOUBLE)", "0.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(12300000000 as DOUBLE)", "12300000000.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-12300000000 as DOUBLE)", "-12300000000.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0E0 as DOUBLE)", "123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0E0 as DOUBLE)", "-123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456E0 as DOUBLE)", "123.456E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456E0 as DOUBLE)", "-123.456E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('0' as DOUBLE)", "0.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123' as DOUBLE)", "123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123' as DOUBLE)", "-123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123.0E0' as DOUBLE)", "123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123.0E0' as DOUBLE)", "-123.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123.456E0' as DOUBLE)", "123.456E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123.456E0' as DOUBLE)", "-123.456E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as DOUBLE)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as DOUBLE)", "1.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as DOUBLE)", "0.0E0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(1.01 as DOUBLE)", "DOUBLE '1.01'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(7.8 as DOUBLE)", "DOUBLE '7.8'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(1234567890.123 as DOUBLE)", "DOUBLE '1234567890.123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(00000000000000000000.000 as DOUBLE)", "DOUBLE '0.0'");
    }

    @Test
    public void testCastToDecimal() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as DECIMAL(1,0))", "DECIMAL '0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as DECIMAL(3,0))", "DECIMAL '123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as DECIMAL(3,0))", "DECIMAL '-123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as DECIMAL(20,10))", "cast(-123 as DECIMAL(20,10))");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0E0 as DECIMAL(1,0))", "DECIMAL '0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.2E0 as DECIMAL(4,1))", "DECIMAL '123.2'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0E0 as DECIMAL(3,0))", "DECIMAL '-123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.55E0 as DECIMAL(20,10))", "cast(-123.55 as DECIMAL(20,10))");
        TestExpressionInterpreter.assertOptimizedEquals("cast('0' as DECIMAL(1,0))", "DECIMAL '0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123.2' as DECIMAL(4,1))", "DECIMAL '123.2'");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123.0' as DECIMAL(3,0))", "DECIMAL '-123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123.55' as DECIMAL(20,10))", "cast(-123.55 as DECIMAL(20,10))");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as DECIMAL(1,0))", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as DECIMAL(20,10))", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as DECIMAL(1,0))", "DECIMAL '1'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as DECIMAL(4,1))", "DECIMAL '000.0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as DECIMAL(3,0))", "DECIMAL '001'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as DECIMAL(20,10))", "cast(0 as DECIMAL(20,10))");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0.0 as DECIMAL(1,0))", "DECIMAL '0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.2 as DECIMAL(4,1))", "DECIMAL '123.2'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0 as DECIMAL(3,0))", "DECIMAL '-123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.55 as DECIMAL(20,10))", "cast(-123.55 as DECIMAL(20,10))");
    }

    @Test
    public void testCastOptimization() {
        TestExpressionInterpreter.assertOptimizedEquals("cast(unbound_string as VARCHAR)", "cast(unbound_string as VARCHAR)");
        TestExpressionInterpreter.assertOptimizedMatches("cast(unbound_string as VARCHAR)", "unbound_string");
        TestExpressionInterpreter.assertOptimizedMatches("cast(unbound_integer as INTEGER)", "unbound_integer");
        TestExpressionInterpreter.assertOptimizedMatches("cast(unbound_string as VARCHAR(10))", "cast(unbound_string as VARCHAR(10))");
    }

    @Test
    public void testTryCast() {
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(null as BIGINT)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(123 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(null as INTEGER)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(123 as INTEGER)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast('foo' as VARCHAR)", "'foo'");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast('foo' as BIGINT)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(unbound_string as BIGINT)", "try_cast(unbound_string as BIGINT)");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast('foo' as DECIMAL(2,1))", "null");
    }

    @Test
    public void testReservedWithDoubleQuotes() {
        TestExpressionInterpreter.assertOptimizedEquals("\"time\"", "\"time\"");
    }

    @Test
    public void testSearchCase() {
        TestExpressionInterpreter.assertOptimizedEquals("case when true then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 10000000000 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when bound_long = 1234 then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when true then bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1 else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when bound_integer = 1234 then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when true then bound_integer end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1 else bound_integer end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when bound_long = 1234 then 33 else unbound_long end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when true then bound_long else unbound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then unbound_long else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when bound_integer = 1234 then 33 else unbound_integer end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when true then bound_integer else unbound_integer end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then unbound_integer else bound_integer end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when unbound_long = 1234 then 33 else 1 end", "case when unbound_long = 1234 then 33 else 1 end");
        TestExpressionInterpreter.assertOptimizedMatches("if(false, 1, 0 / 0)", "cast(fail(8, 'ignored failure message') as integer)");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 2.2 when true then 2.2 end", "2.2");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1234567890.0987654321 when true then 3.3 end", "CAST(3.3 AS DECIMAL(20,10))");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1 when true then 2.2 end", "2.2");
        TestExpressionInterpreter.assertOptimizedEquals("case when ARRAY[CAST(1 AS BIGINT)] = ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", "'matched'");
        TestExpressionInterpreter.assertOptimizedEquals("case when ARRAY[CAST(2 AS BIGINT)] = ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", "'not_matched'");
        TestExpressionInterpreter.assertOptimizedEquals("case when ARRAY[CAST(null AS BIGINT)] = ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", "'not_matched'");
    }

    @Test
    public void testSimpleCase() {
        TestExpressionInterpreter.assertOptimizedEquals("case 1 when 1 then 32 + 1 when 1 then 34 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case null when true then 33 end", "null");
        TestExpressionInterpreter.assertOptimizedEquals("case null when true then 33 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when null then 1 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case null when true then 3300000000 end", "null");
        TestExpressionInterpreter.assertOptimizedEquals("case null when true then 3300000000 else 3300000000 end", "3300000000");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when null then 3300000000 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 1 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when 1234 then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case 1234 when bound_long then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 1 else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_integer when 1234 then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case 1234 when bound_integer then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then bound_integer end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 1 else bound_integer end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when 1234 then 33 else unbound_long end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then bound_long else unbound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then unbound_long else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case unbound_long when 1234 then 33 else 1 end", "case unbound_long when 1234 then 33 else 1 end");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when 0 then 0 when 33 then unbound_long else 1 end", "unbound_long");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when 0 then 0 when 33 then 1 when unbound_long then 2 else 1 end", "1");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when unbound_long then 0 when 1 then 1 when 33 then 2 else 0 end", "case 33 when unbound_long then 0 else 2 end");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when 0 then 0 when 1 then 1 else unbound_long end", "unbound_long");
        TestExpressionInterpreter.assertOptimizedEquals("case 33 when unbound_long then 0 when 1 then 1 when unbound_long2 then 2 else 3 end", "case 33 when unbound_long then 0 when unbound_long2 then 2 else 3 end");
        TestExpressionInterpreter.assertOptimizedEquals("case true when unbound_long = 1 then 1 when 0 / 0 = 0 then 2 else 33 end", "case true when unbound_long = 1 then 1 when 0 / 0 = 0 then 2 else 33 end");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when 123 * 10 + unbound_long then 1 = 1 else 1 = 2 end", "case bound_long when 1230 + unbound_long then true else false end");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when unbound_long then 2 + 2 end", "case bound_long when unbound_long then 4 end");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when unbound_long then 2 + 2 when 1 then null when 2 then null end", "case bound_long when unbound_long then 4 end");
        TestExpressionInterpreter.assertOptimizedMatches("case 1 when unbound_long then 1 when 0 / 0 then 2 else 1 end", "case BIGINT '1' when unbound_long then 1 when cast(fail(8, 'ignored failure message') AS integer) then 2 else 1 end");
        TestExpressionInterpreter.assertOptimizedMatches("case 1 when 0 / 0 then 1 when 0 / 0 then 2 else 1 end", "case 1 when cast(fail(8, 'ignored failure message') as integer) then 1 when cast(fail(8, 'ignored failure message') as integer) then 2 else 1 end");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 2.2 when true then 2.2 end", "2.2");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 1 when true then 2.2 end", "2.2");
        TestExpressionInterpreter.assertOptimizedEquals("case ARRAY[CAST(1 AS BIGINT)] when ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", "'matched'");
        TestExpressionInterpreter.assertOptimizedEquals("case ARRAY[CAST(2 AS BIGINT)] when ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", "'not_matched'");
        TestExpressionInterpreter.assertOptimizedEquals("case ARRAY[CAST(null AS BIGINT)] when ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", "'not_matched'");
    }

    @Test
    public void testCoalesce() {
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(null, null)", "coalesce(null, null)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(2 * 3 * unbound_long, 1 - 1, null)", "coalesce(6 * unbound_long, 0)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(2 * 3 * unbound_long, 1.0E0/2.0E0, null)", "coalesce(6 * unbound_long, 0.5E0)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(unbound_long, 2, 1.0E0/2.0E0, 12.34E0, null)", "coalesce(unbound_long, 2.0E0, 0.5E0, 12.34E0)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(2 * 3 * unbound_integer, 1 - 1, null)", "coalesce(6 * unbound_integer, 0)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(2 * 3 * unbound_integer, 1.0E0/2.0E0, null)", "coalesce(6 * unbound_integer, 0.5E0)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(unbound_integer, 2, 1.0E0/2.0E0, 12.34E0, null)", "coalesce(unbound_integer, 2.0E0, 0.5E0, 12.34E0)");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(0 / 0 > 1, unbound_boolean, 0 / 0 = 0)", "coalesce(cast(fail(8, 'ignored failure message') as boolean), unbound_boolean)");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, unbound_long)", "unbound_long");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(2 * unbound_long, 2 * unbound_long)", "BIGINT '2' * unbound_long");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, unbound_long2, unbound_long)", "coalesce(unbound_long, unbound_long2)");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, unbound_long2, unbound_long, unbound_long3)", "coalesce(unbound_long, unbound_long2, unbound_long3)");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(6, unbound_long2, unbound_long, unbound_long3)", "6");
        TestExpressionInterpreter.assertOptimizedEquals("coalesce(2 * 3, unbound_long2, unbound_long, unbound_long3)", "6");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, coalesce(unbound_long, 1))", "coalesce(unbound_long, BIGINT '1')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(coalesce(unbound_long, coalesce(unbound_long, 1)), unbound_long2)", "coalesce(unbound_long, BIGINT '1')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, 2, coalesce(unbound_long, 1))", "coalesce(unbound_long, BIGINT '2')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(coalesce(unbound_long, coalesce(unbound_long2, unbound_long3)), 1)", "coalesce(unbound_long, unbound_long2, unbound_long3, BIGINT '1')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_double, coalesce(random(), unbound_double))", "coalesce(unbound_double, random())");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(random(), random(), 5)", "coalesce(random(), random(), 5E0)");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, coalesce(unbound_long, 1))", "coalesce(unbound_long, BIGINT '1')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(coalesce(unbound_long, coalesce(unbound_long, 1)), unbound_long2)", "coalesce(unbound_long, BIGINT '1')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_long, 2, coalesce(unbound_long, 1))", "coalesce(unbound_long, BIGINT '2')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(coalesce(unbound_long, coalesce(unbound_long2, unbound_long3)), 1)", "coalesce(unbound_long, unbound_long2, unbound_long3, BIGINT '1')");
        TestExpressionInterpreter.assertOptimizedMatches("coalesce(unbound_double, coalesce(random(), unbound_double))", "coalesce(unbound_double, random())");
    }

    @Test
    public void testIf() {
        TestExpressionInterpreter.assertOptimizedEquals("IF(2 = 2, 3, 4)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("IF(1 = 2, 3, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(1 = 2, BIGINT '3', 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(1 = 2, 3000000000, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 3, 4)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 3, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(null, 3, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 3, null)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 3, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, null, 4)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, null, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, null, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, null, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 3.5E0, 4.2E0)", "3.5E0");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 3.5E0, 4.2E0)", "4.2E0");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 'foo', 'bar')", "'foo'");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 'foo', 'bar')", "'bar'");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 1.01, 1.02)", "1.01");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 1.01, 1.02)", "1.02");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 1234567890.123, 1.02)", "1234567890.123");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 1.01, 1234567890.123)", "1234567890.123");
    }

    @Test
    public void testLike() {
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE 'a'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE 'a'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE 'a'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE '_'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE '_'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '_'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE '%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE '%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '___'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'ab' LIKE '___'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abcd' LIKE '___'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE 'abc'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'xyz' LIKE 'abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE 'abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE 'abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE 'abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE 'abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE 'abc%'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%abc'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE '%abc'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE '%abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc0' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'xyzw' LIKE '%abc%'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'ab01c' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0ab01c' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'ab01c0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0ab01c0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'xyzw' LIKE '%ab%c%'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE ''", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'.*' LIKE '.*'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'[' LIKE '['", "true");
        TestExpressionInterpreter.assertOptimizedEquals("']' LIKE ']'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'{' LIKE '{'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'}' LIKE '}'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'?' LIKE '?'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'+' LIKE '+'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'(' LIKE '('", "true");
        TestExpressionInterpreter.assertOptimizedEquals("')' LIKE ')'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'|' LIKE '|'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'^' LIKE '^'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'$' LIKE '$'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null LIKE '%'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE '%' ESCAPE null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE unbound_string ESCAPE null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'%' LIKE 'z%' ESCAPE 'z'", "true");
        TestExpressionInterpreter.assertRowExpressionEquals(ExpressionOptimizer.Level.SERIALIZABLE, "'%' LIKE 'z%' ESCAPE 'z'", "true");
        TestExpressionInterpreter.assertRowExpressionEquals(ExpressionOptimizer.Level.SERIALIZABLE, "'%' LIKE 'z%'", "false");
    }

    @Test
    public void testLikeOptimization() {
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'abc'", "unbound_string = CAST('abc' AS VARCHAR)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE '' ESCAPE '#'", "unbound_string LIKE '' ESCAPE '#'");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'abc' ESCAPE '#'", "unbound_string = CAST('abc' AS VARCHAR)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'a#_b' ESCAPE '#'", "unbound_string = CAST('a_b' AS VARCHAR)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'a#%b' ESCAPE '#'", "unbound_string = CAST('a%b' AS VARCHAR)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'a#_##b' ESCAPE '#'", "unbound_string = CAST('a_#b' AS VARCHAR)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'a#__b' ESCAPE '#'", "unbound_string LIKE 'a#__b' ESCAPE '#'");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE 'a##%b' ESCAPE '#'", "unbound_string LIKE 'a##%b' ESCAPE '#'");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string LIKE bound_pattern", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE bound_pattern", "false");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE bound_pattern", "unbound_string LIKE bound_pattern");
        TestExpressionInterpreter.assertDoNotOptimize("unbound_string LIKE 'abc%'", ExpressionOptimizer.Level.SERIALIZABLE);
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string LIKE unbound_pattern ESCAPE unbound_string", "unbound_string LIKE unbound_pattern ESCAPE unbound_string");
    }

    @Test
    public void testInvalidLike() {
        Assert.assertThrows(PrestoException.class, () -> TestExpressionInterpreter.optimize("unbound_string LIKE 'abc' ESCAPE ''"));
        Assert.assertThrows(PrestoException.class, () -> TestExpressionInterpreter.optimize("unbound_string LIKE 'abc' ESCAPE 'bc'"));
        Assert.assertThrows(PrestoException.class, () -> TestExpressionInterpreter.optimize("unbound_string LIKE '#' ESCAPE '#'"));
        Assert.assertThrows(PrestoException.class, () -> TestExpressionInterpreter.optimize("unbound_string LIKE '#abc' ESCAPE '#'"));
        Assert.assertThrows(PrestoException.class, () -> TestExpressionInterpreter.optimize("unbound_string LIKE 'ab#' ESCAPE '#'"));
    }

    @Test
    public void testLambda() {
        TestExpressionInterpreter.assertDoNotOptimize("transform(unbound_array, x -> x + x)", ExpressionOptimizer.Level.OPTIMIZED);
        TestExpressionInterpreter.assertOptimizedEquals("transform(ARRAY[1, 5], x -> x + x)", "transform(ARRAY[1, 5], x -> x + x)");
        TestExpressionInterpreter.assertOptimizedEquals("transform(sequence(1, 5), x -> x + x)", "transform(sequence(1, 5), x -> x + x)");
        TestExpressionInterpreter.assertRowExpressionEquals(ExpressionOptimizer.Level.OPTIMIZED, "transform(sequence(1, unbound_long), x -> cast(json_parse('[1, 2]') AS ARRAY<INTEGER>)[1] + x)", "transform(sequence(1, unbound_long), x -> 1 + x)");
        TestExpressionInterpreter.assertRowExpressionEquals(ExpressionOptimizer.Level.OPTIMIZED, "transform(sequence(1, unbound_long), x -> cast(json_parse('[1, 2]') AS ARRAY<INTEGER>)[1] + 1)", "transform(sequence(1, unbound_long), x -> 2)");
        Assert.assertEquals((Object)TestExpressionInterpreter.evaluate("reduce(ARRAY[1, 5], 0, (x, y) -> x + y, x -> x)", true), (Object)6L);
    }

    @Test
    public void testBind() {
        TestExpressionInterpreter.assertOptimizedEquals("apply(90, \"$internal$bind\"(9, (x, y) -> x + y))", "apply(90, \"$internal$bind\"(9, (x, y) -> x + y))");
        TestExpressionInterpreter.evaluate("apply(90, \"$internal$bind\"(9, (x, y) -> x + y))", true);
        TestExpressionInterpreter.evaluate("apply(900, \"$internal$bind\"(90, 9, (x, y, z) -> x + y + z))", true);
    }

    @Test
    public void testFailedExpressionOptimization() {
        TestExpressionInterpreter.assertOptimizedMatches("CASE unbound_long WHEN 1 THEN 1 WHEN 0 / 0 THEN 2 END", "CASE unbound_long WHEN BIGINT '1' THEN 1 WHEN cast(fail(8, 'ignored failure message') as bigint) THEN 2 END");
        TestExpressionInterpreter.assertOptimizedMatches("CASE unbound_boolean WHEN true THEN 1 ELSE 0 / 0 END", "CASE unbound_boolean WHEN true THEN 1 ELSE cast(fail(8, 'ignored failure message') as integer) END");
        TestExpressionInterpreter.assertOptimizedMatches("CASE bound_long WHEN unbound_long THEN 1 WHEN 0 / 0 THEN 2 ELSE 1 END", "CASE BIGINT '1234' WHEN unbound_long THEN 1 WHEN cast(fail(8, 'ignored failure message') as bigint) THEN 2 ELSE 1 END");
        TestExpressionInterpreter.assertOptimizedMatches("case when unbound_boolean then 1 when 0 / 0 = 0 then 2 end", "case when unbound_boolean then 1 when cast(fail(8, 'ignored failure message') as boolean) then 2 end");
        TestExpressionInterpreter.assertOptimizedMatches("case when unbound_boolean then 1 else 0 / 0  end", "case when unbound_boolean then 1 else cast(fail(8, 'ignored failure message') as integer) end");
        TestExpressionInterpreter.assertOptimizedMatches("case when unbound_boolean then 0 / 0 else 1 end", "case when unbound_boolean then cast(fail(8, 'ignored failure message') as integer) else 1 end");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testOptimizeDivideByZero() {
        TestExpressionInterpreter.optimize("0 / 0");
    }

    @Test
    public void testMassiveArray() {
        TestExpressionInterpreter.assertRowExpressionEquals(ExpressionOptimizer.Level.OPTIMIZED, "SEQUENCE(1, 999)", String.format("ARRAY [%s]", Joiner.on((String)", ").join(IntStream.range(1, 1000).mapToObj(i -> "(BIGINT '" + i + "')").iterator())));
        TestExpressionInterpreter.assertDoNotOptimize("SEQUENCE(1, 1000)", ExpressionOptimizer.Level.SERIALIZABLE);
        TestExpressionInterpreter.optimize(String.format("ARRAY [%s]", Joiner.on((String)", ").join(IntStream.range(0, 10000).mapToObj(i -> "(bound_long + " + i + ")").iterator())));
        TestExpressionInterpreter.optimize(String.format("ARRAY [%s]", Joiner.on((String)", ").join(IntStream.range(0, 10000).mapToObj(i -> "(bound_integer + " + i + ")").iterator())));
        TestExpressionInterpreter.optimize(String.format("ARRAY [%s]", Joiner.on((String)", ").join(IntStream.range(0, 10000).mapToObj(i -> "'" + i + "'").iterator())));
        TestExpressionInterpreter.optimize(String.format("ARRAY [%s]", Joiner.on((String)", ").join(IntStream.range(0, 10000).mapToObj(i -> "ARRAY['" + i + "']").iterator())));
    }

    @Test
    public void testArrayConstructor() {
        TestExpressionInterpreter.optimize("ARRAY []");
        TestExpressionInterpreter.assertOptimizedEquals("ARRAY [(unbound_long + 0), (unbound_long + 1), (unbound_long + 2)]", "array_constructor((unbound_long + 0), (unbound_long + 1), (unbound_long + 2))");
        TestExpressionInterpreter.assertOptimizedEquals("ARRAY [(bound_long + 0), (unbound_long + 1), (bound_long + 2)]", "array_constructor((bound_long + 0), (unbound_long + 1), (bound_long + 2))");
        TestExpressionInterpreter.assertOptimizedEquals("ARRAY [(bound_long + 0), (unbound_long + 1), NULL]", "array_constructor((bound_long + 0), (unbound_long + 1), NULL)");
    }

    @Test
    public void testRowConstructor() {
        TestExpressionInterpreter.optimize("ROW(NULL)");
        TestExpressionInterpreter.optimize("ROW(1)");
        TestExpressionInterpreter.optimize("ROW(unbound_long + 0)");
        TestExpressionInterpreter.optimize("ROW(unbound_long + unbound_long2, unbound_string, unbound_double)");
        TestExpressionInterpreter.optimize("ROW(unbound_boolean, FALSE, ARRAY[unbound_long, unbound_long2], unbound_null_string, unbound_interval)");
        TestExpressionInterpreter.optimize("ARRAY [ROW(unbound_string, unbound_double), ROW(unbound_string, 0.0E0)]");
        TestExpressionInterpreter.optimize("ARRAY [ROW('string', unbound_double), ROW('string', bound_double)]");
        TestExpressionInterpreter.optimize("ROW(ROW(NULL), ROW(ROW(ROW(ROW('rowception')))))");
        TestExpressionInterpreter.optimize("ROW(unbound_string, bound_string)");
        TestExpressionInterpreter.optimize("ARRAY [ROW(unbound_string, unbound_double), ROW(CAST(bound_string AS VARCHAR), 0.0E0)]");
        TestExpressionInterpreter.optimize("ARRAY [ROW(CAST(bound_string AS VARCHAR), 0.0E0), ROW(unbound_string, unbound_double)]");
        TestExpressionInterpreter.optimize("ARRAY [ROW(unbound_string, unbound_double), CAST(NULL AS ROW(VARCHAR, DOUBLE))]");
        TestExpressionInterpreter.optimize("ARRAY [CAST(NULL AS ROW(VARCHAR, DOUBLE)), ROW(unbound_string, unbound_double)]");
    }

    @Test
    public void testDereference() {
        TestExpressionInterpreter.optimize("ARRAY []");
        TestExpressionInterpreter.assertOptimizedEquals("ARRAY [(unbound_long + 0), (unbound_long + 1), (unbound_long + 2)]", "array_constructor((unbound_long + 0), (unbound_long + 1), (unbound_long + 2))");
        TestExpressionInterpreter.assertOptimizedEquals("ARRAY [(bound_long + 0), (unbound_long + 1), (bound_long + 2)]", "array_constructor((bound_long + 0), (unbound_long + 1), (bound_long + 2))");
        TestExpressionInterpreter.assertOptimizedEquals("ARRAY [(bound_long + 0), (unbound_long + 1), NULL]", "array_constructor((bound_long + 0), (unbound_long + 1), NULL)");
    }

    @Test
    public void testRowDereference() {
        TestExpressionInterpreter.optimize("CAST(null AS ROW(a VARCHAR, b BIGINT)).a");
    }

    @Test
    public void testRowSubscript() {
        TestExpressionInterpreter.assertOptimizedEquals("ROW (1, 'a', true)[3]", "true");
        TestExpressionInterpreter.assertOptimizedEquals("ROW (1, 'a', ROW (2, 'b', ROW (3, 'c')))[3][3][2]", "'c'");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testArraySubscriptConstantNegativeIndex() {
        TestExpressionInterpreter.optimize("ARRAY [1, 2, 3][-1]");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testArraySubscriptConstantZeroIndex() {
        TestExpressionInterpreter.optimize("ARRAY [1, 2, 3][0]");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testMapSubscriptMissingKey() {
        TestExpressionInterpreter.optimize("MAP(ARRAY [1, 2], ARRAY [3, 4])[-1]");
    }

    @Test
    public void testMapSubscriptConstantIndexes() {
        TestExpressionInterpreter.optimize("MAP(ARRAY [1, 2], ARRAY [3, 4])[1]");
        TestExpressionInterpreter.optimize("MAP(ARRAY [BIGINT '1', 2], ARRAY [3, 4])[1]");
        TestExpressionInterpreter.optimize("MAP(ARRAY [1, 2], ARRAY [3, 4])[2]");
        TestExpressionInterpreter.optimize("MAP(ARRAY [ARRAY[1,1]], ARRAY['a'])[ARRAY[1,1]]");
    }

    @Test(timeOut=60000L)
    public void testLikeInvalidUtf8() {
        TestExpressionInterpreter.assertLike(new byte[]{97, 98, 99}, "%b%", true);
        TestExpressionInterpreter.assertLike(new byte[]{97, 98, 99, -1, 120, 121}, "%b%", true);
    }

    @Test
    public void testLiterals() {
        TestExpressionInterpreter.optimize("date '2013-04-03' + unbound_interval");
        TestExpressionInterpreter.optimize("time '03:04:05.321' + unbound_interval");
        TestExpressionInterpreter.optimize("time '03:04:05.321 UTC' + unbound_interval");
        TestExpressionInterpreter.optimize("timestamp '2013-04-03 03:04:05.321' + unbound_interval");
        TestExpressionInterpreter.optimize("timestamp '2013-04-03 03:04:05.321 UTC' + unbound_interval");
        TestExpressionInterpreter.optimize("interval '3' day * unbound_long");
        TestExpressionInterpreter.optimize("interval '3' year * unbound_long");
        Assert.assertEquals((Object)TestExpressionInterpreter.optimize("X'1234'"), (Object)Slices.wrappedBuffer((byte[])new byte[]{18, 52}));
    }

    private static void assertLike(byte[] value, String pattern, boolean expected) {
        LikePredicate predicate = new LikePredicate((Expression)TestExpressionInterpreter.rawStringLiteral(Slices.wrappedBuffer((byte[])value)), (Expression)new StringLiteral(pattern), Optional.empty());
        Assert.assertEquals((Object)TestExpressionInterpreter.evaluate((Expression)predicate, true), (Object)expected);
    }

    private static StringLiteral rawStringLiteral(final Slice slice) {
        return new StringLiteral(slice.toStringUtf8()){

            public Slice getSlice() {
                return slice;
            }
        };
    }

    private static void assertOptimizedEquals(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        Assert.assertEquals((Object)TestExpressionInterpreter.optimize(actual), (Object)TestExpressionInterpreter.optimize(expected));
    }

    private static void assertRowExpressionEquals(ExpressionOptimizer.Level level, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        Object actualResult = TestExpressionInterpreter.optimize(TestExpressionInterpreter.toRowExpression(TestExpressionInterpreter.expression(actual)), level);
        Object expectedResult = TestExpressionInterpreter.optimize(TestExpressionInterpreter.toRowExpression(TestExpressionInterpreter.expression(expected)), level);
        if (actualResult instanceof Block && expectedResult instanceof Block) {
            Assert.assertEquals((Object)TestExpressionInterpreter.blockToSlice((Block)actualResult), (Object)TestExpressionInterpreter.blockToSlice((Block)expectedResult));
            return;
        }
        Assert.assertEquals((Object)actualResult, (Object)expectedResult);
    }

    private static void assertOptimizedMatches(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        Object actualOptimized = TestExpressionInterpreter.optimize(actual);
        if (actualOptimized instanceof Expression) {
            actualOptimized = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new FailedFunctionRewriter(), (Expression)((Expression)actualOptimized));
        }
        Assert.assertEquals((Object)actualOptimized, (Object)ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected)));
    }

    private static Object optimize(@Language(value="SQL") String expression) {
        TestExpressionInterpreter.assertRoundTrip(expression);
        Expression parsedExpression = TestExpressionInterpreter.expression(expression);
        Object expressionResult = TestExpressionInterpreter.optimize(parsedExpression);
        RowExpression rowExpression = TestExpressionInterpreter.toRowExpression(parsedExpression);
        Object rowExpressionResult = TestExpressionInterpreter.optimize(rowExpression, ExpressionOptimizer.Level.OPTIMIZED);
        TestExpressionInterpreter.assertExpressionAndRowExpressionEquals(expressionResult, rowExpressionResult);
        return expressionResult;
    }

    private static Expression expression(String expression) {
        return FunctionAssertions.createExpression(expression, METADATA, SYMBOL_TYPES);
    }

    private static RowExpression toRowExpression(Expression expression) {
        return TRANSLATOR.translate(expression, SYMBOL_TYPES);
    }

    private static Object optimize(Expression expression) {
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)SessionTestUtils.TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, (TypeProvider)SYMBOL_TYPES, (Expression)expression, Collections.emptyMap(), (WarningCollector)WarningCollector.NOOP);
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer((Expression)expression, (Metadata)METADATA, (Session)SessionTestUtils.TEST_SESSION, (Map)expressionTypes);
        return interpreter.optimize(variable -> {
            Symbol symbol = new Symbol(variable.getName());
            Object value = TestExpressionInterpreter.symbolConstant(symbol);
            if (value == null) {
                return symbol.toSymbolReference();
            }
            return value;
        });
    }

    private static Object optimize(RowExpression expression, ExpressionOptimizer.Level level) {
        return new RowExpressionInterpreter(expression, METADATA.getFunctionAndTypeManager(), SessionTestUtils.TEST_SESSION.toConnectorSession(), level).optimize(variable -> {
            Symbol symbol = new Symbol(variable.getName());
            Object value = TestExpressionInterpreter.symbolConstant(symbol);
            if (value == null) {
                return new VariableReferenceExpression(Optional.empty(), symbol.getName(), SYMBOL_TYPES.get((Expression)symbol.toSymbolReference()));
            }
            return value;
        });
    }

    private static void assertDoNotOptimize(@Language(value="SQL") String expression, ExpressionOptimizer.Level optimizationLevel) {
        TestExpressionInterpreter.assertRoundTrip(expression);
        Expression translatedExpression = TestExpressionInterpreter.expression(expression);
        RowExpression rowExpression = TestExpressionInterpreter.toRowExpression(translatedExpression);
        Object expressionResult = TestExpressionInterpreter.optimize(translatedExpression);
        if (expressionResult instanceof Expression) {
            expressionResult = TestExpressionInterpreter.toRowExpression((Expression)expressionResult);
        }
        Object rowExpressionResult = TestExpressionInterpreter.optimize(rowExpression, optimizationLevel);
        TestExpressionInterpreter.assertRowExpressionEvaluationEquals(expressionResult, rowExpressionResult);
        TestExpressionInterpreter.assertRowExpressionEvaluationEquals(rowExpressionResult, rowExpression);
    }

    private static Object symbolConstant(Symbol symbol) {
        switch (symbol.getName().toLowerCase(Locale.ENGLISH)) {
            case "bound_integer": {
                return 1234L;
            }
            case "bound_long": {
                return 1234L;
            }
            case "bound_string": {
                return Slices.utf8Slice((String)"hello");
            }
            case "bound_double": {
                return 12.34;
            }
            case "bound_date": {
                return new LocalDate(2001, 8, 22).toDateMidnight(DateTimeZone.UTC).getMillis();
            }
            case "bound_time": {
                return new LocalTime(3, 4, 5, 321).toDateTime((ReadableInstant)new DateTime(0L, DateTimeZone.UTC)).getMillis();
            }
            case "bound_timestamp": {
                return new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis();
            }
            case "bound_pattern": {
                return Slices.utf8Slice((String)"%el%");
            }
            case "bound_timestamp_with_timezone": {
                return new SqlTimestampWithTimeZone(new DateTime(1970, 1, 1, 1, 0, 0, 999, DateTimeZone.UTC).getMillis(), TimeZoneKey.getTimeZoneKey((String)"Z"));
            }
            case "bound_varbinary": {
                return Slices.wrappedBuffer((byte[])new byte[]{-85});
            }
            case "bound_decimal_short": {
                return 12345L;
            }
            case "bound_decimal_long": {
                return Decimals.encodeUnscaledValue((BigInteger)new BigInteger("12345678901234567890123"));
            }
        }
        return null;
    }

    private static void assertExpressionAndRowExpressionEquals(Object expressionResult, Object rowExpressionResult) {
        if (rowExpressionResult instanceof RowExpression) {
            Assert.assertTrue((boolean)(expressionResult instanceof Expression));
            RowExpression translated = TRANSLATOR.translateAndOptimize((Expression)expressionResult, SYMBOL_TYPES);
            TestExpressionInterpreter.assertRowExpressionEvaluationEquals(translated, rowExpressionResult);
        } else {
            TestExpressionInterpreter.assertRowExpressionEvaluationEquals(expressionResult, rowExpressionResult);
        }
    }

    private static void assertRowExpressionEvaluationEquals(Object left, Object right) {
        if (right instanceof RowExpression) {
            Assert.assertTrue((boolean)(left instanceof RowExpression));
            if (left instanceof ConstantExpression) {
                if (TestExpressionInterpreter.isRemovableCast(right)) {
                    TestExpressionInterpreter.assertRowExpressionEvaluationEquals(left, ((CallExpression)right).getArguments().get(0));
                    return;
                }
                Assert.assertTrue((boolean)(right instanceof ConstantExpression));
                TestExpressionInterpreter.assertRowExpressionEvaluationEquals(((ConstantExpression)left).getValue(), ((ConstantExpression)left).getValue());
            } else if (left instanceof InputReferenceExpression || left instanceof VariableReferenceExpression) {
                Assert.assertEquals((Object)left, (Object)right);
            } else if (left instanceof CallExpression) {
                Assert.assertTrue((boolean)(right instanceof CallExpression));
                Assert.assertEquals((Object)((CallExpression)left).getFunctionHandle(), (Object)((CallExpression)right).getFunctionHandle());
                Assert.assertEquals((int)((CallExpression)left).getArguments().size(), (int)((CallExpression)right).getArguments().size());
                for (int i = 0; i < ((CallExpression)left).getArguments().size(); ++i) {
                    TestExpressionInterpreter.assertRowExpressionEvaluationEquals(((CallExpression)left).getArguments().get(i), ((CallExpression)right).getArguments().get(i));
                }
            } else if (left instanceof SpecialFormExpression) {
                Assert.assertTrue((boolean)(right instanceof SpecialFormExpression));
                Assert.assertEquals((Object)((SpecialFormExpression)left).getForm(), (Object)((SpecialFormExpression)right).getForm());
                Assert.assertEquals((int)((SpecialFormExpression)left).getArguments().size(), (int)((SpecialFormExpression)right).getArguments().size());
                for (int i = 0; i < ((SpecialFormExpression)left).getArguments().size(); ++i) {
                    TestExpressionInterpreter.assertRowExpressionEvaluationEquals(((SpecialFormExpression)left).getArguments().get(i), ((SpecialFormExpression)right).getArguments().get(i));
                }
            } else {
                Assert.assertTrue((boolean)(left instanceof LambdaDefinitionExpression));
                Assert.assertTrue((boolean)(right instanceof LambdaDefinitionExpression));
                Assert.assertEquals((Collection)((LambdaDefinitionExpression)left).getArguments(), (Collection)((LambdaDefinitionExpression)right).getArguments());
                Assert.assertEquals((Collection)((LambdaDefinitionExpression)left).getArgumentTypes(), (Collection)((LambdaDefinitionExpression)right).getArgumentTypes());
                TestExpressionInterpreter.assertRowExpressionEvaluationEquals(((LambdaDefinitionExpression)left).getBody(), ((LambdaDefinitionExpression)right).getBody());
            }
        } else if (left instanceof Block) {
            Assert.assertTrue((boolean)(right instanceof Block));
            Assert.assertEquals((Object)TestExpressionInterpreter.blockToSlice((Block)left), (Object)TestExpressionInterpreter.blockToSlice((Block)right));
        } else {
            Assert.assertEquals((Object)left, (Object)right);
        }
    }

    private static boolean isRemovableCast(Object value) {
        if (value instanceof CallExpression && new FunctionResolution(METADATA.getFunctionAndTypeManager().getFunctionAndTypeResolver()).isCastFunction(((CallExpression)value).getFunctionHandle())) {
            Type targetType = ((CallExpression)value).getType();
            Type sourceType = ((RowExpression)((CallExpression)value).getArguments().get(0)).getType();
            return METADATA.getFunctionAndTypeManager().canCoerce(sourceType, targetType);
        }
        return false;
    }

    private static Slice blockToSlice(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)blockEncodingSerde, (SliceOutput)sliceOutput, (Block)block);
        return sliceOutput.slice();
    }

    private static void assertEvaluatedEquals(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        Assert.assertEquals((Object)TestExpressionInterpreter.evaluate(actual, true), (Object)TestExpressionInterpreter.evaluate(expected, true));
    }

    private static Object evaluate(String expression, boolean deterministic) {
        TestExpressionInterpreter.assertRoundTrip(expression);
        Expression parsedExpression = FunctionAssertions.createExpression(expression, METADATA, SYMBOL_TYPES);
        return TestExpressionInterpreter.evaluate(parsedExpression, deterministic);
    }

    private static void assertRoundTrip(String expression) {
        ParsingOptions parsingOptions = AnalyzerUtil.createParsingOptions((Session)SessionTestUtils.TEST_SESSION);
        Assert.assertEquals((Object)SQL_PARSER.createExpression(expression, parsingOptions), (Object)SQL_PARSER.createExpression(ExpressionFormatter.formatExpression((Expression)SQL_PARSER.createExpression(expression, parsingOptions), Optional.empty()), parsingOptions));
    }

    private static Object evaluate(Expression expression, boolean deterministic) {
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)SessionTestUtils.TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, (TypeProvider)SYMBOL_TYPES, (Expression)expression, Collections.emptyMap(), (WarningCollector)WarningCollector.NOOP);
        Object expressionResult = ExpressionInterpreter.expressionInterpreter((Expression)expression, (Metadata)METADATA, (Session)SessionTestUtils.TEST_SESSION, (Map)expressionTypes).evaluate();
        Object rowExpressionResult = RowExpressionInterpreter.rowExpressionInterpreter((RowExpression)TRANSLATOR.translateAndOptimize(expression), (FunctionAndTypeManager)METADATA.getFunctionAndTypeManager(), (ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession()).evaluate();
        if (deterministic) {
            TestExpressionInterpreter.assertExpressionAndRowExpressionEquals(expressionResult, rowExpressionResult);
        }
        return expressionResult;
    }

    private static class FailedFunctionRewriter
    extends ExpressionRewriter<Object> {
        private FailedFunctionRewriter() {
        }

        public Expression rewriteFunctionCall(FunctionCall node, Object context, ExpressionTreeRewriter<Object> treeRewriter) {
            if (node.getName().equals((Object)QualifiedName.of((String)"fail"))) {
                return new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of(node.getArguments().get(0), (Object)new StringLiteral("ignored failure message")));
            }
            return node;
        }
    }
}

