/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.sql.analyzer.JavaFeaturesConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestJavaFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JavaFeaturesConfig)ConfigAssertions.recordDefaults(JavaFeaturesConfig.class)).setAggregationSpillEnabled(true).setDistinctAggregationSpillEnabled(true).setDedupBasedDistinctAggregationSpillEnabled(false).setDistinctAggregationLargeBlockSpillEnabled(false).setDistinctAggregationLargeBlockSizeThreshold(DataSize.valueOf((String)"50MB")).setOrderByAggregationSpillEnabled(true).setWindowSpillEnabled(true).setOrderBySpillEnabled(true).setTopNSpillEnabled(true).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setTopNOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"experimental.aggregation-spill-enabled", (Object)"false").put((Object)"experimental.distinct-aggregation-spill-enabled", (Object)"false").put((Object)"experimental.dedup-based-distinct-aggregation-spill-enabled", (Object)"true").put((Object)"experimental.distinct-aggregation-large-block-spill-enabled", (Object)"true").put((Object)"experimental.distinct-aggregation-large-block-size-threshold", (Object)"10MB").put((Object)"experimental.order-by-aggregation-spill-enabled", (Object)"false").put((Object)"experimental.window-spill-enabled", (Object)"false").put((Object)"experimental.order-by-spill-enabled", (Object)"false").put((Object)"experimental.topn-spill-enabled", (Object)"false").put((Object)"experimental.aggregation-operator-unspill-memory-limit", (Object)"100MB").put((Object)"experimental.topn-operator-unspill-memory-limit", (Object)"100MB").build();
        JavaFeaturesConfig expected = new JavaFeaturesConfig().setAggregationSpillEnabled(false).setDistinctAggregationSpillEnabled(false).setDedupBasedDistinctAggregationSpillEnabled(true).setDistinctAggregationLargeBlockSpillEnabled(true).setDistinctAggregationLargeBlockSizeThreshold(DataSize.valueOf((String)"10MB")).setOrderByAggregationSpillEnabled(false).setWindowSpillEnabled(false).setOrderBySpillEnabled(false).setTopNSpillEnabled(false).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setTopNOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB"));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

