/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.log.Logging;
import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.BitwiseFunctions;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.operator.scalar.JoniRegexpCasts;
import com.facebook.presto.operator.scalar.JoniRegexpFunctions;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.JsonPath;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.joni.Regex;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestExpressionCompiler {
    private static final Boolean[] booleanValues = new Boolean[]{true, false, null};
    private static final Integer[] smallInts = new Integer[]{9, 10, 11, -9, -10, -11, null};
    private static final Integer[] extremeInts = new Integer[]{101510, Integer.MAX_VALUE};
    private static final Integer[] intLefts = (Integer[])ObjectArrays.concat((Object[])smallInts, (Object[])extremeInts, Integer.class);
    private static final Integer[] intRights = new Integer[]{3, -3, 101510823, null};
    private static final Integer[] intMiddle = new Integer[]{9, -3, 88, null};
    private static final Double[] doubleLefts = new Double[]{9.0, 10.0, 11.0, -9.0, -10.0, -11.0, 9.1, 10.1, 11.1, -9.1, -10.1, -11.1, Double.MIN_VALUE, Double.MAX_VALUE, Double.MIN_NORMAL, null};
    private static final Double[] doubleRights = new Double[]{3.0, -3.0, 3.1, -3.1, null};
    private static final Double[] doubleMiddle = new Double[]{9.0, -3.1, 88.0, null};
    private static final String[] stringLefts = new String[]{"hello", "foo", "mellow", "fellow", "", null};
    private static final String[] stringRights = new String[]{"hello", "foo", "bar", "baz", "", null};
    private static final Long[] longLefts = new Long[]{9L, 10L, 11L, -9L, -10L, -11L, null};
    private static final Long[] longRights = new Long[]{3L, -3L, 10151082135029369L, null};
    private static final BigDecimal[] decimalLefts = new BigDecimal[]{new BigDecimal("9.0"), new BigDecimal("10.0"), new BigDecimal("11.0"), new BigDecimal("-9.0"), new BigDecimal("-10.0"), new BigDecimal("-11.0"), new BigDecimal("9.1"), new BigDecimal("10.1"), new BigDecimal("11.1"), new BigDecimal("-9.1"), new BigDecimal("-10.1"), new BigDecimal("-11.1"), new BigDecimal("9223372036.5477"), new BigDecimal("-9223372036.5477"), null};
    private static final BigDecimal[] decimalRights = new BigDecimal[]{new BigDecimal("3.0"), new BigDecimal("-3.0"), new BigDecimal("3.1"), new BigDecimal("-3.1"), null};
    private static final BigDecimal[] decimalMiddle = new BigDecimal[]{new BigDecimal("9.0"), new BigDecimal("-3.1"), new BigDecimal("88.0"), null};
    private static final DateTime[] dateTimeValues = new DateTime[]{new DateTime(2001, 1, 22, 3, 4, 5, 321, DateTimeZone.UTC), new DateTime(1960, 1, 22, 3, 4, 5, 321, DateTimeZone.UTC), new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC), null};
    private static final String[] jsonValues = new String[]{"{}", "{\"fuu\": {\"bar\": 1}}", "{\"fuu\": null}", "{\"fuu\": 1}", "{\"fuu\": 1, \"bar\": \"abc\"}", null};
    private static final String[] jsonPatterns = new String[]{"$", "$.fuu", "$.fuu[0]", "$.bar", null};
    private static final Logger log = Logger.get(TestExpressionCompiler.class);
    private static final boolean PARALLEL = false;
    private long start;
    private ListeningExecutorService executor;
    private FunctionAssertions functionAssertions;
    private List<ListenableFuture<?>> futures;

    @BeforeClass
    public void setupClass() {
        Logging.initialize();
        this.executor = MoreExecutors.newDirectExecutorService();
        this.functionAssertions = this.setFunctionAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.functionAssertions});
        this.functionAssertions = null;
    }

    @BeforeMethod
    public void setUp() {
        this.start = System.nanoTime();
        this.futures = new ArrayList();
    }

    @AfterMethod
    public void tearDown(Method method) {
        Assert.assertTrue((boolean)Futures.allAsList(this.futures).isDone(), (String)"Expression test futures are not complete");
        log.info("FINISHED %s in %s verified %s expressions", new Object[]{method.getName(), Duration.nanosSince((long)this.start), this.futures.size()});
    }

    public FunctionAssertions setFunctionAssertions() {
        return new FunctionAssertions();
    }

    @Test
    public void smokedTest() throws Exception {
        this.assertExecute("cast(true as boolean)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("true", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("false", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("42", (Type)IntegerType.INTEGER, (Object)42);
        this.assertExecute("'foo'", (Type)VarcharType.createVarcharType((int)3), (Object)"foo");
        this.assertExecute("4.2E0", (Type)DoubleType.DOUBLE, (Object)4.2);
        this.assertExecute("10000000000 + 1", (Type)BigintType.BIGINT, (Object)10000000001L);
        this.assertExecute("4.2", (Type)DecimalType.createDecimalType((int)2, (int)1), (Object)new SqlDecimal(BigInteger.valueOf(42L), 2, 1));
        this.assertExecute("DECIMAL '4.2'", (Type)DecimalType.createDecimalType((int)2, (int)1), (Object)new SqlDecimal(BigInteger.valueOf(42L), 2, 1));
        this.assertExecute("X' 1 f'", (Type)VarbinaryType.VARBINARY, (Object)new SqlVarbinary(Slices.wrappedBuffer((byte[])new byte[]{31}).getBytes()));
        this.assertExecute("X' '", (Type)VarbinaryType.VARBINARY, (Object)new SqlVarbinary(new byte[0]));
        this.assertExecute("bound_integer", (Type)IntegerType.INTEGER, (Object)1234);
        this.assertExecute("bound_long", (Type)BigintType.BIGINT, (Object)1234L);
        this.assertExecute("bound_string", (Type)VarcharType.VARCHAR, (Object)"hello");
        this.assertExecute("bound_double", (Type)DoubleType.DOUBLE, (Object)12.34);
        this.assertExecute("bound_boolean", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("bound_timestamp", (Type)BigintType.BIGINT, (Object)new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis());
        this.assertExecute("bound_pattern", (Type)VarcharType.VARCHAR, (Object)"%el%");
        this.assertExecute("bound_null_string", (Type)VarcharType.VARCHAR, null);
        this.assertExecute("bound_timestamp_with_timezone", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)new SqlTimestampWithTimeZone(new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), TimeZoneKey.getTimeZoneKey((String)"Z")));
        this.assertExecute("bound_binary_literal", (Type)VarbinaryType.VARBINARY, (Object)new SqlVarbinary(new byte[]{-85}));
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void filterFunction() throws Exception {
        this.assertFilter("true", true);
        this.assertFilter("false", false);
        this.assertFilter("bound_integer = 1234", true);
        this.assertFilter("bound_integer = BIGINT '1234'", true);
        this.assertFilter("bound_long = 1234", true);
        this.assertFilter("bound_long = BIGINT '1234'", true);
        this.assertFilter("bound_long = 5678", false);
        this.assertFilter("bound_null_string is null", true);
        this.assertFilter("bound_null_string = 'foo'", false);
        this.assertFilter("cast(null as boolean)", false);
        this.assertFilter("nullif(true, true)", false);
        this.assertFilter("true AND cast(null as boolean) AND true", false);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testUnaryOperators() throws Exception {
        this.assertExecute("cast(null as boolean) is null", (Type)BooleanType.BOOLEAN, (Object)true);
        for (Boolean bl : booleanValues) {
            this.assertExecute(this.generateExpression("%s", bl), (Type)BooleanType.BOOLEAN, (Object)(bl == null ? null : bl));
            this.assertExecute(this.generateExpression("%s is null", bl), (Type)BooleanType.BOOLEAN, (Object)(bl == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", bl), (Type)BooleanType.BOOLEAN, (Object)(bl != null ? 1 : 0));
        }
        for (Comparable<Boolean> comparable : intLefts) {
            Long longValue = comparable == null ? null : Long.valueOf((long)((Integer)comparable).intValue() * 10000000000L);
            this.assertExecute(this.generateExpression("%s", (Integer)comparable), (Type)IntegerType.INTEGER, comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("- (%s)", (Integer)comparable), (Type)IntegerType.INTEGER, comparable == null ? null : Integer.valueOf(-((Integer)comparable).intValue()));
            this.assertExecute(this.generateExpression("%s", longValue), (Type)BigintType.BIGINT, (Object)(comparable == null ? null : longValue));
            this.assertExecute(this.generateExpression("- (%s)", longValue), (Type)BigintType.BIGINT, comparable == null ? null : Long.valueOf(-longValue.longValue()));
            this.assertExecute(this.generateExpression("%s is null", (Integer)comparable), (Type)BooleanType.BOOLEAN, (Object)(comparable == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", (Integer)comparable), (Type)BooleanType.BOOLEAN, (Object)(comparable != null ? 1 : 0));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            this.assertExecute(this.generateExpression("%s", (Double)comparable), (Type)DoubleType.DOUBLE, comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("- (%s)", (Double)comparable), (Type)DoubleType.DOUBLE, comparable == null ? null : Double.valueOf(-((Double)comparable).doubleValue()));
            this.assertExecute(this.generateExpression("%s is null", (Double)comparable), (Type)BooleanType.BOOLEAN, (Object)(comparable == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", (Double)comparable), (Type)BooleanType.BOOLEAN, (Object)(comparable != null ? 1 : 0));
        }
        for (Comparable<Boolean> comparable : decimalLefts) {
            this.assertExecute(this.generateExpression("%s", (BigDecimal)comparable), (BigDecimal)(comparable == null ? null : comparable));
            this.assertExecute(this.generateExpression("- (%s)", (BigDecimal)comparable), comparable == null ? null : ((BigDecimal)comparable).negate());
            this.assertExecute(this.generateExpression("%s is null", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, (Object)(comparable == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, (Object)(comparable != null ? 1 : 0));
        }
        for (String string : stringLefts) {
            this.assertExecute(this.generateExpression("%s", string), (Type)TestExpressionCompiler.varcharType(string), (Object)(string == null ? null : string));
            this.assertExecute(this.generateExpression("%s is null", string), (Type)BooleanType.BOOLEAN, (Object)(string == null ? 1 : 0));
            this.assertExecute(this.generateExpression("%s is not null", string), (Type)BooleanType.BOOLEAN, (Object)(string != null ? 1 : 0));
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFilterEmptyInput() throws Exception {
        this.assertFilterWithNoInputColumns("true", true);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsBoolean() throws Exception {
        this.assertExecute("nullif(cast(null as boolean), true)", (Type)BooleanType.BOOLEAN, null);
        for (Boolean left : booleanValues) {
            for (Boolean right : booleanValues) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left == right));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left != right));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)BooleanType.BOOLEAN, TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right) ? 1 : 0));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsIntegralIntegral() throws Exception {
        for (Integer left : smallInts) {
            for (Integer right : intRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((long)left.intValue() == (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((long)left.intValue() != (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((long)left.intValue() > (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((long)left.intValue() < (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((long)left.intValue() >= (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((long)left.intValue() <= (long)right.intValue()));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)IntegerType.INTEGER, TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), (Type)IntegerType.INTEGER, left == null || right == null ? null : Integer.valueOf(left + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), (Type)IntegerType.INTEGER, left == null || right == null ? null : Integer.valueOf(left - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), (Type)IntegerType.INTEGER, left == null || right == null ? null : Integer.valueOf(left * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), (Type)IntegerType.INTEGER, left == null || right == null ? null : Integer.valueOf(left / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), (Type)IntegerType.INTEGER, left == null || right == null ? null : Integer.valueOf(left % right));
                Long longLeft = left == null ? null : Long.valueOf((long)left.intValue() * 1000000000L);
                this.assertExecute(this.generateExpression("%s + %s", longLeft, right), (Type)BigintType.BIGINT, longLeft == null || right == null ? null : Long.valueOf(longLeft + (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s - %s", longLeft, right), (Type)BigintType.BIGINT, longLeft == null || right == null ? null : Long.valueOf(longLeft - (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s * %s", longLeft, right), (Type)BigintType.BIGINT, longLeft == null || right == null ? null : Long.valueOf(longLeft * (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s / %s", longLeft, right), (Type)BigintType.BIGINT, longLeft == null || right == null ? null : Long.valueOf(longLeft / (long)right.intValue()));
                this.assertExecute(this.generateExpression("%s %% %s", longLeft, right), (Type)BigintType.BIGINT, longLeft == null || right == null ? null : Long.valueOf(longLeft % (long)right.intValue()));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsIntegralDouble() throws Exception {
        for (Integer left : intLefts) {
            for (Double right : doubleRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((double)left.intValue() == right));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((double)left.intValue() != right));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((double)left.intValue() > right));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((double)left.intValue() < right));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((double)left.intValue() >= right));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf((double)left.intValue() <= right));
                Object expectedNullIf = TestExpressionCompiler.nullIf(left, right);
                for (String expression : this.generateExpression("nullif(%s, CAST(%s as DOUBLE))", left, right)) {
                    this.functionAssertions.assertFunction(expression, (Type)IntegerType.INTEGER, expectedNullIf);
                }
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left == null ? null : Double.valueOf(left.doubleValue()), right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf((double)left.intValue() + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf((double)left.intValue() - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf((double)left.intValue() * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf((double)left.intValue() / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf((double)left.intValue() % right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDoubleIntegral() throws Exception {
        for (Double left : doubleLefts) {
            for (Integer right : intRights) {
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left == (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left != (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left > (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left < (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left >= (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left <= (double)right.intValue()));
                this.assertExecute(this.generateExpression("nullif(CAST(%s as DOUBLE), %s)", left, right), (Type)DoubleType.DOUBLE, TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right == null ? null : Double.valueOf(right.doubleValue())) ? 1 : 0));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) + %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left + (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) - %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left - (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) * %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left * (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) / %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left / (double)right.intValue()));
                this.assertExecute(this.generateExpression("CAST(%s as DOUBLE) %% %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left % (double)right.intValue()));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDoubleDouble() throws Exception {
        for (Double left : doubleLefts) {
            for (Double right : doubleRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left > right));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left < right));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left >= right));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left <= right));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)DoubleType.DOUBLE, TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left % right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDecimalBigint() throws Exception {
        for (BigDecimal left : decimalLefts) {
            for (Long right : longRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.equals(new BigDecimal(right))));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(!left.equals(new BigDecimal(right))));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) > 0));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) < 0));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) >= 0));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) <= 0));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (BigDecimal)BigDecimal.class.cast(TestExpressionCompiler.nullIf(left, right)));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right == null ? null : new BigDecimal(right)) ? 1 : 0));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsBigintDecimal() throws Exception {
        for (Long left : longLefts) {
            for (BigDecimal right : decimalRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).equals(right)));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(!new BigDecimal(left).equals(right)));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) > 0));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) < 0));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) >= 0));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) <= 0));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)BigintType.BIGINT, (Object)left);
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left == null ? null : new BigDecimal(left), right) ? 1 : 0));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDecimalInteger() throws Exception {
        for (BigDecimal left : decimalLefts) {
            for (Integer right : intRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.equals(new BigDecimal(right))));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(!left.equals(new BigDecimal(right))));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) > 0));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) < 0));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) >= 0));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) <= 0));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (BigDecimal)BigDecimal.class.cast(TestExpressionCompiler.nullIf(left, right)));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right == null ? null : new BigDecimal(right)) ? 1 : 0));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsIntegerDecimal() throws Exception {
        for (Integer left : intLefts) {
            for (BigDecimal right : decimalRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).equals(right)));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(!new BigDecimal(left).equals(right)));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) > 0));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) < 0));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) >= 0));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) <= 0));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)IntegerType.INTEGER, (Object)left);
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left == null ? null : new BigDecimal(left), right) ? 1 : 0));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDecimalDouble() throws Exception {
        for (BigDecimal left : decimalLefts) {
            for (Double right : doubleRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() > right));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() < right));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() >= right));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() <= right));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (BigDecimal)BigDecimal.class.cast(TestExpressionCompiler.nullIf(left, right)));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left == null ? null : Double.valueOf(left.doubleValue()), right) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left.doubleValue() + right));
                this.assertExecute(this.generateExpression("%s - %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left.doubleValue() - right));
                this.assertExecute(this.generateExpression("%s * %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left.doubleValue() * right));
                this.assertExecute(this.generateExpression("%s / %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left.doubleValue() / right));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left.doubleValue() % right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsDoubleDecimal() throws Exception {
        for (Double left : doubleLefts) {
            for (BigDecimal right : decimalRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left > right.doubleValue()));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left < right.doubleValue()));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left >= right.doubleValue()));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left <= right.doubleValue()));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)DoubleType.DOUBLE, TestExpressionCompiler.nullIf(left, right));
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right == null ? null : Double.valueOf(right.doubleValue())) ? 1 : 0));
                this.assertExecute(this.generateExpression("%s + %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left + right.doubleValue()));
                this.assertExecute(this.generateExpression("%s - %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left - right.doubleValue()));
                this.assertExecute(this.generateExpression("%s * %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left * right.doubleValue()));
                this.assertExecute(this.generateExpression("%s / %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left / right.doubleValue()));
                this.assertExecute(this.generateExpression("%s %% %s", left, right), (Type)DoubleType.DOUBLE, left == null || right == null ? null : Double.valueOf(left % right.doubleValue()));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testBinaryOperatorsString() throws Exception {
        for (String left : stringLefts) {
            for (String right : stringRights) {
                this.assertExecute(this.generateExpression("%s = %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.equals(right)));
                this.assertExecute(this.generateExpression("%s <> %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(!left.equals(right)));
                this.assertExecute(this.generateExpression("%s > %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) > 0));
                this.assertExecute(this.generateExpression("%s < %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) < 0));
                this.assertExecute(this.generateExpression("%s >= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) >= 0));
                this.assertExecute(this.generateExpression("%s <= %s", left, right), (Type)BooleanType.BOOLEAN, left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) <= 0));
                this.assertExecute(this.generateExpression("%s || %s", left, right), (Type)VarcharType.VARCHAR, left == null || right == null ? null : left + right);
                this.assertExecute(this.generateExpression("%s is distinct from %s", left, right), (Type)BooleanType.BOOLEAN, (Object)(!Objects.equals(left, right) ? 1 : 0));
                this.assertExecute(this.generateExpression("nullif(%s, %s)", left, right), (Type)TestExpressionCompiler.varcharType(left), TestExpressionCompiler.nullIf(left, right));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testNestedColumnFilter() {
        this.assertFilter("bound_row.nested_column_0 = 1234", true);
        this.assertFilter("bound_row.nested_column_0 = 1223", false);
        this.assertFilter("bound_row.nested_column_1 = 34", true);
        this.assertFilter("bound_row.nested_column_1 = 33", false);
        this.assertFilter("bound_row.nested_column_2 = 'hello'", true);
        this.assertFilter("bound_row.nested_column_2 = 'value1'", false);
        this.assertFilter("bound_row.nested_column_3 = 12.34", true);
        this.assertFilter("bound_row.nested_column_3 = 34.34", false);
        this.assertFilter("bound_row.nested_column_4 = true", true);
        this.assertFilter("bound_row.nested_column_4 = false", false);
        this.assertFilter("bound_row.nested_column_6.nested_nested_column = 'innerFieldValue'", true);
        this.assertFilter("bound_row.nested_column_6.nested_nested_column != 'innerFieldValue'", false);
        this.assertFilter(ImmutableList.of((Object)"bound_row.nested_column_0 = 1234", (Object)"bound_row.nested_column_7 >= 1234", (Object)"bound_row.nested_column_1 = 34", (Object)"bound_row.nested_column_8 >= 33", (Object)"bound_row.nested_column_2 = 'hello'", (Object)"bound_row.nested_column_9 >= 'hello'", (Object)"bound_row.nested_column_3 = 12.34", (Object)"bound_row.nested_column_10 >= 12.34", (Object)"bound_row.nested_column_4 = true", (Object)"NOT (bound_row.nested_column_11 = false)", (Object)"bound_row.nested_column_6.nested_nested_column = 'innerFieldValue'", (Object)"bound_row.nested_column_13.nested_nested_column LIKE 'innerFieldValue'", (Object[])new String[0]).stream().collect(Collectors.joining(" AND ")), true);
    }

    private static VarcharType varcharType(String ... values) {
        return TestExpressionCompiler.varcharType(Arrays.asList(values));
    }

    private static VarcharType varcharType(List<String> values) {
        if (values.stream().anyMatch(Objects::isNull)) {
            return VarcharType.VARCHAR;
        }
        return VarcharType.createVarcharType((int)values.stream().mapToInt(String::length).max().getAsInt());
    }

    private static Object nullIf(Object left, Object right) {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return left;
        }
        if (left.equals(right)) {
            return null;
        }
        if ((left instanceof Double || right instanceof Double) && ((Number)left).doubleValue() == ((Number)right).doubleValue()) {
            return null;
        }
        return left;
    }

    @Test
    public void testTernaryOperatorsLongLong() throws Exception {
        for (Integer first : intLefts) {
            for (Integer second : intLefts) {
                for (Integer third : intRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), (Type)BooleanType.BOOLEAN, first == null || second == null || third == null ? null : Boolean.valueOf(second <= first && first <= third));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsLongDouble() throws Exception {
        for (Integer first : intLefts) {
            for (Double second : doubleLefts) {
                for (Integer third : intRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), (Type)BooleanType.BOOLEAN, first == null || second == null || third == null ? null : Boolean.valueOf(second <= (double)first.intValue() && first <= third));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsDoubleDouble() throws Exception {
        for (Double first : doubleLefts) {
            for (Double second : doubleLefts) {
                for (Integer third : intRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), (Type)BooleanType.BOOLEAN, first == null || second == null || third == null ? null : Boolean.valueOf(second <= first && first <= (double)third.intValue()));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsString() throws Exception {
        for (String first : stringLefts) {
            for (String second : stringLefts) {
                for (String third : stringRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), (Type)BooleanType.BOOLEAN, first == null || second == null || third == null ? null : Boolean.valueOf(second.compareTo(first) <= 0 && first.compareTo(third) <= 0));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsLongDecimal() throws Exception {
        for (Long first : longLefts) {
            for (BigDecimal second : decimalMiddle) {
                for (Long third : longRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), (Type)BooleanType.BOOLEAN, first == null || second == null || third == null ? null : Boolean.valueOf(second.compareTo(new BigDecimal(first)) <= 0 && first <= third));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTernaryOperatorsDecimalDouble() throws Exception {
        for (BigDecimal first : decimalLefts) {
            for (Double second : doubleMiddle) {
                for (BigDecimal third : decimalRights) {
                    this.assertExecute(this.generateExpression("%s between %s and %s", first, second, third), (Type)BooleanType.BOOLEAN, first == null || second == null || third == null ? null : Boolean.valueOf(second <= first.doubleValue() && first.compareTo(third) <= 0));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testCast() throws Exception {
        for (Boolean bl : booleanValues) {
            this.assertExecute(this.generateExpression("cast(%s as boolean)", bl), (Type)BooleanType.BOOLEAN, bl == null ? null : Boolean.valueOf(bl != false));
            this.assertExecute(this.generateExpression("cast(%s as integer)", bl), (Type)IntegerType.INTEGER, bl == null ? null : Integer.valueOf(bl != false ? 1 : 0));
            this.assertExecute(this.generateExpression("cast(%s as bigint)", bl), (Type)BigintType.BIGINT, bl == null ? null : Long.valueOf(bl != false ? 1L : 0L));
            this.assertExecute(this.generateExpression("cast(%s as double)", bl), (Type)DoubleType.DOUBLE, bl == null ? null : Double.valueOf(bl != false ? 1.0 : 0.0));
            this.assertExecute(this.generateExpression("cast(%s as varchar)", bl), (Type)VarcharType.VARCHAR, bl == null ? null : (bl != false ? "true" : "false"));
        }
        for (Comparable<Boolean> comparable : intLefts) {
            this.assertExecute(this.generateExpression("cast(%s as boolean)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf((long)((Integer)comparable).intValue() != 0L));
            this.assertExecute(this.generateExpression("cast(%s as integer)", (Integer)comparable), (Type)IntegerType.INTEGER, comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("cast(%s as bigint)", (Integer)comparable), (Type)BigintType.BIGINT, comparable == null ? null : Long.valueOf(((Integer)comparable).intValue()));
            this.assertExecute(this.generateExpression("cast(%s as double)", (Integer)comparable), (Type)DoubleType.DOUBLE, comparable == null ? null : Double.valueOf(((Integer)comparable).doubleValue()));
            this.assertExecute(this.generateExpression("cast(%s as varchar)", (Integer)comparable), (Type)VarcharType.VARCHAR, (Object)(comparable == null ? null : String.valueOf(comparable)));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            this.assertExecute(this.generateExpression("cast(%s as boolean)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf((Double)comparable != 0.0));
            if (comparable == null || (Double)comparable >= -9.223372036854776E18 && (Double)comparable < 9.223372036854776E18) {
                this.assertExecute(this.generateExpression("cast(%s as bigint)", (Double)comparable), (Type)BigintType.BIGINT, comparable == null ? null : Long.valueOf(((Double)comparable).longValue()));
            }
            this.assertExecute(this.generateExpression("cast(%s as double)", (Double)comparable), (Type)DoubleType.DOUBLE, comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("cast(%s as varchar)", (Double)comparable), (Type)VarcharType.VARCHAR, (Object)(comparable == null ? null : String.valueOf(comparable)));
        }
        this.assertExecute("cast('true' as boolean)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast('true' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast('tRuE' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast('false' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("cast('fAlSe' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("cast('t' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast('T' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast('f' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("cast('F' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("cast('1' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast('0' as BOOLEAN)", (Type)BooleanType.BOOLEAN, (Object)false);
        for (Comparable<Boolean> comparable : intLefts) {
            if (comparable == null) continue;
            this.assertExecute(this.generateExpression("cast(%s as integer)", String.valueOf(comparable)), (Type)IntegerType.INTEGER, comparable == null ? null : comparable);
            this.assertExecute(this.generateExpression("cast(%s as bigint)", String.valueOf(comparable)), (Type)BigintType.BIGINT, comparable == null ? null : Long.valueOf(((Integer)comparable).intValue()));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            if (comparable == null) continue;
            this.assertExecute(this.generateExpression("cast(%s as double)", String.valueOf(comparable)), (Type)DoubleType.DOUBLE, comparable == null ? null : comparable);
        }
        for (String string : stringLefts) {
            this.assertExecute(this.generateExpression("cast(%s as varchar)", string), (Type)VarcharType.VARCHAR, (Object)(string == null ? null : string));
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testTryCast() throws Exception {
        this.assertExecute("try_cast(null as integer)", (Type)IntegerType.INTEGER, null);
        this.assertExecute("try_cast('123' as integer)", (Type)IntegerType.INTEGER, (Object)123);
        this.assertExecute("try_cast(null as bigint)", (Type)BigintType.BIGINT, null);
        this.assertExecute("try_cast('123' as bigint)", (Type)BigintType.BIGINT, (Object)123L);
        this.assertExecute("try_cast('foo' as varchar)", (Type)VarcharType.VARCHAR, (Object)"foo");
        this.assertExecute("try_cast('foo' as bigint)", (Type)BigintType.BIGINT, null);
        this.assertExecute("try_cast('foo' as integer)", (Type)IntegerType.INTEGER, null);
        this.assertExecute("try_cast('2001-08-22' as timestamp)", (Type)TimestampType.TIMESTAMP, (Object)DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)8, (int)22, (int)0, (int)0, (int)0, (int)0, (Session)SessionTestUtils.TEST_SESSION));
        this.assertExecute("try_cast(bound_string as bigint)", (Type)BigintType.BIGINT, null);
        this.assertExecute("try_cast(cast(null as varchar) as bigint)", (Type)BigintType.BIGINT, null);
        this.assertExecute("try_cast(bound_long / 13  as bigint)", (Type)BigintType.BIGINT, (Object)94L);
        this.assertExecute("coalesce(try_cast('123' as bigint), 456)", (Type)BigintType.BIGINT, (Object)123L);
        this.assertExecute("coalesce(try_cast('foo' as bigint), 456)", (Type)BigintType.BIGINT, (Object)456L);
        this.assertExecute("concat('foo', cast('bar' as varchar))", (Type)VarcharType.VARCHAR, (Object)"foobar");
        this.assertExecute("try_cast(try_cast(123 as varchar) as bigint)", (Type)BigintType.BIGINT, (Object)123L);
        this.assertExecute("try_cast('foo' as varchar) || try_cast('bar' as varchar)", (Type)VarcharType.VARCHAR, (Object)"foobar");
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testAnd() throws Exception {
        this.assertExecute("true and true", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("true and false", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("false and true", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("false and false", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("true and cast(null as boolean)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("false and cast(null as boolean)", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("cast(null as boolean) and true", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("cast(null as boolean) and false", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("cast(null as boolean) and cast(null as boolean)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("true and null", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("false and null", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("null and true", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("null and false", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("null and null", (Type)BooleanType.BOOLEAN, null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testOr() throws Exception {
        this.assertExecute("true or true", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("true or false", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("false or true", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("false or false", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("true or cast(null as boolean)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("false or cast(null as boolean)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("cast(null as boolean) or true", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("cast(null as boolean) or false", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("cast(null as boolean) or cast(null as boolean)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("true or null", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("false or null", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("null or true", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("null or false", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("null or null", (Type)BooleanType.BOOLEAN, null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testNot() throws Exception {
        this.assertExecute("not true", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("not false", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("not cast(null as boolean)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("not null", (Type)BooleanType.BOOLEAN, null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testIf() throws Exception {
        this.assertExecute("if(null and true, BIGINT '1', 0)", (Type)BigintType.BIGINT, (Object)0L);
        this.assertExecute("if(null and true, 1, 0)", (Type)IntegerType.INTEGER, (Object)0);
        for (Boolean condition : booleanValues) {
            for (String trueValue : stringLefts) {
                for (String falseValue : stringRights) {
                    this.assertExecute(this.generateExpression("if(%s, %s, %s)", condition, trueValue, falseValue), (Type)TestExpressionCompiler.varcharType(trueValue, falseValue), (Object)(condition != null && condition != false ? trueValue : falseValue));
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testSimpleCase() throws Exception {
        String expected;
        for (Double d : doubleLefts) {
            for (Double d2 : doubleMiddle) {
                for (Double d3 : doubleRights) {
                    expected = d == null ? "else" : (d2 != null && d.doubleValue() == d2.doubleValue() ? "first" : (d3 != null && d.doubleValue() == d3.doubleValue() ? "second" : "else"));
                    this.assertExecute(this.generateExpression("case %s when %s then 'first' when %s then 'second' else 'else' end", d, d2, d3), (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        for (Number number : intLefts) {
            for (Number number2 : intMiddle) {
                for (Number number3 : intRights) {
                    expected = number == null ? null : (number2 != null && ((Integer)number2).equals(number) ? "first" : (number3 != null && ((Integer)number3).equals(number) ? "second" : null));
                    this.assertExecute(this.generateExpression("case %s when %s then 'first' when %s then 'second' end", (Integer)number, (Integer)number2, (Integer)number3), (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        for (Number number : decimalLefts) {
            for (Number number4 : decimalMiddle) {
                for (Number number5 : decimalRights) {
                    expected = number == null ? null : (number4 != null && ((BigDecimal)number4).equals(number) ? "first" : (number5 != null && ((BigDecimal)number5).equals(number) ? "second" : null));
                    this.assertExecute(this.generateExpression("case %s when %s then 'first' when %s then 'second' end", (BigDecimal)number, (BigDecimal)number4, (BigDecimal)number5), (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        this.assertExecute("case ARRAY[CAST(1 AS BIGINT)] when ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", (Type)VarcharType.createVarcharType((int)11), (Object)"matched");
        this.assertExecute("case ARRAY[CAST(2 AS BIGINT)] when ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", (Type)VarcharType.createVarcharType((int)11), (Object)"not_matched");
        this.assertExecute("case ARRAY[CAST(null AS BIGINT)] when ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", (Type)VarcharType.createVarcharType((int)11), (Object)"not_matched");
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testSearchCaseSingle() throws Exception {
        List<String> expressions;
        String expected;
        for (Double value : doubleLefts) {
            for (Integer n : intLefts) {
                for (Double d : doubleRights) {
                    expected = value == null ? "else" : (n != null && value == (double)n.intValue() ? "first" : (d != null && value.doubleValue() == d.doubleValue() ? "second" : "else"));
                    expressions = TestExpressionCompiler.formatExpression("case when %s = %s then 'first' when %s = %s then 'second' else 'else' end", Arrays.asList(value, n, value, d), (List<String>)ImmutableList.of((Object)"double", (Object)"bigint", (Object)"double", (Object)"double"));
                    this.assertExecute(expressions, (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        for (Double value : doubleLefts) {
            for (Number number : longLefts) {
                for (Number number2 : decimalRights) {
                    expected = value == null ? "else" : (number != null && value == (double)((Long)number).longValue() ? "first" : (number2 != null && value.doubleValue() == ((BigDecimal)number2).doubleValue() ? "second" : "else"));
                    expressions = TestExpressionCompiler.formatExpression("case when %s = %s then 'first' when %s = %s then 'second' else 'else' end", Arrays.asList(value, number, value, number2), (List<String>)ImmutableList.of((Object)"double", (Object)"bigint", (Object)"double", (Object)"decimal(1,0)"));
                    this.assertExecute(expressions, (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        this.assertExecute("case when ARRAY[CAST(1 AS BIGINT)] = ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", (Type)VarcharType.createVarcharType((int)11), (Object)"matched");
        this.assertExecute("case when ARRAY[CAST(2 AS BIGINT)] = ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", (Type)VarcharType.createVarcharType((int)11), (Object)"not_matched");
        this.assertExecute("case when ARRAY[CAST(null AS BIGINT)] = ARRAY[CAST(1 AS BIGINT)] then 'matched' else 'not_matched' end", (Type)VarcharType.createVarcharType((int)11), (Object)"not_matched");
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testSearchCaseMultiple() throws Exception {
        List<String> expressions;
        String expected;
        for (Double d : doubleLefts) {
            for (Integer n : intLefts) {
                for (Double secondTest : doubleRights) {
                    expected = d == null ? null : (n != null && d == (double)n.intValue() ? "first" : (secondTest != null && d.doubleValue() == secondTest.doubleValue() ? "second" : null));
                    expressions = TestExpressionCompiler.formatExpression("case when %s = %s then 'first' when %s = %s then 'second' end", Arrays.asList(d, n, d, secondTest), (List<String>)ImmutableList.of((Object)"double", (Object)"bigint", (Object)"double", (Object)"double"));
                    this.assertExecute(expressions, (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        for (Number number : decimalLefts) {
            for (Number number2 : longLefts) {
                for (Double secondTest : doubleRights) {
                    expected = number == null ? null : (number2 != null && ((BigDecimal)number).doubleValue() == (double)((Long)number2).longValue() ? "first" : (secondTest != null && ((BigDecimal)number).doubleValue() == secondTest.doubleValue() ? "second" : null));
                    expressions = TestExpressionCompiler.formatExpression("case when %s = %s then 'first' when %s = %s then 'second' end", Arrays.asList(number, number2, number, secondTest), (List<String>)ImmutableList.of((Object)"decimal(14,4)", (Object)"bigint", (Object)"decimal(14,4)", (Object)"double"));
                    this.assertExecute(expressions, (Type)VarcharType.createVarcharType((int)6), (Object)expected);
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testIn() throws Exception {
        Object testValues;
        for (Boolean bl : booleanValues) {
            this.assertExecute(this.generateExpression("%s in (true)", bl), (Type)BooleanType.BOOLEAN, bl == null ? null : Boolean.valueOf(bl == Boolean.TRUE));
            this.assertExecute(this.generateExpression("%s in (null, true)", bl), (Type)BooleanType.BOOLEAN, bl == null ? null : (bl == Boolean.TRUE ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (true, null)", bl), (Type)BooleanType.BOOLEAN, bl == null ? null : (bl == Boolean.TRUE ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (false)", bl), (Type)BooleanType.BOOLEAN, bl == null ? null : Boolean.valueOf(bl == Boolean.FALSE));
            this.assertExecute(this.generateExpression("%s in (null, false)", bl), (Type)BooleanType.BOOLEAN, bl == null ? null : (bl == Boolean.FALSE ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (null)", bl), (Type)BooleanType.BOOLEAN, null);
        }
        for (Comparable<Boolean> comparable : intLefts) {
            testValues = Arrays.asList(33, 9, -9, -33);
            this.assertExecute(this.generateExpression("%s in (33, 9, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33, 9, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (CAST(null AS BIGINT), 33, 9, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33, null, 9, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33, CAST(null AS BIGINT), 9, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33, 9.0E0, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33, 9.0E0, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0E0, null, 9.0E0, -9, -33)", (Integer)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            testValues = Arrays.asList(33.0, 9.0, -9.0, -33.0);
            this.assertExecute(this.generateExpression("%s in (33.0E0, 9.0E0, -9.0E0, -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33.0E0, 9.0E0, -9.0E0, -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0E0, null, 9.0E0, -9.0E0, -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0E0, 9, -9, -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 33.0E0, 9, -9, -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (33.0E0, null, 9, -9, -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            testValues = Arrays.asList(33.0, Math.cos(9.0), Math.cos(-9.0), -33.0);
            this.assertExecute(this.generateExpression("cos(%s) in (33.0E0, cos(9.0E0), cos(-9.0E0), -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(Math.cos((Double)comparable))));
            this.assertExecute(this.generateExpression("cos(%s) in (null, 33.0E0, cos(9.0E0), cos(-9.0E0), -33.0E0)", (Double)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(Math.cos((Double)comparable)) ? Boolean.valueOf(true) : null));
        }
        for (Comparable<Boolean> comparable : decimalLefts) {
            testValues = ImmutableList.of((Object)new BigDecimal("9.0"), (Object)new BigDecimal("10.0"), (Object)new BigDecimal("-11.0"), (Object)new BigDecimal("9223372036.5477"));
            this.assertExecute(this.generateExpression("%s in (9.0, 10.0, -11.0, 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 9.0, 10.0, -11.0, 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (CAST(null AS DECIMAL(1,0)), 9.0, 10.0, -11.0, 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (9.0, CAST(null AS DECIMAL(1,0)), 10.0, -11.0, 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (9.0, null, 10.0, -11.0, 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (9.0, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            this.assertExecute(this.generateExpression("%s in (null, 9.0, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (null, 9, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in (CAST(9.0 as DOUBLE), null, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)", (BigDecimal)comparable), (Type)BooleanType.BOOLEAN, comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
        }
        for (String string : stringLefts) {
            testValues = Arrays.asList("what?", "foo", "mellow", "end");
            this.assertExecute(this.generateExpression("%s in ('what?', 'foo', 'mellow', 'end')", string), (Type)BooleanType.BOOLEAN, string == null ? null : Boolean.valueOf(testValues.contains(string)));
            this.assertExecute(this.generateExpression("%s in (null, 'what?', 'foo', 'mellow', 'end')", string), (Type)BooleanType.BOOLEAN, string == null ? null : (testValues.contains(string) ? Boolean.valueOf(true) : null));
            this.assertExecute(this.generateExpression("%s in ('what?', null, 'foo', 'mellow', 'end')", string), (Type)BooleanType.BOOLEAN, string == null ? null : (testValues.contains(string) ? Boolean.valueOf(true) : null));
        }
        this.assertExecute("1 in (100, 101, if(rand()>=0, 1), if(rand()<0, 1))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("1 in (100, 101, if(rand()<0, 1), if(rand()>=0, 1))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("2 in (100, 101, if(rand()>=0, 1), if(rand()<0, 1))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("2 in (100, 101, if(rand()<0, 1), if(rand()>=0, 1))", (Type)BooleanType.BOOLEAN, null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testHugeIn() throws Exception {
        String intValues = IntStream.range(2000, 7000).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertExecute("bound_integer in (1234, " + intValues + ")", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("bound_integer in (" + intValues + ")", (Type)BooleanType.BOOLEAN, (Object)false);
        String longValues = LongStream.range(0x80000000L, 2147488647L).mapToObj(Long::toString).collect(Collectors.joining(", "));
        this.assertExecute("bound_long in (1234, " + longValues + ")", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("bound_long in (" + longValues + ")", (Type)BooleanType.BOOLEAN, (Object)false);
        String doubleValues = IntStream.range(2000, 7000).asDoubleStream().mapToObj(this::formatDoubleToScientificNotation).collect(Collectors.joining(", "));
        this.assertExecute("bound_double in (12.34E0, " + doubleValues + ")", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("bound_double in (" + doubleValues + ")", (Type)BooleanType.BOOLEAN, (Object)false);
        String timestampValues = IntStream.range(0, 2000).mapToObj(i -> String.format("TIMESTAMP '1970-01-01 01:01:0%s.%s+01:00'", i / 1000, i % 1000)).collect(Collectors.joining(", "));
        this.assertExecute("bound_timestamp_with_timezone in (" + timestampValues + ")", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("bound_timestamp_with_timezone in (TIMESTAMP '1970-01-01 01:01:00.0+02:00')", (Type)BooleanType.BOOLEAN, (Object)false);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testInComplexTypes() {
        this.assertExecute("ARRAY[1] IN (ARRAY[1])", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("ARRAY[1] IN (ARRAY[2])", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("ARRAY[1] IN (ARRAY[2], ARRAY[1])", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("ARRAY[1] IN (null)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[1] IN (null, ARRAY[1])", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("ARRAY[1, 2, null] IN (ARRAY[2, null], ARRAY[1, null])", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("ARRAY[1, null] IN (ARRAY[2, null], null)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[null] IN (ARRAY[null])", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[1] IN (ARRAY[null])", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[null] IN (ARRAY[1])", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[1, null] IN (ARRAY[1, null])", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[1, null] IN (ARRAY[2, null])", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("ARRAY[1, null] IN (ARRAY[1, null], ARRAY[2, null])", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ARRAY[1, null] IN (ARRAY[1, null], ARRAY[2, null], ARRAY[1, null])", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(1) IN (ROW(1))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("ROW(1) IN (ROW(2))", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("ROW(1) IN (ROW(2), ROW(1), ROW(2))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("ROW(1) IN (null)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(1) IN (null, ROW(1))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("ROW(1, null) IN (ROW(2, null), null)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(null) IN (ROW(null))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(1) IN (ROW(null))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(null) IN (ROW(1))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(1, null) IN (ROW(1, null))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(1, null) IN (ROW(2, null))", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("ROW(1, null) IN (ROW(1, null), ROW(2, null))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("ROW(1, null) IN (ROW(1, null), ROW(2, null), ROW(1, null))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1], ARRAY[1]) IN (MAP(ARRAY[1], ARRAY[1]))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("MAP(ARRAY[1], ARRAY[1]) IN (null)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1], ARRAY[1]) IN (null, MAP(ARRAY[1], ARRAY[1]))", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("MAP(ARRAY[1], ARRAY[1]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]))", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[2, null]), null)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 3], ARRAY[1, null]))", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("MAP(ARRAY[1], ARRAY[null]) IN (MAP(ARRAY[1], ARRAY[null]))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1], ARRAY[1]) IN (MAP(ARRAY[1], ARRAY[null]))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1], ARRAY[null]) IN (MAP(ARRAY[1], ARRAY[1]))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 3], ARRAY[1, null]))", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[2, null]))", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]), MAP(ARRAY[1, 2], ARRAY[2, null]))", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("MAP(ARRAY[1, 2], ARRAY[1, null]) IN (MAP(ARRAY[1, 2], ARRAY[1, null]), MAP(ARRAY[1, 2], ARRAY[2, null]), MAP(ARRAY[1, 2], ARRAY[1, null]))", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testFunctionCall() throws Exception {
        for (Integer n : intLefts) {
            for (Integer n2 : intRights) {
                this.assertExecute(this.generateExpression("bitwise_and(%s, %s)", n, n2), (Type)BigintType.BIGINT, n == null || n2 == null ? null : Long.valueOf(BitwiseFunctions.bitwiseAnd((long)n.intValue(), (long)n2.intValue())));
            }
        }
        for (Integer n : intLefts) {
            for (Number number : doubleRights) {
                this.assertExecute(this.generateExpression("mod(%s, %s)", n, (Double)number), (Type)DoubleType.DOUBLE, n == null || number == null ? null : Double.valueOf(MathFunctions.mod((double)n.intValue(), (double)((Double)number))));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number2 : intRights) {
                this.assertExecute(this.generateExpression("mod(%s, %s)", (Double)number, (Integer)number2), (Type)DoubleType.DOUBLE, number == null || number2 == null ? null : Double.valueOf(MathFunctions.mod((double)((Double)number), (double)((Integer)number2).intValue())));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number3 : doubleRights) {
                this.assertExecute(this.generateExpression("mod(%s, %s)", (Double)number, (Double)number3), (Type)DoubleType.DOUBLE, number == null || number3 == null ? null : Double.valueOf(MathFunctions.mod((double)((Double)number), (double)((Double)number3))));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number4 : decimalRights) {
                this.assertExecute(this.generateExpression("mod(%s, %s)", (Double)number, (BigDecimal)number4), (Type)DoubleType.DOUBLE, number == null || number4 == null ? null : Double.valueOf(MathFunctions.mod((double)((Double)number), (double)((BigDecimal)number4).doubleValue())));
            }
        }
        for (Number number : decimalLefts) {
            for (Number number5 : longRights) {
                this.assertExecute(this.generateExpression("power(%s, %s)", (BigDecimal)number, (Long)number5), (Type)DoubleType.DOUBLE, number == null || number5 == null ? null : Double.valueOf(MathFunctions.power((double)((BigDecimal)number).doubleValue(), (double)((Long)number5).longValue())));
            }
        }
        for (String string : stringLefts) {
            for (Number number : intLefts) {
                for (Integer length : intRights) {
                    String expected = string == null || number == null || length == null ? null : StringFunctions.substr((Slice)Slices.utf8Slice((String)string), (long)((Integer)number).intValue(), (long)length.intValue()).toStringUtf8();
                    VarcharType expectedType = string != null ? VarcharType.createVarcharType((int)string.length()) : VarcharType.VARCHAR;
                    this.assertExecute(this.generateExpression("substr(%s, %s, %s)", string, (Integer)number, length), (Type)expectedType, (Object)expected);
                }
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionCallRegexp() throws Exception {
        for (String value : stringLefts) {
            for (String pattern : stringRights) {
                this.assertExecute(this.generateExpression("regexp_like(%s, %s)", value, pattern), (Type)BooleanType.BOOLEAN, value == null || pattern == null ? null : Boolean.valueOf(JoniRegexpFunctions.regexpLike((Slice)Slices.utf8Slice((String)value), (Regex)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern)))));
                this.assertExecute(this.generateExpression("regexp_replace(%s, %s)", value, pattern), (Type)(value == null ? VarcharType.VARCHAR : VarcharType.createVarcharType((int)value.length())), value == null || pattern == null ? null : JoniRegexpFunctions.regexpReplace((Slice)Slices.utf8Slice((String)value), (Regex)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern))));
                this.assertExecute(this.generateExpression("regexp_extract(%s, %s)", value, pattern), (Type)(value == null ? VarcharType.VARCHAR : VarcharType.createVarcharType((int)value.length())), value == null || pattern == null ? null : JoniRegexpFunctions.regexpExtract((Slice)Slices.utf8Slice((String)value), (Regex)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern))));
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionCallJson() throws Exception {
        ConnectorSession session = SessionTestUtils.TEST_SESSION.toConnectorSession();
        for (String value : jsonValues) {
            for (String pattern : jsonPatterns) {
                this.assertExecute(this.generateExpression("json_extract(%s, %s)", value, pattern), (Type)JsonType.JSON, value == null || pattern == null ? null : JsonFunctions.jsonExtract((Slice)Slices.utf8Slice((String)value), (JsonPath)JsonPath.build((String)pattern)));
                this.assertExecute(this.generateExpression("json_extract_scalar(%s, %s)", value, pattern), (Type)(value == null ? VarcharType.createUnboundedVarcharType() : VarcharType.createVarcharType((int)value.length())), value == null || pattern == null ? null : JsonFunctions.jsonExtractScalar((Slice)Slices.utf8Slice((String)value), (JsonPath)JsonPath.build((String)pattern)));
                this.assertExecute(this.generateExpression("json_extract(%s, %s || '')", value, pattern), (Type)JsonType.JSON, value == null || pattern == null ? null : JsonFunctions.jsonExtract((Slice)Slices.utf8Slice((String)value), (JsonPath)JsonPath.build((String)pattern)));
                this.assertExecute(this.generateExpression("json_extract_scalar(%s, %s || '')", value, pattern), (Type)(value == null ? VarcharType.createUnboundedVarcharType() : VarcharType.createVarcharType((int)value.length())), value == null || pattern == null ? null : JsonFunctions.jsonExtractScalar((Slice)Slices.utf8Slice((String)value), (JsonPath)JsonPath.build((String)pattern)));
            }
        }
        this.assertExecute("json_array_contains('[1, 2, 3]', 2)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("json_array_contains('[1, 2, 3]', BIGINT '2')", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("json_array_contains('[2.5E0]', 2.5E0)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("json_array_contains('[false, true]', true)", (Type)BooleanType.BOOLEAN, (Object)true);
        this.assertExecute("json_array_contains('[5]', 3)", (Type)BooleanType.BOOLEAN, (Object)false);
        this.assertExecute("json_array_contains('[', 9)", (Type)BooleanType.BOOLEAN, null);
        this.assertExecute("json_array_length('[')", (Type)BigintType.BIGINT, null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testFunctionWithSessionCall() throws Exception {
        this.assertExecute("now()", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)new SqlTimestampWithTimeZone(SessionTestUtils.TEST_SESSION.getStartTime(), SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        this.assertExecute("current_timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)new SqlTimestampWithTimeZone(SessionTestUtils.TEST_SESSION.getStartTime(), SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testExtract() throws Exception {
        for (DateTime left : dateTimeValues) {
            for (Extract.Field field : Extract.Field.values()) {
                Long expected = null;
                Long millis = null;
                if (left != null) {
                    millis = left.getMillis();
                    expected = TestExpressionCompiler.callExtractFunction(SessionTestUtils.TEST_SESSION.toConnectorSession(), millis, field);
                }
                DateTimeZone zone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)SessionTestUtils.TEST_SESSION.getTimeZoneKey());
                long zoneOffsetMinutes = millis != null ? TimeUnit.MILLISECONDS.toMinutes(zone.getOffset(millis.longValue())) : 0L;
                String expressionPattern = String.format("extract(%s from from_unixtime(%%s / 1000.0E0, %s, %s))", field, zoneOffsetMinutes / 60L, zoneOffsetMinutes % 60L);
                this.assertExecute(this.generateExpression(expressionPattern, millis), (Type)BigintType.BIGINT, (Object)expected);
            }
        }
        Futures.allAsList(this.futures).get();
    }

    private static long callExtractFunction(ConnectorSession session, long value, Extract.Field field) {
        switch (field) {
            case YEAR: {
                return DateTimeFunctions.yearFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case QUARTER: {
                return DateTimeFunctions.quarterFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case MONTH: {
                return DateTimeFunctions.monthFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case WEEK: {
                return DateTimeFunctions.weekFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case DAY: 
            case DAY_OF_MONTH: {
                return DateTimeFunctions.dayFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case DAY_OF_WEEK: 
            case DOW: {
                return DateTimeFunctions.dayOfWeekFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case YEAR_OF_WEEK: 
            case YOW: {
                return DateTimeFunctions.yearOfWeekFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case DAY_OF_YEAR: 
            case DOY: {
                return DateTimeFunctions.dayOfYearFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case HOUR: {
                return DateTimeFunctions.hourFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case MINUTE: {
                return DateTimeFunctions.minuteFromTimestamp((SqlFunctionProperties)session.getSqlFunctionProperties(), (long)value);
            }
            case SECOND: {
                return DateTimeFunctions.secondFromTimestamp((long)value);
            }
            case TIMEZONE_MINUTE: {
                return DateTimeFunctions.timeZoneMinuteFromTimestampWithTimeZone((long)DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getSqlFunctionProperties().getTimeZoneKey()));
            }
            case TIMEZONE_HOUR: {
                return DateTimeFunctions.timeZoneHourFromTimestampWithTimeZone((long)DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getSqlFunctionProperties().getTimeZoneKey()));
            }
        }
        throw new AssertionError((Object)("Unhandled field: " + field));
    }

    @Test
    public void testLike() throws Exception {
        for (String value : stringLefts) {
            for (String pattern : stringLefts) {
                Boolean expected = null;
                if (value != null && pattern != null) {
                    Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern), (Slice)Slices.utf8Slice((String)"\\"));
                    expected = LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)value), (Regex)regex);
                }
                this.assertExecute(this.generateExpression("%s like %s", value, pattern), (Type)BooleanType.BOOLEAN, expected);
            }
        }
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testCoalesce() throws Exception {
        this.assertExecute("coalesce(9, 1)", (Type)IntegerType.INTEGER, (Object)9);
        this.assertExecute("coalesce(9, null)", (Type)IntegerType.INTEGER, (Object)9);
        this.assertExecute("coalesce(9, BIGINT '1')", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(BIGINT '9', null)", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(9, cast(null as bigint))", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(null, 9, 1)", (Type)IntegerType.INTEGER, (Object)9);
        this.assertExecute("coalesce(null, 9, null)", (Type)IntegerType.INTEGER, (Object)9);
        this.assertExecute("coalesce(null, 9, BIGINT '1')", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(null, 9, CAST (null AS BIGINT))", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(null, 9, cast(null as bigint))", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(cast(null as bigint), 9, 1)", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(cast(null as bigint), 9, null)", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(cast(null as bigint), 9, cast(null as bigint))", (Type)BigintType.BIGINT, (Object)9L);
        this.assertExecute("coalesce(9.0E0, 1.0E0)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(9.0E0, 1)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(9.0E0, null)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(9.0E0, cast(null as double))", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(null, 9.0E0, 1)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(null, 9.0E0, null)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(null, 9.0E0, cast(null as double))", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(null, 9.0E0, cast(null as bigint))", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(cast(null as bigint), 9.0E0, 1)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(cast(null as bigint), 9.0E0, null)", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(cast(null as bigint), 9.0E0, cast(null as bigint))", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce(cast(null as double), 9.0E0, cast(null as double))", (Type)DoubleType.DOUBLE, (Object)9.0);
        this.assertExecute("coalesce('foo', 'banana')", (Type)VarcharType.createVarcharType((int)6), (Object)"foo");
        this.assertExecute("coalesce('foo', null)", (Type)VarcharType.createVarcharType((int)3), (Object)"foo");
        this.assertExecute("coalesce('foo', cast(null as varchar))", (Type)VarcharType.VARCHAR, (Object)"foo");
        this.assertExecute("coalesce(null, 'foo', 'banana')", (Type)VarcharType.createVarcharType((int)6), (Object)"foo");
        this.assertExecute("coalesce(null, 'foo', null)", (Type)VarcharType.createVarcharType((int)3), (Object)"foo");
        this.assertExecute("coalesce(null, 'foo', cast(null as varchar))", (Type)VarcharType.VARCHAR, (Object)"foo");
        this.assertExecute("coalesce(cast(null as varchar), 'foo', 'bar')", (Type)VarcharType.VARCHAR, (Object)"foo");
        this.assertExecute("coalesce(cast(null as varchar), 'foo', null)", (Type)VarcharType.VARCHAR, (Object)"foo");
        this.assertExecute("coalesce(cast(null as varchar), 'foo', cast(null as varchar))", (Type)VarcharType.VARCHAR, (Object)"foo");
        this.assertExecute("coalesce(cast(null as bigint), null, cast(null as bigint))", (Type)BigintType.BIGINT, null);
        Futures.allAsList(this.futures).get();
    }

    @Test
    public void testNullif() throws Exception {
        this.assertExecute("nullif(BIGINT '2', INT '2')", (Type)BigintType.BIGINT, null);
        this.assertExecute("nullif(INT '2', BIGINT '2')", (Type)IntegerType.INTEGER, null);
        this.assertExecute("nullif(INT '2', BIGINT '3')", (Type)IntegerType.INTEGER, (Object)2);
        this.assertExecute("nullif(NULL, NULL)", (Type)UnknownType.UNKNOWN, null);
        this.assertExecute("nullif(NULL, 2)", (Type)UnknownType.UNKNOWN, null);
        this.assertExecute("nullif(2, NULL)", (Type)IntegerType.INTEGER, (Object)2);
        this.assertExecute("nullif(BIGINT '2', NULL)", (Type)BigintType.BIGINT, (Object)2L);
        this.assertExecute("nullif(ARRAY[CAST(1 AS BIGINT)], ARRAY[CAST(1 AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), null);
        this.assertExecute("nullif(ARRAY[CAST(1 AS BIGINT)], ARRAY[CAST(NULL AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), (Object)ImmutableList.of((Object)1L));
        this.assertExecute("nullif(ARRAY[CAST(NULL AS BIGINT)], ARRAY[CAST(NULL AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), Collections.singletonList(null));
        this.assertExecute("nullif(map(array[1], array[smallint '1']), map(array[1], array[integer '1']))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)SmallintType.SMALLINT), null);
        Futures.allAsList(this.futures).get();
    }

    private List<String> generateExpression(String expressionPattern, Boolean value) {
        return TestExpressionCompiler.formatExpression(expressionPattern, value, "boolean");
    }

    private List<String> generateExpression(String expressionPattern, Long value) {
        return TestExpressionCompiler.formatExpression(expressionPattern, value, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Integer value) {
        return TestExpressionCompiler.formatExpression(expressionPattern, value, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Double value) {
        return TestExpressionCompiler.formatExpression(expressionPattern, value, "double");
    }

    private List<String> generateExpression(String expressionPattern, String value) {
        return TestExpressionCompiler.formatExpression(expressionPattern, value, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, BigDecimal value) {
        return TestExpressionCompiler.formatExpression(expressionPattern, value, TestExpressionCompiler.getDecimalType(value).toString());
    }

    private List<String> generateExpression(String expressionPattern, Boolean left, Boolean right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "boolean", right, "boolean");
    }

    private List<String> generateExpression(String expressionPattern, Long left, Long right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "bigint", right, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Long left, Integer right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "bigint", right, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Integer left, Integer right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "integer", right, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Long left, Double right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "bigint", right, "double");
    }

    private List<String> generateExpression(String expressionPattern, Integer left, Double right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "integer", right, "double");
    }

    private List<String> generateExpression(String expressionPattern, Double left, Long right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "double", right, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Double left, Integer right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "double", right, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Double left, Double right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "double", right, "double");
    }

    private List<String> generateExpression(String expressionPattern, Long left, BigDecimal right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "bigint", right, TestExpressionCompiler.getDecimalType(right).toString());
    }

    private List<String> generateExpression(String expressionPattern, BigDecimal left, Long right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, TestExpressionCompiler.getDecimalType(left).toString(), right, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Integer left, BigDecimal right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "integer", right, TestExpressionCompiler.getDecimalType(right).toString());
    }

    private List<String> generateExpression(String expressionPattern, BigDecimal left, Integer right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, TestExpressionCompiler.getDecimalType(left).toString(), right, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Double left, BigDecimal right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "double", right, TestExpressionCompiler.getDecimalType(right).toString());
    }

    private List<String> generateExpression(String expressionPattern, BigDecimal left, Double right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, TestExpressionCompiler.getDecimalType(left).toString(), right, "double");
    }

    private List<String> generateExpression(String expressionPattern, String left, String right) {
        return TestExpressionCompiler.formatExpression(expressionPattern, left, "varchar", right, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, Long first, Long second, Long third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "bigint", second, "bigint", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Integer first, Integer second, Integer third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "integer", second, "integer", third, "integer");
    }

    private List<String> generateExpression(String expressionPattern, BigDecimal first, BigDecimal second, BigDecimal third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, TestExpressionCompiler.getDecimalType(first).toString(), second, TestExpressionCompiler.getDecimalType(second).toString(), third, TestExpressionCompiler.getDecimalType(third).toString());
    }

    private List<String> generateExpression(String expressionPattern, Long first, Double second, Long third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "bigint", second, "double", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, Integer first, Double second, Integer third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "integer", second, "double", third, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Double first, Double second, Double third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "double", second, "double", third, "double");
    }

    private List<String> generateExpression(String expressionPattern, Double first, Double second, Integer third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "double", second, "double", third, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Double first, Long second, Double third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "double", second, "bigint", third, "double");
    }

    private List<String> generateExpression(String expressionPattern, String first, String second, String third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "varchar", second, "varchar", third, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, Boolean first, String second, String third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "boolean", second, "varchar", third, "varchar");
    }

    private List<String> generateExpression(String expressionPattern, String first, Long second, Long third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "varchar", second, "bigint", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, String first, Integer second, Integer third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "varchar", second, "integer", third, "integer");
    }

    private List<String> generateExpression(String expressionPattern, Long first, BigDecimal second, Long third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, "bigint", second, "decimal(3,1)", third, "bigint");
    }

    private List<String> generateExpression(String expressionPattern, BigDecimal first, Double second, BigDecimal third) {
        return TestExpressionCompiler.formatExpression(expressionPattern, first, TestExpressionCompiler.getDecimalType(first).toString(), second, "double", third, TestExpressionCompiler.getDecimalType(third).toString());
    }

    private static List<String> formatExpression(String expressionPattern, Object value, String type) {
        return TestExpressionCompiler.formatExpression(expressionPattern, Arrays.asList(value), (List<String>)ImmutableList.of((Object)type));
    }

    private static List<String> formatExpression(String expressionPattern, Object left, String leftType, Object right, String rightType) {
        return TestExpressionCompiler.formatExpression(expressionPattern, Arrays.asList(left, right), (List<String>)ImmutableList.of((Object)leftType, (Object)rightType));
    }

    private static List<String> formatExpression(String expressionPattern, Object first, String firstType, Object second, String secondType, Object third, String thirdType) {
        return TestExpressionCompiler.formatExpression(expressionPattern, Arrays.asList(first, second, third), (List<String>)ImmutableList.of((Object)firstType, (Object)secondType, (Object)thirdType));
    }

    private static List<String> formatExpression(String expressionPattern, List<Object> values, List<String> types) {
        Preconditions.checkArgument((values.size() == types.size() ? 1 : 0) != 0);
        ArrayList<ImmutableSet> unrolledValues = new ArrayList<ImmutableSet>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            String type = types.get(i);
            if (value != null) {
                if (type.equals("varchar")) {
                    value = "'" + value + "'";
                } else if (type.equals("bigint")) {
                    value = "CAST( " + value + " AS BIGINT)";
                } else if (type.equals("double")) {
                    value = "CAST( " + value + " AS DOUBLE)";
                }
                unrolledValues.add(ImmutableSet.of((Object)String.valueOf(value)));
                continue;
            }
            unrolledValues.add(ImmutableSet.of((Object)("cast(null as " + type + ")")));
        }
        ImmutableList.Builder expressions = ImmutableList.builder();
        Set valueLists = Sets.cartesianProduct(unrolledValues);
        for (List valueList : valueLists) {
            expressions.add((Object)String.format(expressionPattern, valueList.toArray(new Object[valueList.size()])));
        }
        return expressions.build();
    }

    private String formatDoubleToScientificNotation(Double value) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("0.##############E0");
        return formatter.format(value);
    }

    private void assertExecute(String expression, Type expectedType, Object expected) {
        this.addCallable(new AssertExecuteTask(this.functionAssertions, expression, expectedType, expected));
    }

    private void addCallable(Runnable runnable) {
        runnable.run();
    }

    private void assertExecute(List<String> expressions, Type expectedType, Object expected) {
        if (expected instanceof Slice) {
            expected = ((Slice)expected).toStringUtf8();
        }
        for (String expression : expressions) {
            this.assertExecute(expression, expectedType, expected);
        }
    }

    private void assertExecute(List<String> expressions, BigDecimal decimal) {
        Type type = TestExpressionCompiler.getDecimalType(decimal);
        SqlDecimal value = decimal == null ? null : new SqlDecimal(decimal.unscaledValue(), decimal.precision(), decimal.scale());
        for (String expression : expressions) {
            this.assertExecute(expression, type, (Object)value);
        }
    }

    private static Type getDecimalType(BigDecimal decimal) {
        if (decimal == null) {
            return DecimalType.createDecimalType((int)1, (int)0);
        }
        return DecimalType.createDecimalType((int)decimal.precision(), (int)decimal.scale());
    }

    private void assertFilterWithNoInputColumns(String filter, boolean expected) {
        this.addCallable(new AssertFilterTask(this.functionAssertions, filter, expected, true));
    }

    private void assertFilter(String filter, boolean expected) {
        this.addCallable(new AssertFilterTask(this.functionAssertions, filter, expected, false));
    }

    private static class AssertFilterTask
    implements Runnable {
        private final FunctionAssertions functionAssertions;
        private final String filter;
        private final boolean expected;
        private final boolean withNoInputColumns;

        public AssertFilterTask(FunctionAssertions functionAssertions, String filter, boolean expected, boolean withNoInputColumns) {
            this.functionAssertions = functionAssertions;
            this.filter = filter;
            this.expected = expected;
            this.withNoInputColumns = withNoInputColumns;
        }

        @Override
        public void run() {
            try {
                this.functionAssertions.assertFilter(this.filter, this.expected, this.withNoInputColumns);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error processing " + this.filter, e);
            }
        }
    }

    private static class AssertExecuteTask
    implements Runnable {
        private final FunctionAssertions functionAssertions;
        private final String expression;
        private final Type expectedType;
        private final Object expected;

        public AssertExecuteTask(FunctionAssertions functionAssertions, String expression, Type expectedType, Object expected) {
            this.functionAssertions = functionAssertions;
            this.expectedType = expectedType;
            this.expression = expression;
            this.expected = expected;
        }

        @Override
        public void run() {
            try {
                this.functionAssertions.assertFunction(this.expression, this.expectedType, this.expected);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error processing " + this.expression, e);
            }
        }
    }
}

