/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.ColumnNaming;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.tpch.Customer;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5)
@Fork(value=1)
@Measurement(iterations=20)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPlanner {
    @Benchmark
    public List<Plan> planQueries(BenchmarkData benchmarkData) {
        return (List)benchmarkData.queryRunner.inTransaction(transactionSession -> {
            Optimizer.PlanStage stage = Optimizer.PlanStage.valueOf((String)benchmarkData.stage.toUpperCase());
            return (ImmutableList)benchmarkData.queries.stream().map(query -> benchmarkData.queryRunner.createPlan(transactionSession, query, stage, false, WarningCollector.NOOP)).collect(ImmutableList.toImmutableList());
        });
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        try {
            new BenchmarkPlanner().planQueries(data);
        }
        finally {
            data.tearDown();
        }
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.BULK).include(".*" + BenchmarkPlanner.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkData {
        @Param(value={"true", "false"})
        private String iterativeOptimizerEnabled = "true";
        @Param(value={"optimized", "created"})
        private String stage = Optimizer.PlanStage.OPTIMIZED.toString();
        private LocalQueryRunner queryRunner;
        private List<String> queries;
        private Session session;

        @Setup
        public void setup() {
            String tpch = "tpch";
            this.session = TestingSession.testSessionBuilder().setCatalog(tpch).setSchema("sf1").setSystemProperty("iterative_optimizer_enabled", this.iterativeOptimizerEnabled).build();
            this.queryRunner = new LocalQueryRunner(this.session);
            this.queryRunner.createCatalog(tpch, (ConnectorFactory)new TpchConnectorFactory(4), (Map)ImmutableMap.of((Object)"tpch.column-naming", (Object)ColumnNaming.STANDARD.name()));
            this.queries = (List)IntStream.rangeClosed(1, 22).boxed().filter(i -> i != 15).map(i -> this.readResource(String.format("/io/airlift/tpch/queries/q%d.sql", i))).collect(ImmutableList.toImmutableList());
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
            this.queryRunner = null;
        }

        public String readResource(String resource) {
            try {
                URL resourceUrl = Customer.class.getResource(resource);
                return Resources.toString((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

