/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestCanonicalize
extends BasePlanTest {
    @Test
    public void testJoin() {
        this.assertPlan("SELECT *\nFROM (\n    SELECT EXTRACT(DAY FROM DATE '2017-01-01')\n) t\nCROSS JOIN (VALUES 1)", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("rewrite_expression_with_constant_expression", "false").setSystemProperty("remove_cross_join_with_constant_single_row_input", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"X", (Object)PlanMatchPattern.expression("BIGINT '1'")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of())), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()))));
        this.assertPlan("SELECT *\nFROM (\n    SELECT EXTRACT(DAY FROM DATE '2017-01-01')\n) t\nCROSS JOIN (VALUES 1)", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("rewrite_expression_with_constant_expression", "false").setSystemProperty("remove_cross_join_with_constant_single_row_input", "true").build(), PlanMatchPattern.anyTree(PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testDuplicatesInWindowOrderBy() {
        ExpectedValueProvider<WindowNode.Specification> specification = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"A"), (Map<String, SortOrder>)ImmutableMap.of((Object)"A", (Object)SortOrder.ASC_NULLS_LAST));
        this.assertPlan("WITH x as (SELECT a, a as b FROM (VALUES 1) t(a))SELECT *, row_number() OVER(ORDER BY a ASC, b DESC)FROM x", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specification).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.values("A"))), (List<PlanOptimizer>)ImmutableList.of((Object)new UnaliasSymbolReferences(this.getMetadata().getFunctionAndTypeManager()), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections()))));
    }
}

