/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestDynamicFilter
extends BasePlanTest {
    TestDynamicFilter() {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)"true"));
    }

    @Test
    public void testNonInnerJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o LEFT JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRightEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRightEquiJoinWithLeftExpression() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey + 1 = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "expr")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("LINEITEM_OK + BIGINT '1'")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testEmptyJoinCriteria() {
        this.assertPlan("SELECT o.orderkey FROM orders o CROSS JOIN lineitem l", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders"), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem")))));
    }

    @Test
    public void testCrossJoinInequalityWithCast() {
        this.assertPlan("SELECT o.comment, l.comment FROM orders o, lineitem l WHERE o.comment < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_COMMENT < CAST(L_COMMENT AS varchar(79))", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_COMMENT", (Object)"comment")), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_COMMENT", (Object)"comment")))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK"), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinOnCast() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE cast(l.orderkey as int) = cast(o.orderkey as int)", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testJoinMultipleEquiJoinClauses() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey AND l.partkey = o.custkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK"), PlanMatchPattern.equiJoinClause("ORDERS_CK", "LINEITEM_PK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK", (Object)"ORDERS_CK", (Object)"LINEITEM_PK"), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey", (Object)"ORDERS_CK", (Object)"custkey")), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_PK", (Object)"partkey")))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK"), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("X", "Y")), (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"Y"), Optional.empty(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")), PlanMatchPattern.project(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testSubTreeJoinDFOnProbeSide() {
        this.assertPlan("SELECT part.partkey from part JOIN (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) ON part.partkey = lineitem.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("PART_PK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"LINEITEM_OK"), Optional.empty(), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"ORDERS_OK"), Optional.empty(), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))))));
    }

    @Test
    public void testSubTreeJoinDFOnBuildSide() {
        this.assertPlan("SELECT part.partkey from (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) JOIN part ON lineitem.orderkey = part.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))), PlanMatchPattern.exchange(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "PART_PK")), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey")))))))));
    }

    @Test
    public void testSemiJoin() {
        this.assertPlan("select o.orderkey,totalprice from orders o WHERE o.orderkey IN ( SELECT l.orderkey FROM lineitem l)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testSemiJoinWithFilter() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testPushDownToLhsOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders)) WHERE linenumber = 2", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_NUMBER = 2", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_NUMBER", (Object)"linenumber", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testNonDeterministicPredicatePropagatesOnlyToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testGreaterPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testGreaterPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromSourceSideNotPropagatesToFilterSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testNonPushedDownJoinFilterRemoval() {
        this.assertPlan("SELECT 1 FROM part t0, part t1, part t2 WHERE t0.partkey = t1.partkey AND t0.partkey = t2.partkey AND t0.size + t1.size = t2.size", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("K0", "K2"), PlanMatchPattern.equiJoinClause("S", "V2")), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"S", (Object)PlanMatchPattern.expression("V0 + V1")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("K0", "K1")), PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K0", (Object)"partkey", (Object)"V0", (Object)"size")))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K1", (Object)"partkey", (Object)"V1", (Object)"size")))))))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K2", (Object)"partkey", (Object)"V2", (Object)"size")))))));
    }

    @Test
    public void testJoinReorderingNotImpacted() {
        this.assertPlan("select 1 FROM   supplier s   INNER JOIN lineitem l ON s.suppkey = l.suppkey   INNER JOIN nation n ON s.nationkey = n.nationkey ", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_SK", "SUPPLIER_SK")), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_SK", (Object)"suppkey")))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("SUPPLIER_NK", "NATION_NK")), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK", (Object)"suppkey", (Object)"SUPPLIER_NK", (Object)"nationkey")))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATION_NK", (Object)"nationkey"))))))))));
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }
}

