/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestEqualityInference {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TestingRowExpressionTranslator ROW_EXPRESSION_TRANSLATOR = new TestingRowExpressionTranslator(METADATA);

    @Test
    public void testTransitivity() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        TestEqualityInference.addEquality("a1", "b1", builder);
        TestEqualityInference.addEquality("b1", "c1", builder);
        TestEqualityInference.addEquality("d1", "c1", builder);
        TestEqualityInference.addEquality("a2", "b2", builder);
        TestEqualityInference.addEquality("b2", "a2", builder);
        TestEqualityInference.addEquality("b2", "c2", builder);
        TestEqualityInference.addEquality("d2", "b2", builder);
        TestEqualityInference.addEquality("c2", "d2", builder);
        EqualityInference inference = builder.build();
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.matchesVariables("d1", "d2")), (Object)TestEqualityInference.someExpression("d1", "d2"));
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.someExpression("a1", "c1"), TestEqualityInference.matchesVariables("b1")), (Object)TestEqualityInference.someExpression("b1", "b1"));
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.matchesVariables("b1", "d2", "c3")), (Object)TestEqualityInference.someExpression("b1", "d2"));
        Assert.assertEquals((Object)inference.getScopedCanonical((RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.matchesVariables("c2", "d2")), (Object)inference.getScopedCanonical((RowExpression)TestEqualityInference.variable("b2"), TestEqualityInference.matchesVariables("c2", "d2")));
        RowExpression canonical = inference.getScopedCanonical((RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.matchesVariables("c2", "d2"));
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.someExpression("a2", "b2"), TestEqualityInference.matchesVariables("c2", "d2")), (Object)TestEqualityInference.someExpression(canonical, canonical));
    }

    @Test
    public void testTriviallyRewritable() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        RowExpression expression = builder.build().rewriteExpression(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.matchesVariables("a1", "a2"));
        Assert.assertEquals((Object)expression, (Object)TestEqualityInference.someExpression("a1", "a2"));
    }

    @Test
    public void testUnrewritable() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        TestEqualityInference.addEquality("a1", "b1", builder);
        TestEqualityInference.addEquality("a2", "b2", builder);
        EqualityInference inference = builder.build();
        Assert.assertNull((Object)inference.rewriteExpression(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.matchesVariables("b1", "c1")));
        Assert.assertNull((Object)inference.rewriteExpression(TestEqualityInference.someExpression("c1", "c2"), TestEqualityInference.matchesVariables("a1", "a2")));
    }

    @Test
    public void testParseEqualityExpression() {
        EqualityInference inference = new EqualityInference.Builder(METADATA).addEquality(TestEqualityInference.equals("a1", "b1")).addEquality(TestEqualityInference.equals("a1", "c1")).addEquality(TestEqualityInference.equals("c1", "a1")).build();
        RowExpression expression = inference.rewriteExpression(TestEqualityInference.someExpression("a1", "b1"), TestEqualityInference.matchesVariables("c1"));
        Assert.assertEquals((Object)expression, (Object)TestEqualityInference.someExpression("c1", "c1"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidEqualityExpression1() {
        new EqualityInference.Builder(METADATA).addEquality(TestEqualityInference.equals("a1", "a1"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidEqualityExpression2() {
        new EqualityInference.Builder(METADATA).addEquality(TestEqualityInference.someExpression("a1", "b1"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidEqualityExpression3() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        TestEqualityInference.addEquality("a1", "a1", builder);
    }

    @Test
    public void testExtractInferableEqualities() {
        EqualityInference inference = new EqualityInference.Builder(METADATA).extractInferenceCandidates(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.someExpression("c1", "d1")})).build();
        Assert.assertEquals((Object)TestEqualityInference.variable("c1"), (Object)inference.rewriteExpression((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.matchesVariables("c1")));
        Assert.assertNull((Object)inference.rewriteExpression((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.matchesVariables("d1")));
    }

    @Test
    public void testEqualityPartitionGeneration() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        builder.addEquality((RowExpression)TestEqualityInference.variable("a1"), (RowExpression)TestEqualityInference.variable("b1"));
        builder.addEquality(TestEqualityInference.add("a1", "a1"), TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.number(2L)));
        builder.addEquality((RowExpression)TestEqualityInference.variable("b1"), (RowExpression)TestEqualityInference.variable("c1"));
        builder.addEquality(TestEqualityInference.add("a1", "a1"), (RowExpression)TestEqualityInference.variable("c1"));
        builder.addEquality(TestEqualityInference.add("a1", "b1"), (RowExpression)TestEqualityInference.variable("c1"));
        EqualityInference inference = builder.build();
        EqualityInference.EqualityPartition emptyScopePartition = inference.generateEqualitiesPartitionedBy(Predicates.alwaysFalse());
        Assert.assertTrue((boolean)emptyScopePartition.getScopeEqualities().isEmpty());
        Assert.assertFalse((boolean)emptyScopePartition.getScopeComplementEqualities().isEmpty());
        Assert.assertTrue((boolean)emptyScopePartition.getScopeStraddlingEqualities().isEmpty());
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.matchesVariables("c1"));
        Assert.assertFalse((boolean)equalityPartition.getScopeEqualities().isEmpty());
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), TestEqualityInference.matchesVariableScope(TestEqualityInference.matchesVariables("c1"))));
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), (Predicate)EqualityInference.Builder.isInferenceCandidate((Metadata)METADATA)));
        Assert.assertFalse((boolean)equalityPartition.getScopeComplementEqualities().isEmpty());
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), TestEqualityInference.matchesVariableScope((Predicate<VariableReferenceExpression>)Predicates.not(TestEqualityInference.matchesVariables("c1")))));
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), (Predicate)EqualityInference.Builder.isInferenceCandidate((Metadata)METADATA)));
        Assert.assertFalse((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty());
        Assert.assertTrue((boolean)Iterables.any((Iterable)equalityPartition.getScopeStraddlingEqualities(), TestEqualityInference.matchesStraddlingScope(TestEqualityInference.matchesVariables("c1"))));
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeStraddlingEqualities(), (Predicate)EqualityInference.Builder.isInferenceCandidate((Metadata)METADATA)));
        EqualityInference newInference = new EqualityInference.Builder(METADATA).addAllEqualities((Iterable)equalityPartition.getScopeEqualities()).addAllEqualities((Iterable)equalityPartition.getScopeComplementEqualities()).addAllEqualities((Iterable)equalityPartition.getScopeStraddlingEqualities()).build();
        EqualityInference.EqualityPartition newEqualityPartition = newInference.generateEqualitiesPartitionedBy(TestEqualityInference.matchesVariables("c1"));
        Assert.assertEquals(TestEqualityInference.setCopy(equalityPartition.getScopeEqualities()), TestEqualityInference.setCopy(newEqualityPartition.getScopeEqualities()));
        Assert.assertEquals(TestEqualityInference.setCopy(equalityPartition.getScopeComplementEqualities()), TestEqualityInference.setCopy(newEqualityPartition.getScopeComplementEqualities()));
        Assert.assertEquals(TestEqualityInference.setCopy(equalityPartition.getScopeStraddlingEqualities()), TestEqualityInference.setCopy(newEqualityPartition.getScopeStraddlingEqualities()));
    }

    @Test
    public void testMultipleEqualitySetsPredicateGeneration() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        TestEqualityInference.addEquality("a1", "b1", builder);
        TestEqualityInference.addEquality("b1", "c1", builder);
        TestEqualityInference.addEquality("c1", "d1", builder);
        TestEqualityInference.addEquality("a2", "b2", builder);
        TestEqualityInference.addEquality("b2", "c2", builder);
        TestEqualityInference.addEquality("c2", "d2", builder);
        EqualityInference inference = builder.build();
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.variableBeginsWith("a", "b"));
        Assert.assertFalse((boolean)equalityPartition.getScopeEqualities().isEmpty());
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), TestEqualityInference.matchesVariableScope(TestEqualityInference.variableBeginsWith("a", "b"))));
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), (Predicate)EqualityInference.Builder.isInferenceCandidate((Metadata)METADATA)));
        Assert.assertFalse((boolean)equalityPartition.getScopeComplementEqualities().isEmpty());
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), TestEqualityInference.matchesVariableScope((Predicate<VariableReferenceExpression>)Predicates.not(TestEqualityInference.variableBeginsWith("a", "b")))));
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), (Predicate)EqualityInference.Builder.isInferenceCandidate((Metadata)METADATA)));
        Assert.assertFalse((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty());
        Assert.assertTrue((boolean)Iterables.any((Iterable)equalityPartition.getScopeStraddlingEqualities(), TestEqualityInference.matchesStraddlingScope(TestEqualityInference.variableBeginsWith("a", "b"))));
        Assert.assertTrue((boolean)Iterables.all((Iterable)equalityPartition.getScopeStraddlingEqualities(), (Predicate)EqualityInference.Builder.isInferenceCandidate((Metadata)METADATA)));
        EqualityInference newInference = new EqualityInference.Builder(METADATA).addAllEqualities((Iterable)equalityPartition.getScopeEqualities()).addAllEqualities((Iterable)equalityPartition.getScopeComplementEqualities()).addAllEqualities((Iterable)equalityPartition.getScopeStraddlingEqualities()).build();
        EqualityInference.EqualityPartition newEqualityPartition = newInference.generateEqualitiesPartitionedBy(TestEqualityInference.variableBeginsWith("a", "b"));
        Assert.assertEquals(TestEqualityInference.setCopy(equalityPartition.getScopeEqualities()), TestEqualityInference.setCopy(newEqualityPartition.getScopeEqualities()));
        Assert.assertEquals(TestEqualityInference.setCopy(equalityPartition.getScopeComplementEqualities()), TestEqualityInference.setCopy(newEqualityPartition.getScopeComplementEqualities()));
        Assert.assertEquals(TestEqualityInference.setCopy(equalityPartition.getScopeStraddlingEqualities()), TestEqualityInference.setCopy(newEqualityPartition.getScopeStraddlingEqualities()));
    }

    @Test
    public void testSubExpressionRewrites() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        builder.addEquality((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.add("b", "c"));
        builder.addEquality((RowExpression)TestEqualityInference.variable("a2"), TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("b"), TestEqualityInference.add("b", "c")));
        builder.addEquality((RowExpression)TestEqualityInference.variable("a3"), TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.add("b", "c")));
        EqualityInference inference = builder.build();
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.add("b", "c"), TestEqualityInference.variableBeginsWith("a")), (Object)TestEqualityInference.variable("a1"));
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("ax"), TestEqualityInference.add("b", "c")), TestEqualityInference.variableBeginsWith("a")), (Object)TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("ax"), (RowExpression)TestEqualityInference.variable("a1")));
        Assert.assertEquals((Object)inference.rewriteExpression(TestEqualityInference.multiply((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.variableBeginsWith("a")), (Object)TestEqualityInference.variable("a3"));
    }

    @Test
    public void testConstantEqualities() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        TestEqualityInference.addEquality("a1", "b1", builder);
        TestEqualityInference.addEquality("b1", "c1", builder);
        builder.addEquality((RowExpression)TestEqualityInference.variable("c1"), TestEqualityInference.number(1L));
        EqualityInference inference = builder.build();
        Assert.assertEquals((Object)inference.rewriteExpression((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.matchesVariables("a1", "b1")), (Object)TestEqualityInference.number(1L));
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.matchesVariables("a1", "b1"));
        Assert.assertEquals(TestEqualityInference.equalitiesAsSets(equalityPartition.getScopeEqualities()), TestEqualityInference.set(TestEqualityInference.set(TestEqualityInference.variable("a1"), TestEqualityInference.number(1L)), TestEqualityInference.set(TestEqualityInference.variable("b1"), TestEqualityInference.number(1L))));
        Assert.assertEquals(TestEqualityInference.equalitiesAsSets(equalityPartition.getScopeComplementEqualities()), TestEqualityInference.set(TestEqualityInference.set(TestEqualityInference.variable("c1"), TestEqualityInference.number(1L))));
        Assert.assertTrue((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty());
    }

    @Test
    public void testEqualityGeneration() {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        builder.addEquality((RowExpression)TestEqualityInference.variable("a1"), TestEqualityInference.add("b", "c"));
        builder.addEquality((RowExpression)TestEqualityInference.variable("e1"), TestEqualityInference.add("b", "d"));
        TestEqualityInference.addEquality("c", "d", builder);
        EqualityInference inference = builder.build();
        RowExpression scopedCanonical = inference.getScopedCanonical((RowExpression)TestEqualityInference.variable("e1"), TestEqualityInference.variableBeginsWith("a"));
        Assert.assertEquals((Object)scopedCanonical, (Object)TestEqualityInference.variable("a1"));
    }

    @Test(dataProvider="testRowExpressions")
    public void testExpressionsThatMayReturnNullOnNonNullInput(RowExpression candidate) {
        EqualityInference.Builder builder = new EqualityInference.Builder(METADATA);
        builder.extractInferenceCandidates(TestEqualityInference.equals((RowExpression)TestEqualityInference.variable("b"), (RowExpression)TestEqualityInference.variable("x")));
        builder.extractInferenceCandidates(TestEqualityInference.equals((RowExpression)TestEqualityInference.variable("a"), candidate));
        EqualityInference inference = builder.build();
        List equalities = inference.generateEqualitiesPartitionedBy(TestEqualityInference.matchesVariables("b")).getScopeStraddlingEqualities();
        Assert.assertEquals((int)equalities.size(), (int)1);
        Assert.assertTrue((((RowExpression)equalities.get(0)).equals((Object)TestEqualityInference.equals((RowExpression)TestEqualityInference.variable("x"), (RowExpression)TestEqualityInference.variable("b"))) || ((RowExpression)equalities.get(0)).equals((Object)TestEqualityInference.equals((RowExpression)TestEqualityInference.variable("b"), (RowExpression)TestEqualityInference.variable("x"))) ? 1 : 0) != 0);
    }

    @DataProvider(name="testRowExpressions")
    public Object[][] toRowExpressionProvider() {
        return new Object[][]{{ROW_EXPRESSION_TRANSLATOR.translate("try_cast(b AS BIGINT)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)VarcharType.VARCHAR))}, {ROW_EXPRESSION_TRANSLATOR.translate("\"$internal$try\"(() -> b)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}, {ROW_EXPRESSION_TRANSLATOR.translate("nullif(b, 1)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}, {ROW_EXPRESSION_TRANSLATOR.translate("if(b = 1, 1)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}, {ROW_EXPRESSION_TRANSLATOR.translate("b.x", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"x", (Type)BigintType.BIGINT)))))}, {ROW_EXPRESSION_TRANSLATOR.translate("IF(b in (NULL), b)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}, {ROW_EXPRESSION_TRANSLATOR.translate("case b when 1 then 1 END", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}, {ROW_EXPRESSION_TRANSLATOR.translate("case when b is not NULL then 1 END", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}, {ROW_EXPRESSION_TRANSLATOR.translate("ARRAY [NULL][b]", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))}};
    }

    private static Predicate<RowExpression> matchesVariableScope(Predicate<VariableReferenceExpression> variableScope) {
        return expression -> Iterables.all((Iterable)VariablesExtractor.extractUnique((RowExpression)expression), (Predicate)variableScope);
    }

    private static Predicate<RowExpression> matchesStraddlingScope(Predicate<VariableReferenceExpression> variableScope) {
        return expression -> {
            Set variables = VariablesExtractor.extractUnique((RowExpression)expression);
            return Iterables.any((Iterable)variables, (Predicate)variableScope) && Iterables.any((Iterable)variables, (Predicate)Predicates.not((Predicate)variableScope));
        };
    }

    private static void addEquality(String symbol1, String symbol2, EqualityInference.Builder builder) {
        builder.addEquality((RowExpression)TestEqualityInference.variable(symbol1), (RowExpression)TestEqualityInference.variable(symbol2));
    }

    private static RowExpression someExpression(String symbol1, String symbol2) {
        return TestEqualityInference.someExpression((RowExpression)TestEqualityInference.variable(symbol1), (RowExpression)TestEqualityInference.variable(symbol2));
    }

    private static RowExpression someExpression(RowExpression expression1, RowExpression expression2) {
        return TestEqualityInference.compare(OperatorType.GREATER_THAN, expression1, expression2);
    }

    static RowExpression add(String symbol1, String symbol2) {
        return TestEqualityInference.arithmeticOperation(OperatorType.ADD, (RowExpression)TestEqualityInference.variable(symbol1), (RowExpression)TestEqualityInference.variable(symbol2));
    }

    static RowExpression multiply(String symbol1, String symbol2) {
        return TestEqualityInference.arithmeticOperation(OperatorType.MULTIPLY, (RowExpression)TestEqualityInference.variable(symbol1), (RowExpression)TestEqualityInference.variable(symbol2));
    }

    static RowExpression multiply(RowExpression expression1, RowExpression expression2) {
        return TestEqualityInference.arithmeticOperation(OperatorType.MULTIPLY, expression1, expression2);
    }

    private static RowExpression equals(String symbol1, String symbol2) {
        return TestEqualityInference.compare(OperatorType.EQUAL, (RowExpression)TestEqualityInference.variable(symbol1), (RowExpression)TestEqualityInference.variable(symbol2));
    }

    private static RowExpression equals(RowExpression expression1, RowExpression expression2) {
        return TestEqualityInference.compare(OperatorType.EQUAL, expression1, expression2);
    }

    static VariableReferenceExpression variable(String name) {
        return Expressions.variable((String)name, (Type)BigintType.BIGINT);
    }

    static RowExpression number(long number) {
        return Expressions.constant((Object)number, (Type)BigintType.BIGINT);
    }

    private static Predicate<VariableReferenceExpression> matchesVariables(String ... variables) {
        return TestEqualityInference.matchesVariables(Arrays.asList(variables));
    }

    private static Predicate<VariableReferenceExpression> matchesVariables(Collection<String> variables) {
        Set symbolSet = (Set)variables.stream().map(name -> new VariableReferenceExpression(Optional.empty(), name, (Type)BigintType.BIGINT)).collect(ImmutableSet.toImmutableSet());
        return Predicates.in((Collection)symbolSet);
    }

    private static Predicate<VariableReferenceExpression> variableBeginsWith(String ... prefixes) {
        return TestEqualityInference.variableBeginsWith(Arrays.asList(prefixes));
    }

    private static Predicate<VariableReferenceExpression> variableBeginsWith(Iterable<String> prefixes) {
        return variable -> {
            for (String prefix : prefixes) {
                if (!variable.getName().startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private static Set<Set<RowExpression>> equalitiesAsSets(Iterable<RowExpression> expressions) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RowExpression expression : expressions) {
            builder.add(TestEqualityInference.equalityAsSet(expression));
        }
        return builder.build();
    }

    private static Set<RowExpression> equalityAsSet(RowExpression expression) {
        Preconditions.checkArgument((boolean)TestEqualityInference.isOperation(expression, OperatorType.EQUAL));
        return ImmutableSet.of((Object)TestEqualityInference.getLeft(expression), (Object)TestEqualityInference.getRight(expression));
    }

    private static <E> Set<E> set(E ... elements) {
        return TestEqualityInference.setCopy(Arrays.asList(elements));
    }

    private static <E> Set<E> setCopy(Iterable<E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    static CallExpression compare(OperatorType type, RowExpression left, RowExpression right) {
        return Expressions.call((String)type.getFunctionName().getObjectName(), (FunctionHandle)METADATA.getFunctionAndTypeManager().resolveOperator(type, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }

    private static RowExpression getLeft(RowExpression expression) {
        Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
        return (RowExpression)((CallExpression)expression).getArguments().get(0);
    }

    private static RowExpression getRight(RowExpression expression) {
        Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
        return (RowExpression)((CallExpression)expression).getArguments().get(1);
    }

    private static CallExpression arithmeticOperation(OperatorType type, RowExpression left, RowExpression right) {
        return Expressions.call((String)type.getFunctionName().getObjectName(), (FunctionHandle)METADATA.getFunctionAndTypeManager().resolveOperator(type, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()})), (Type)left.getType(), (RowExpression[])new RowExpression[]{left, right});
    }

    private static boolean isOperation(RowExpression expression, OperatorType type) {
        if (expression instanceof CallExpression) {
            CallExpression call = (CallExpression)expression;
            Optional expressionOperatorType = METADATA.getFunctionAndTypeManager().getFunctionMetadata(call.getFunctionHandle()).getOperatorType();
            if (expressionOperatorType.isPresent()) {
                return expressionOperatorType.get() == type;
            }
        }
        return false;
    }
}

