/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import org.testng.annotations.Test;

public class TestOrderBy
extends BasePlanTest {
    @Test
    public void testRedundantOrderByInSubquery() {
        this.assertPlan("SELECT * FROM (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x)", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testRequiredOrderByInSubquery() {
        this.assertPlan("SELECT * FROM (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x LIMIT 1)", PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testRedundantOrderByInScalarSubquery() {
        this.assertPlan("SELECT (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x) FROM (VALUES 10)", PlanMatchPattern.output(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testRequiredOrderByInScalarSubquery() {
        this.assertPlan("SELECT (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x LIMIT 1) FROM (VALUES 10)", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testRequiredOrderByInUnion() {
        this.assertPlan("VALUES 1 UNION ALL VALUES 2 ORDER BY 1 ", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testRedundantOrderByInUnion() {
        this.assertPlan("SELECT * FROM (   VALUES 1    UNION ALL    VALUES 2    ORDER BY 1 )", PlanMatchPattern.output(PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }
}

