/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.TestPredicatePushdown;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPredicatePushdownWithDynamicFilter
extends TestPredicatePushdown {
    TestPredicatePushdownWithDynamicFilter() {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)"true"));
    }

    @Override
    @Test
    public void testNonStraddlingJoinExpression() {
        this.assertPlan("SELECT * FROM orders JOIN lineitem ON orders.orderkey = lineitem.orderkey AND cast(lineitem.linenumber AS varchar) = '2'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_LINENUMBER", (Object)"linenumber")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))));
    }

    @Override
    @Test
    public void testEqualPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = 2)", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))))));
    }

    @Override
    @Test
    public void testEqualsPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "expr_6", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_6", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))))));
    }

    @Override
    @Test
    public void testNonDeterministicPredicateDoesNotPropagateFromFilteringSideToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = random(5))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.filter("ORDERS_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))))));
    }

    @Override
    public void testDomainFiltersAppliedOnSemiJoinOutputFilterHaveNoImpact() {
        Session generateDomainFilterSession = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("generate_domain_filters", "true").build();
        this.assertPlan(" SELECT        ps.suppkey      FROM        partsupp ps     WHERE        ps.partkey IN (         SELECT            p.partkey          FROM            part p         WHERE            p.name like 'forest%'       )        AND ps.availqty > (         SELECT            0.5*sum(l.quantity)          FROM            lineitem l         WHERE            l.partkey = ps.partkey            AND l.suppkey = ps.suppkey            AND l.shipdate >= date('1994-01-01')           AND l.shipdate < date('1994-01-01') + interval '1' YEAR       )", generateDomainFilterSession, PlanMatchPattern.output(PlanMatchPattern.join(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("SEMI_JOIN_RESULT AND (SEMI_JOIN_RESULT = BOOLEAN'true')", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("PS_PARTKEY", "P_PART", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"PS_PARTKEY", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PART", (Object)"partkey"))))))))));
    }
}

