/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowExpressionVariableInliner {
    private static final FunctionHandle TEST_FUNCTION = new TestFunctionHandle();

    @Test
    public void testInlineVariable() {
        Assert.assertEquals((Object)RowExpressionVariableInliner.inlineVariables((Map)ImmutableMap.of((Object)this.variable("a"), (Object)this.variable("b")), (RowExpression)this.variable("a")), (Object)this.variable("b"));
    }

    @Test
    public void testInlineLambda() {
        Assert.assertEquals((Object)RowExpressionVariableInliner.inlineVariables((Map)ImmutableMap.of((Object)this.variable("a"), (Object)this.variable("b"), (Object)this.variable("lambda_argument"), (Object)this.variable("c")), (RowExpression)new CallExpression("apply", TEST_FUNCTION, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)this.variable("a"), (Object)new LambdaDefinitionExpression(Optional.empty(), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)"lambda_argument"), (RowExpression)new CallExpression("add", TEST_FUNCTION, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)this.variable("lambda_argument"), (Object)this.variable("a"))))))), (Object)new CallExpression("apply", TEST_FUNCTION, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)this.variable("b"), (Object)new LambdaDefinitionExpression(Optional.empty(), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)"lambda_argument"), (RowExpression)new CallExpression("add", TEST_FUNCTION, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)this.variable("lambda_argument"), (Object)this.variable("b")))))));
    }

    private VariableReferenceExpression variable(String name) {
        return new VariableReferenceExpression(Optional.empty(), name, (Type)BigintType.BIGINT);
    }

    private static class TestFunctionHandle
    implements FunctionHandle {
        private TestFunctionHandle() {
        }

        public CatalogSchemaName getCatalogSchemaName() {
            return QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("a", "b"), (String)"c").getCatalogSchemaName();
        }

        public String getName() {
            return "a.b.c";
        }

        public FunctionKind getKind() {
            return FunctionKind.SCALAR;
        }
    }
}

