/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.sql.planner.TestTableConstraintsMetadata;
import com.facebook.presto.tpch.ColumnNaming;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.tpch.TpchNodePartitioningProvider;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.TpchTransactionHandle;
import java.util.Map;

public class TestTableConstraintsConnectorFactory
extends TpchConnectorFactory {
    public TestTableConstraintsConnectorFactory(int defaultSplitsPerNode) {
        super(defaultSplitsPerNode);
    }

    public Connector create(final String catalogName, final Map<String, String> properties, ConnectorContext context) {
        final int splitsPerNode = super.getSplitsPerNode(properties);
        final ColumnNaming columnNaming = ColumnNaming.valueOf((String)properties.getOrDefault("tpch.column-naming", ColumnNaming.SIMPLIFIED.name()).toUpperCase());
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new TestTableConstraintsMetadata(catalogName, columnNaming, TestTableConstraintsConnectorFactory.this.isPredicatePushdownEnabled(), TestTableConstraintsConnectorFactory.this.isPartitioningEnabled(properties));
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider();
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }
}

