/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.tpch.ColumnNaming;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TestTableConstraintsMetadata
extends TpchMetadata {
    public TestTableConstraintsMetadata(String connectorId, ColumnNaming columnNaming, boolean predicatePushdownEnabled, boolean partitioningEnabled) {
        super(connectorId, columnNaming, predicatePushdownEnabled, partitioningEnabled);
    }

    private static ConnectorTableMetadata getTableConstraintsMetadata(String schemaName, TpchTable<?> tpchTable, ColumnNaming columnNaming) {
        ImmutableList.Builder columns = ImmutableList.builder();
        HashMap<String, TpchColumnHandle> nameToHandleMap = new HashMap<String, TpchColumnHandle>();
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add((Object)new ColumnMetadata(columnNaming.getName(column), TestTableConstraintsMetadata.getPrestoType((TpchColumn)column), false, null, null, false, Collections.emptyMap()));
            nameToHandleMap.put(columnNaming.getName(column), new TpchColumnHandle(columnNaming.getName(column), TestTableConstraintsMetadata.getPrestoType((TpchColumn)column)));
        }
        columns.add((Object)new ColumnMetadata("row_number", (Type)BigintType.BIGINT, null, true));
        SchemaTableName tableName = new SchemaTableName(schemaName, tpchTable.getTableName());
        List<TableConstraint<String>> constraints = TestTableConstraintsMetadata.getTableConstraints(tpchTable.getTableName());
        return new ConnectorTableMetadata(tableName, (List)columns.build(), Collections.emptyMap(), Optional.empty(), constraints, nameToHandleMap);
    }

    private static List<TableConstraint<String>> getTableConstraints(String tableName) {
        PrimaryKeyConstraint pk;
        ArrayList<TableConstraint<String>> constraints = new ArrayList<TableConstraint<String>>();
        TpchTableConstraints tpchProperties = new TpchTableConstraints();
        for (LinkedHashSet<String> pkcols : tpchProperties.lookupPK(tableName)) {
            pk = new PrimaryKeyConstraint(Optional.of(tableName + "pk"), pkcols, false, true, false);
            constraints.add((TableConstraint<String>)pk);
        }
        for (LinkedHashSet<String> pkcols : tpchProperties.lookupUKs(tableName)) {
            pk = new UniqueConstraint(Optional.of(tableName + "pk"), pkcols, false, true, false);
            constraints.add((TableConstraint<String>)pk);
        }
        return constraints;
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        TpchTable tpchTable = TpchTable.getTable((String)tpchTableHandle.getTableName());
        String schemaName = TpchMetadata.scaleFactorSchemaName((double)tpchTableHandle.getScaleFactor());
        return TestTableConstraintsMetadata.getTableConstraintsMetadata(schemaName, tpchTable, this.getColumnNaming());
    }

    private static class TpchTableConstraints {
        private final String customerTableName = "customer";
        private final String lineitemTableName = "lineitem";
        private final String ordersTableName = "orders";
        private final String partTableName = "part";
        private final String suppliersTableName = "supplier";
        private final String partsuppTableName = "partsupp";
        private final String nationTableName = "nation";
        private final String regionTableName = "region";
        private final LinkedHashSet<String> customerPK = new LinkedHashSet();
        private final LinkedHashSet<String> lineItemPK = new LinkedHashSet();
        private final LinkedHashSet<String> ordersPK = new LinkedHashSet();
        private final LinkedHashSet<String> partPK = new LinkedHashSet();
        private final LinkedHashSet<String> suppliersPK = new LinkedHashSet();
        private final LinkedHashSet<String> partsuppPK = new LinkedHashSet();
        private final LinkedHashSet<String> nationPK = new LinkedHashSet();
        private final LinkedHashSet<String> regionPK = new LinkedHashSet();
        private final Map<String, List<LinkedHashSet<String>>> tpchPKLookup = new HashMap<String, List<LinkedHashSet<String>>>();
        private final LinkedHashSet<String> ordersKey1 = new LinkedHashSet();
        private final LinkedHashSet<String> ordersKey2 = new LinkedHashSet();
        private final Map<String, List<LinkedHashSet<String>>> tpchUKLookup = new HashMap<String, List<LinkedHashSet<String>>>();

        public TpchTableConstraints() {
            ArrayList<LinkedHashSet<String>> customerKeys = new ArrayList<LinkedHashSet<String>>();
            this.customerPK.add("custkey");
            customerKeys.add(this.customerPK);
            this.tpchPKLookup.put("customer", customerKeys);
            ArrayList<LinkedHashSet<String>> ordersKeys = new ArrayList<LinkedHashSet<String>>();
            this.ordersPK.add("orderkey");
            ordersKeys.add(this.ordersPK);
            this.tpchPKLookup.put("orders", ordersKeys);
            ArrayList<LinkedHashSet<String>> ordersUniqueKeys = new ArrayList<LinkedHashSet<String>>();
            this.ordersKey1.add("orderkey");
            this.ordersKey1.add("custkey");
            ordersUniqueKeys.add(this.ordersKey1);
            this.ordersKey2.add("orderkey");
            this.ordersKey2.add("orderdate");
            ordersUniqueKeys.add(this.ordersKey2);
            this.tpchUKLookup.put("orders", ordersUniqueKeys);
            ArrayList<LinkedHashSet<String>> lineitemKeys = new ArrayList<LinkedHashSet<String>>();
            this.lineItemPK.add("linenumber");
            this.lineItemPK.add("orderkey");
            lineitemKeys.add(this.lineItemPK);
            this.tpchPKLookup.put("lineitem", lineitemKeys);
            ArrayList<LinkedHashSet<String>> partKeys = new ArrayList<LinkedHashSet<String>>();
            this.partPK.add("partkey");
            partKeys.add(this.partPK);
            this.tpchPKLookup.put("part", partKeys);
            ArrayList<LinkedHashSet<String>> suppliersKeys = new ArrayList<LinkedHashSet<String>>();
            this.suppliersPK.add("suppkey");
            suppliersKeys.add(this.suppliersPK);
            this.tpchPKLookup.put("supplier", suppliersKeys);
            ArrayList<LinkedHashSet<String>> partsuppKeys = new ArrayList<LinkedHashSet<String>>();
            this.partsuppPK.add("partkey");
            this.partsuppPK.add("suppkey");
            partsuppKeys.add(this.partsuppPK);
            this.tpchPKLookup.put("partsupp", partsuppKeys);
            ArrayList<LinkedHashSet<String>> nationKeys = new ArrayList<LinkedHashSet<String>>();
            this.nationPK.add("nationkey");
            nationKeys.add(this.nationPK);
            this.tpchPKLookup.put("nation", nationKeys);
            ArrayList<LinkedHashSet<String>> regionKeys = new ArrayList<LinkedHashSet<String>>();
            this.regionPK.add("regionkey");
            regionKeys.add(this.regionPK);
            this.tpchPKLookup.put("region", regionKeys);
        }

        public List<LinkedHashSet<String>> lookupPK(String tableName) {
            return this.tpchPKLookup.containsKey(tableName) ? this.tpchPKLookup.get(tableName) : Collections.emptyList();
        }

        public List<LinkedHashSet<String>> lookupUKs(String tableName) {
            return this.tpchUKLookup.containsKey(tableName) ? this.tpchUKLookup.get(tableName) : Collections.emptyList();
        }
    }
}

