/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTypeValidator {
    private static final TableHandle TEST_TABLE_HANDLE = new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final TypeValidator TYPE_VALIDATOR = new TypeValidator();
    private static final FunctionAndTypeManager FUNCTION_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final FunctionHandle SUM = FUNCTION_MANAGER.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final FunctionHandle APPROX_PERCENTILE = FUNCTION_MANAGER.lookupFunction("approx_percentile", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}));
    private static final TestingRowExpressionTranslator translator = new TestingRowExpressionTranslator();
    private VariableAllocator variableAllocator;
    private TableScanNode baseTableScan;
    private VariableReferenceExpression variableA;
    private VariableReferenceExpression variableB;
    private VariableReferenceExpression variableC;
    private VariableReferenceExpression variableD;
    private VariableReferenceExpression variableE;
    private VariableReferenceExpression variableC5;

    @BeforeClass
    public void setUp() {
        this.variableAllocator = new VariableAllocator();
        this.variableA = this.variableAllocator.newVariable("a", (Type)BigintType.BIGINT);
        this.variableB = this.variableAllocator.newVariable("b", (Type)IntegerType.INTEGER);
        this.variableC = this.variableAllocator.newVariable("c", (Type)DoubleType.DOUBLE);
        this.variableD = this.variableAllocator.newVariable("d", (Type)DateType.DATE);
        this.variableE = this.variableAllocator.newVariable("e", (Type)VarcharType.createVarcharType((int)3));
        this.variableC5 = this.variableAllocator.newVariable("c_5", (Type)VarbinaryType.VARBINARY);
        ImmutableMap assignments = ImmutableMap.builder().put((Object)this.variableA, (Object)new TestingMetadata.TestingColumnHandle("a")).put((Object)this.variableB, (Object)new TestingMetadata.TestingColumnHandle("b")).put((Object)this.variableC, (Object)new TestingMetadata.TestingColumnHandle("c")).put((Object)this.variableD, (Object)new TestingMetadata.TestingColumnHandle("d")).put((Object)this.variableE, (Object)new TestingMetadata.TestingColumnHandle("e")).build();
        this.baseTableScan = new TableScanNode(Optional.empty(), TestTypeValidator.newId(), TEST_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments, TupleDomain.all(), TupleDomain.all());
    }

    @Test
    public void testValidProject() {
        Cast expression1 = new Cast((Expression)new SymbolReference(this.variableB.getName()), "bigint");
        Cast expression2 = new Cast((Expression)new SymbolReference(this.variableC.getName()), "bigint");
        Assignments assignments = Assignments.builder().put(PlannerUtils.newVariable((VariableAllocator)this.variableAllocator, (Expression)expression1, (Type)BigintType.BIGINT), translator.translate((Expression)expression1, TypeProvider.fromVariables((Collection)ImmutableList.of((Object)this.variableB)))).put(PlannerUtils.newVariable((VariableAllocator)this.variableAllocator, (Expression)expression2, (Type)BigintType.BIGINT), translator.translate((Expression)expression2, TypeProvider.fromVariables((Collection)ImmutableList.of((Object)this.variableC)))).build();
        ProjectNode node = new ProjectNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, assignments);
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidUnion() {
        VariableReferenceExpression output = this.variableAllocator.newVariable("output", (Type)DateType.DATE);
        UnionNode node = new UnionNode(Optional.empty(), TestTypeValidator.newId(), (List)ImmutableList.of((Object)this.baseTableScan, (Object)this.baseTableScan), (List)ImmutableList.of((Object)output), (Map)ImmutableMap.of((Object)output, (Object)ImmutableList.of((Object)this.variableD, (Object)this.variableD)));
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidWindow() {
        VariableReferenceExpression windowVariable = this.variableAllocator.newVariable("sum", (Type)DoubleType.DOUBLE);
        FunctionHandle functionHandle = FUNCTION_MANAGER.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
        WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function function = new WindowNode.Function(Expressions.call((String)"sum", (FunctionHandle)functionHandle, (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[]{this.variableC}), frame, false);
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of(), Optional.empty());
        WindowNode node = new WindowNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, specification, (Map)ImmutableMap.of((Object)windowVariable, (Object)function), Optional.empty(), (Set)ImmutableSet.of(), 0);
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidAggregation() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("sum", (Type)DoubleType.DOUBLE);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("sum", SUM, (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)this.variableC)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)this.variableA, (Object)this.variableB)), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidIntermediateAggregation() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("approx_percentile", (Type)VarbinaryType.VARBINARY);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("approx_percentile", APPROX_PERCENTILE, (Type)VarbinaryType.VARBINARY, (List)ImmutableList.of((Object)this.variableC5)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.INTERMEDIATE, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidPartialAggregation() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("approx_percentile", (Type)VarbinaryType.VARBINARY);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("approx_percentile", APPROX_PERCENTILE, (Type)VarbinaryType.VARBINARY, (List)ImmutableList.of((Object)this.variableC)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.PARTIAL, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test
    public void testValidTypeOnlyCoercion() {
        Cast expression = new Cast((Expression)new SymbolReference(this.variableB.getName()), "bigint");
        Assignments assignments = Assignments.builder().put(PlannerUtils.newVariable((VariableAllocator)this.variableAllocator, (Expression)expression, (Type)BigintType.BIGINT), translator.translate((Expression)expression, TypeProvider.fromVariables((Collection)ImmutableList.of((Object)this.variableB)))).put(PlannerUtils.newVariable((VariableAllocator)this.variableAllocator, (Expression)new SymbolReference(this.variableE.getName()), (Type)VarcharType.VARCHAR), (RowExpression)this.variableE).build();
        ProjectNode node = new ProjectNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, assignments);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of variable 'expr(_[0-9]+)?' is expected to be bigint, but the actual type is integer")
    public void testInvalidProject() {
        Cast expression1 = new Cast((Expression)new SymbolReference(this.variableB.getName()), "integer");
        Cast expression2 = new Cast((Expression)new SymbolReference(this.variableA.getName()), "integer");
        Assignments assignments = Assignments.builder().put(PlannerUtils.newVariable((VariableAllocator)this.variableAllocator, (Expression)expression1, (Type)BigintType.BIGINT), translator.translate((Expression)expression1, TypeProvider.fromVariables((Collection)ImmutableList.of((Object)this.variableB)))).put(PlannerUtils.newVariable((VariableAllocator)this.variableAllocator, (Expression)expression1, (Type)IntegerType.INTEGER), translator.translate((Expression)expression2, TypeProvider.fromVariables((Collection)ImmutableList.of((Object)this.variableA)))).build();
        ProjectNode node = new ProjectNode(TestTypeValidator.newId(), (PlanNode)this.baseTableScan, assignments);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Return type for intermediate aggregation must be the same as the type of its single argument: expected 'varbinary', got 'double'")
    public void testInvalidIntermediateAggregationReturnType() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("approx_percentile", (Type)VarbinaryType.VARBINARY);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("approx_percentile", APPROX_PERCENTILE, (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)this.variableC5)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.INTERMEDIATE, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of variable 'approx_pct_part_invalid' is expected to be varbinary, but the actual type is double")
    public void testInvalidPartialAggregationReturnType() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("approx_pct_part_invalid", (Type)VarbinaryType.VARBINARY);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("approx_percentile", APPROX_PERCENTILE, (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)this.variableC)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.PARTIAL, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Expected input types are \\[double\\] but getting \\[bigint\\]")
    public void testInvalidAggregationFunctionCall() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("sum", (Type)DoubleType.DOUBLE);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("sum", SUM, (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)this.variableA)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)this.variableA, (Object)this.variableB)), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of variable 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidAggregationFunctionSignature() {
        VariableReferenceExpression aggregationVariable = this.variableAllocator.newVariable("sum", (Type)DoubleType.DOUBLE);
        AggregationNode node = new AggregationNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, (Map)ImmutableMap.of((Object)aggregationVariable, (Object)new AggregationNode.Aggregation(new CallExpression("sum", FUNCTION_MANAGER.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)this.variableC)), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)this.variableA, (Object)this.variableB)), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of variable 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidWindowFunctionCall() {
        VariableReferenceExpression windowVariable = this.variableAllocator.newVariable("sum", (Type)DoubleType.DOUBLE);
        FunctionHandle functionHandle = FUNCTION_MANAGER.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
        WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function function = new WindowNode.Function(Expressions.call((String)"sum", (FunctionHandle)functionHandle, (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{this.variableA}), frame, false);
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of(), Optional.empty());
        WindowNode node = new WindowNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, specification, (Map)ImmutableMap.of((Object)windowVariable, (Object)function), Optional.empty(), (Set)ImmutableSet.of(), 0);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of variable 'sum(_[0-9]+)?' is expected to be double, but the actual type is bigint")
    public void testInvalidWindowFunctionSignature() {
        VariableReferenceExpression windowVariable = this.variableAllocator.newVariable("sum", (Type)DoubleType.DOUBLE);
        FunctionHandle functionHandle = FUNCTION_MANAGER.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function function = new WindowNode.Function(Expressions.call((String)"sum", (FunctionHandle)functionHandle, (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{this.variableC}), frame, false);
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of(), Optional.empty());
        WindowNode node = new WindowNode(Optional.empty(), TestTypeValidator.newId(), (PlanNode)this.baseTableScan, specification, (Map)ImmutableMap.of((Object)windowVariable, (Object)function), Optional.empty(), (Set)ImmutableSet.of(), 0);
        this.assertTypesValid((PlanNode)node);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="type of variable 'output(_[0-9]+)?' is expected to be date, but the actual type is bigint")
    public void testInvalidUnion() {
        VariableReferenceExpression output = this.variableAllocator.newVariable("output", (Type)DateType.DATE);
        UnionNode node = new UnionNode(Optional.empty(), TestTypeValidator.newId(), (List)ImmutableList.of((Object)this.baseTableScan, (Object)this.baseTableScan), (List)ImmutableList.of((Object)output), (Map)ImmutableMap.of((Object)output, (Object)ImmutableList.of((Object)this.variableD, (Object)this.variableA)));
        this.assertTypesValid((PlanNode)node);
    }

    private void assertTypesValid(PlanNode node) {
        TYPE_VALIDATOR.validate(node, SessionTestUtils.TEST_SESSION, (Metadata)MetadataManager.createTestMetadataManager(), WarningCollector.NOOP);
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }
}

