/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExpressionMatcher
implements RvalueMatcher {
    private final String sql;
    private final ParsingOptions.DecimalLiteralTreatment decimalLiteralTreatment;
    private final Expression expression;

    public ExpressionMatcher(String expression) {
        this.sql = Objects.requireNonNull(expression);
        this.decimalLiteralTreatment = ParsingOptions.DecimalLiteralTreatment.REJECT;
        this.expression = this.expression(Objects.requireNonNull(expression));
    }

    public ExpressionMatcher(String expression, ParsingOptions.DecimalLiteralTreatment decimalLiteralTreatment) {
        this.sql = Objects.requireNonNull(expression);
        this.decimalLiteralTreatment = decimalLiteralTreatment;
        this.expression = this.expression(Objects.requireNonNull(expression));
    }

    public ExpressionMatcher(Expression expression) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.sql = Objects.requireNonNull(expression).toString();
        this.decimalLiteralTreatment = ParsingOptions.DecimalLiteralTreatment.REJECT;
    }

    private Expression expression(String sql) {
        SqlParser parser = new SqlParser();
        ParsingOptions.Builder builder = ParsingOptions.builder();
        builder.setDecimalLiteralTreatment(this.decimalLiteralTreatment);
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)parser.createExpression(sql, builder.build()));
    }

    @Override
    public Optional<VariableReferenceExpression> getAssignedVariable(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<VariableReferenceExpression> result = Optional.empty();
        ImmutableList.Builder matchesBuilder = ImmutableList.builder();
        Map<VariableReferenceExpression, RowExpression> assignments = ExpressionMatcher.getAssignments(node);
        if (assignments == null) {
            return result;
        }
        Iterator<Map.Entry<VariableReferenceExpression, RowExpression>> iterator = assignments.entrySet().iterator();
        while (iterator.hasNext()) {
            RowExpressionVerifier verifier = new RowExpressionVerifier(symbolAliases, metadata, session);
            Map.Entry<VariableReferenceExpression, RowExpression> assignment = iterator.next();
            RowExpression rightValue = assignment.getValue();
            if (!((Boolean)verifier.process((Node)this.expression, rightValue)).booleanValue()) continue;
            result = Optional.of(assignment.getKey());
            matchesBuilder.add((Object)rightValue);
        }
        HashSet matches = new HashSet(matchesBuilder.build());
        Preconditions.checkState((matches.size() < 2 ? 1 : 0) != 0, (String)"Ambiguous expression %s matches multiple assignments", (Object)this.expression, (Object)matches.stream().map(Object::toString).collect(Collectors.joining(", ")));
        return result;
    }

    private static Map<VariableReferenceExpression, RowExpression> getAssignments(PlanNode node) {
        if (node instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)node;
            return projectNode.getAssignments().getMap();
        }
        if (node instanceof ApplyNode) {
            ApplyNode applyNode = (ApplyNode)node;
            return applyNode.getSubqueryAssignments().getMap();
        }
        if (node instanceof GroupIdNode) {
            GroupIdNode groupIdNode = (GroupIdNode)node;
            return groupIdNode.getGroupingColumns().entrySet().stream().collect(Collectors.toMap(x -> (VariableReferenceExpression)x.getKey(), x -> (RowExpression)x.getValue()));
        }
        return null;
    }

    public String toString() {
        return this.sql;
    }
}

