/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;

public class StatsConfidenceLevelMatcher
implements Matcher {
    private final SourceInfo.ConfidenceLevel expectedConfidenceLevel;

    StatsConfidenceLevelMatcher(SourceInfo.ConfidenceLevel expectedConfidenceLevel) {
        this.expectedConfidenceLevel = expectedConfidenceLevel;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return new MatchResult(stats.getStats(node).confidenceLevel() == this.expectedConfidenceLevel);
    }

    public String toString() {
        return "expectedConfidenceLevel(" + this.expectedConfidenceLevel + ")";
    }
}

