/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;

public class StatsOutputRowCountMatcher
implements Matcher {
    private final boolean exactMatch;
    private final double expectedOutputRowCount;
    private final String expectedSourceInfo;

    StatsOutputRowCountMatcher(double expectedOutputRowCount) {
        this(expectedOutputRowCount, true, null);
    }

    StatsOutputRowCountMatcher(double expectedOutputRowCount, String expectedSourceInfo) {
        this(expectedOutputRowCount, true, expectedSourceInfo);
    }

    StatsOutputRowCountMatcher(boolean exactMatch, String expectedSourceInfo) {
        this(Double.NaN, exactMatch, expectedSourceInfo);
    }

    StatsOutputRowCountMatcher(double expectedOutputRowCount, boolean exactMatch, String expectedSourceInfo) {
        this.exactMatch = exactMatch;
        this.expectedOutputRowCount = expectedOutputRowCount;
        this.expectedSourceInfo = expectedSourceInfo;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        PlanNodeStatsEstimate estimate = stats.getStats(node);
        if (this.expectedSourceInfo != null && !this.expectedSourceInfo.equals(estimate.getSourceInfo().getSourceInfoName())) {
            return new MatchResult(false);
        }
        if (!this.exactMatch) {
            return new MatchResult(true);
        }
        return new MatchResult(Double.compare(estimate.getOutputRowCount(), this.expectedOutputRowCount) == 0);
    }

    public String toString() {
        return "expectedOutputRowCount(" + (this.exactMatch ? Double.valueOf(this.expectedOutputRowCount) : "not exact") + ")" + (this.expectedSourceInfo == null ? "" : "[" + this.expectedSourceInfo + "]");
    }
}

