/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.BaseStrictSymbolsMatcher;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class StrictAssignedSymbolsMatcher
extends BaseStrictSymbolsMatcher {
    private final Collection<? extends RvalueMatcher> getExpected;

    public StrictAssignedSymbolsMatcher(Function<PlanNode, Set<VariableReferenceExpression>> getActual, Collection<? extends RvalueMatcher> getExpected) {
        super(getActual);
        this.getExpected = Objects.requireNonNull(getExpected, "getExpected is null");
    }

    @Override
    protected Set<VariableReferenceExpression> getExpectedVariables(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        ImmutableSet.Builder expected = ImmutableSet.builder();
        for (RvalueMatcher rvalueMatcher : this.getExpected) {
            Optional<VariableReferenceExpression> assigned = rvalueMatcher.getAssignedVariable(node, session, metadata, symbolAliases);
            if (!assigned.isPresent()) {
                return null;
            }
            expected.add((Object)assigned.get());
        }
        return expected.build();
    }

    public static Function<PlanNode, Set<VariableReferenceExpression>> actualAssignments() {
        return node -> ((ProjectNode)node).getAssignments().getVariables();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exact assignments", this.getExpected).toString();
    }
}

