/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.assertions.AggregationMatcher;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UnnestMatcher
implements Matcher {
    private final Map<String, List<String>> unnestMap;

    public UnnestMatcher(Map<String, List<String>> unnestMap) {
        this.unnestMap = ImmutableMap.copyOf(unnestMap);
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof UnnestNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        UnnestNode unnestNode = (UnnestNode)node;
        if (this.unnestMap.size() != unnestNode.getUnnestVariables().size()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.unnestMap.keySet(), unnestNode.getUnnestVariables().keySet(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        List expectedUnnestVariables = (List)this.unnestMap.values().stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        List actualUnnestVariables = (List)unnestNode.getUnnestVariables().values().stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (expectedUnnestVariables.size() != actualUnnestVariables.size()) {
            return MatchResult.NO_MATCH;
        }
        SymbolAliases.Builder builder = SymbolAliases.builder();
        for (int i = 0; i < expectedUnnestVariables.size(); ++i) {
            builder.put((String)expectedUnnestVariables.get(i), ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)((VariableReferenceExpression)actualUnnestVariables.get(i))));
        }
        return MatchResult.match(builder.build());
    }
}

