/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.InlineProjectionsOnValues;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import org.testng.annotations.Test;

public class TestInlineProjectionsOnValues
extends BaseRuleTest {
    public TestInlineProjectionsOnValues() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOn() {
        this.tester().assertThat((Rule)new InlineProjectionsOnValues(this.tester.getMetadata().getFunctionAndTypeManager())).setSystemProperty("inline_projections_on_values", "true").on(p -> p.project((PlanNode)p.project((PlanNode)p.values(p.getIdAllocator().getNextId(), p.variable("a")), PlanBuilder.assignment(p.variable("c"), (RowExpression)p.variable("a"))), PlanBuilder.assignment(p.variable("d"), (RowExpression)p.variable("c")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnWithNonDeterministicFunction() {
        this.tester().assertThat((Rule)new InlineProjectionsOnValues(this.tester.getMetadata().getFunctionAndTypeManager())).setSystemProperty("inline_projections_on_values", "true").on(p -> p.project((PlanNode)p.values(p.getIdAllocator().getNextId(), p.variable("a")), PlanBuilder.assignment(p.variable("b"), (RowExpression)Expressions.call((FunctionAndTypeManager)this.tester.getMetadata().getFunctionAndTypeManager(), (String)"random", (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{p.variable("a")})))).doesNotFire();
    }

    @Test
    public void testFireOnProjectFollowedByValues() {
        this.tester().assertThat((Rule)new InlineProjectionsOnValues(this.tester.getMetadata().getFunctionAndTypeManager())).setSystemProperty("inline_projections_on_values", "true").on(p -> p.project((PlanNode)p.values(p.getIdAllocator().getNextId(), p.variable("a")), PlanBuilder.assignment(p.variable("c"), (RowExpression)p.variable("a")))).matches(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]));
    }
}

