/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.NoopSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.testing.InMemoryFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionExecutor;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.InlineSqlFunctions;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCardinalityMap;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestInlineSqlFunctions
extends BaseRuleTest {
    private static final RoutineCharacteristics.Language JAVA = new RoutineCharacteristics.Language("java");
    private static final SqlInvokedFunction SQL_FUNCTION_SQUARE = new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"square"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "square", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN x * x", FunctionVersion.notVersioned());
    private static final SqlInvokedFunction THRIFT_FUNCTION_FOO = new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"foo"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "thrift function foo", RoutineCharacteristics.builder().setLanguage(JAVA).setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", FunctionVersion.notVersioned());
    private static final SqlInvokedFunction SQL_FUNCTION_ADD_1_TO_INT_ARRAY = new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"add_1_int"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"array(int)"))), TypeSignature.parseTypeSignature((String)"array(int)"), "add 1 to all elements of array", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN transform(x, x -> x + 1)", FunctionVersion.notVersioned());
    private static final SqlInvokedFunction SQL_FUNCTION_ADD_1_TO_BIGINT_ARRAY = new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"add_1_bigint"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"array(bigint)"))), TypeSignature.parseTypeSignature((String)"array(bigint)"), "add 1 to all elements of array", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN transform(x, x -> x + 1)", FunctionVersion.notVersioned());

    public TestInlineSqlFunctions() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public final void setup() {
        this.tester = new RuleTester();
        FunctionAndTypeManager functionAndTypeManager = this.tester.getMetadata().getFunctionAndTypeManager();
        functionAndTypeManager.addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL, (Object)JAVA, (Object)FunctionImplementationType.THRIFT), (SqlFunctionExecutor)new NoopSqlFunctionExecutor()), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql,java")));
        functionAndTypeManager.createFunction(SQL_FUNCTION_SQUARE, true);
        functionAndTypeManager.createFunction(THRIFT_FUNCTION_FOO, true);
        functionAndTypeManager.createFunction(SQL_FUNCTION_ADD_1_TO_INT_ARRAY, true);
        functionAndTypeManager.createFunction(SQL_FUNCTION_ADD_1_TO_BIGINT_ARRAY, true);
    }

    @Test
    public void testInlineFunction() {
        this.assertInlined("unittest.memory.square(x)", "x * x", "x", (Type)IntegerType.INTEGER);
    }

    @Test
    public void testInlineFunctionInsideFunction() {
        this.assertInlined("abs(unittest.memory.square(x))", "abs(x * x)", "x", (Type)IntegerType.INTEGER);
    }

    @Test
    public void testInlineFunctionContainingLambda() {
        this.assertInlined("unittest.memory.add_1_int(x)", "transform(x, \"x$lambda\" -> \"x$lambda\" + 1)", "x", (Type)new ArrayType((Type)IntegerType.INTEGER));
    }

    @Test
    public void testInlineSqlFunctionCoercesConstantWithCast() {
        this.assertInlined("unittest.memory.add_1_bigint(x)", "transform(x, \"x$lambda\" -> \"x$lambda\" + CAST(1 AS bigint))", "x", (Type)new ArrayType((Type)BigintType.BIGINT));
    }

    @Test
    public void testNoInlineThriftFunction() {
        this.assertNotInlined("unittest.memory.foo(x)", "x", (Type)IntegerType.INTEGER);
    }

    @Test
    public void testNoInlineIntoPlanWhenInlineIsDisabled() {
        this.assertNotInlined("unittest.memory.square(x)", (Map<String, String>)ImmutableMap.of((Object)"inline_sql_functions", (Object)"false"), "x", (Type)IntegerType.INTEGER);
    }

    protected void assertInlined(String inputExpressionStr, String expectedExpressionStr, String variable, Type type) {
        RowExpression inputExpression = new TestingRowExpressionTranslator(this.tester.getMetadata()).translate(inputExpressionStr, (Map<String, Type>)ImmutableMap.of((Object)variable, (Object)type));
        this.tester().assertThat(new InlineSqlFunctions(this.tester.getMetadata()).projectRowExpressionRewriteRule()).on(p -> p.project(PlanBuilder.assignment(p.variable("var"), inputExpression), (PlanNode)p.values(p.variable(variable, type)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"var", (Object)PlanMatchPattern.expression(expectedExpressionStr)), PlanMatchPattern.values(variable)));
    }

    private void assertNotInlined(String expression, String variable, Type type) {
        this.assertNotInlined(expression, (Map<String, String>)ImmutableMap.of(), variable, type);
    }

    private void assertNotInlined(String expression, Map<String, String> sessionValues, String variable, Type type) {
        RowExpression inputExpression = new TestingRowExpressionTranslator(this.tester.getMetadata()).translate(expression, (Map<String, Type>)ImmutableMap.of((Object)variable, (Object)type));
        RuleAssert ruleAssert = this.tester.assertThat(new SimplifyCardinalityMap(FunctionAndTypeManager.createTestFunctionAndTypeManager()).projectRowExpressionRewriteRule());
        sessionValues.forEach((k, v) -> ruleAssert.setSystemProperty((String)k, (String)v));
        ruleAssert.on(p -> p.project(PlanBuilder.assignment(p.variable("var"), inputExpression), (PlanNode)p.values(p.variable(variable, type)))).doesNotFire();
    }
}

