/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.iterative.rule.LambdaCaptureDesugaringRowExpressionRewriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLambdaCaptureDesugaringRowExpressionRewriter {
    private final TestingRowExpressionTranslator testSqlToRowExpressionTranslator = new TestingRowExpressionTranslator();

    @Test
    public void testRewriteBasicLambda() {
        RowExpression inputExpression = this.testSqlToRowExpressionTranslator.translate("any_match(ARRAY[], x -> x = a)", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)BigintType.BIGINT));
        CallExpression rewritten = (CallExpression)LambdaCaptureDesugaringRowExpressionRewriter.rewrite((RowExpression)inputExpression, (VariableAllocator)new VariableAllocator((Collection)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT))));
        Assert.assertTrue((boolean)(rewritten.getArguments().get(1) instanceof SpecialFormExpression));
        SpecialFormExpression bind = (SpecialFormExpression)rewritten.getArguments().get(1);
        Assert.assertEquals((String)bind.toString(), (String)"BIND(a, (a_0,x) -> EQUAL(x, a_0))");
    }
}

