/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.LeftJoinNullFilterToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import org.testng.annotations.Test;

public class TestLeftJoinNullFilterToSemiJoin
extends BaseRuleTest {
    public TestLeftJoinNullFilterToSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTrigger() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter("not(COALESCE(semijoinoutput, false))", PlanMatchPattern.semiJoin("left_k1", "right_k1", "semijoinoutput", PlanMatchPattern.values("left_k1", "left_k2"), PlanMatchPattern.values("right_k1")))));
    }

    @Test
    public void testNotTriggerWithFilter() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), p.rowExpression("left_k2 > 10"), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerNotNull() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is not null"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerOtherOutputUsed() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_k2", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_k2")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerOutputUsedInFilter() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null or right_k1 > 2"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerOutputUsedInFilter2() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null and right_k1 > 2"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).doesNotFire();
    }

    @Test
    public void testNotTriggerOtherOutputUsedInFilter() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null or left_k2 > 2"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).doesNotFire();
    }

    @Test
    public void testTriggerForFilterWithAnd() {
        this.tester().assertThat((Rule)new LeftJoinNullFilterToSemiJoin(this.getMetadata().getFunctionAndTypeManager())).on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("right_k1 is null and left_k2 > 2"), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1")), new EquiJoinClause(p.variable("left_k1"), p.variable("right_k1"))));
        }).matches(PlanMatchPattern.filter("left_k2 > 2", PlanMatchPattern.project(PlanMatchPattern.filter("not(COALESCE(semijoinoutput, false))", PlanMatchPattern.semiJoin("left_k1", "right_k1", "semijoinoutput", PlanMatchPattern.values("left_k1", "left_k2"), PlanMatchPattern.values("right_k1"))))));
    }
}

