/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.LeftJoinWithArrayContainsToEquiJoinCondition;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestLeftJoinWithArrayContainsToEquiJoinCondition
extends BaseRuleTest {
    public TestLeftJoinWithArrayContainsToEquiJoinCondition() {
        super(new Plugin[0]);
    }

    @Test
    public void testTriggerForBigIntArrayRightSide() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1")), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("contains(right_array_k1, left_k1)"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("left_k1", "unnest")), PlanMatchPattern.values("left_k1"), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("remove_nulls(array_distinct(right_array_k1))")), PlanMatchPattern.values("right_array_k1")))));
    }

    @Test
    public void testNotTriggerForArrayOnLeftSide() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k1", (Type)BigintType.BIGINT);
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), (PlanNode)p.values(p.variable("right_k1")), p.rowExpression("contains(left_array_k1, right_k1)"), new EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testMultipleArrayContainsConditions() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("contains(left_array_k1, right_k1) and contains(right_array_k2, left_k2)"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("left_k2", "unnest")), Optional.of("contains(left_array_k1, right_k1)"), PlanMatchPattern.values("left_array_k1", "left_k2"), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("remove_nulls(array_distinct(right_array_k2))")), PlanMatchPattern.values("right_k1", "right_array_k2")))));
    }

    @Test
    public void testMultipleInvalidArrayContainsConditions() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k2", (Type)BigintType.BIGINT);
            p.variable("right_k1", (Type)BigintType.BIGINT);
            p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT));
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_k1"), p.variable("right_array_k2", (Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("contains(left_array_k1, right_k1) or contains(right_array_k2, left_k2)"), new EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testArrayContainsWithCast() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("contains(right_array_k1, CAST(left_k1 AS BIGINT))"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("cast_left", "unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_left", (Object)PlanMatchPattern.expression("CAST(left_k1 AS BIGINT)")), PlanMatchPattern.values("left_k1")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("remove_nulls(array_distinct(right_array_k1))")), PlanMatchPattern.values("right_array_k1")))));
    }

    @Test
    public void testArrayContainsWithCast2() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("contains(CAST(right_array_k1 AS ARRAY<VARCHAR>), left_k1)"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("left_k1", "unnest")), PlanMatchPattern.values("left_k1"), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("remove_nulls(array_distinct(CAST(right_array_k1 AS ARRAY<VARCHAR>)))")), PlanMatchPattern.values("right_array_k1")))));
    }

    @Test
    public void testArrayContainsWithCoalesce() {
        this.tester().assertThat((Set<Rule<?>>)ImmutableSet.of((Object)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getFunctionManager()))).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("left_k1", (Type)VarcharType.VARCHAR);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1", (Type)VarcharType.VARCHAR), p.variable("left_k2", (Type)BigintType.BIGINT)), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT))), p.rowExpression("contains(right_array_k1, coalesce(CAST(left_k1 AS BIGINT), left_k2))"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("COALESCE(CAST(left_k1 AS bigint), left_k2)")), PlanMatchPattern.values("left_k1", "left_k2")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("remove_nulls(array_distinct(right_array_k1))")), PlanMatchPattern.values("right_array_k1")))));
    }

    @Test
    public void testConditionWithAnd() {
        this.tester().assertThat((Rule)new LeftJoinWithArrayContainsToEquiJoinCondition(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").on(p -> {
            p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT));
            p.variable("right_k2", (Type)BigintType.BIGINT);
            p.variable("left_k1", (Type)BigintType.BIGINT);
            p.variable("left_k2", (Type)BigintType.BIGINT);
            return p.join(JoinType.LEFT, (PlanNode)p.values(p.variable("left_k1"), p.variable("left_k2")), (PlanNode)p.values(p.variable("right_array_k1", (Type)new ArrayType((Type)BigintType.BIGINT)), p.variable("right_k2")), p.rowExpression("contains(right_array_k1, left_k1) and right_k2+left_k2 > 10"), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("left_k1", "unnest")), Optional.of("right_k2+left_k2 > 10"), PlanMatchPattern.values("left_k1", "left_k2"), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"array_distinct", (Object)ImmutableList.of((Object)"unnest")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"array_distinct", (Object)PlanMatchPattern.expression("remove_nulls(array_distinct(right_array_k1))")), PlanMatchPattern.values("right_array_k1", "right_k2")))));
    }
}

