/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TestTableConstraintsConnectorFactory;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.Key;
import com.facebook.presto.sql.planner.iterative.properties.KeyProperty;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.properties.MaxCardProperty;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLogicalPropertyPropagation
extends BaseRuleTest {
    private TableHandle customerTableHandle;
    private TableHandle ordersTableHandle;
    private TableHandle lineitemTableHandle;
    private ColumnHandle customerCustKeyColumn;
    private ColumnHandle customerNationKeyColumn;
    private ColumnHandle customerCommentColumn;
    private ColumnHandle mktSegmentColumn;
    private ColumnHandle acctBalColumn;
    private ColumnHandle ordersCustKeyColumn;
    private ColumnHandle ordersOrderKeyColumn;
    private ColumnHandle ordersOrderPriorityColumn;
    private ColumnHandle ordersCommentColumn;
    private ColumnHandle shipPriorityColumn;
    private ColumnHandle lineitemOrderkeyColumn;
    private ColumnHandle lineitemLinenumberColumn;
    private ColumnHandle lineitemExtendedPriceColumn;
    private VariableReferenceExpression customerCustKeyVariable;
    private VariableReferenceExpression customerNationKeyVariable;
    private VariableReferenceExpression customerCommentVariable;
    private VariableReferenceExpression shipPriorityVariable;
    private VariableReferenceExpression mktSegmentVariable;
    private VariableReferenceExpression acctBalVariable;
    private VariableReferenceExpression ordersCustKeyVariable;
    private VariableReferenceExpression ordersOrderKeyVariable;
    private VariableReferenceExpression ordersOrderPriorityVariable;
    private VariableReferenceExpression ordersCommentVariable;
    private VariableReferenceExpression lineitemOrderkeyVariable;
    private VariableReferenceExpression lineitemLinenumberVariable;
    private VariableReferenceExpression lineitemExtendedPriceVariable;
    private FunctionResolution functionResolution;
    private LogicalPropertiesProviderImpl logicalPropertiesProvider;

    public TestLogicalPropertyPropagation() {
        super(new Plugin[0]);
    }

    @Override
    @BeforeClass
    public final void setUp() {
        this.tester = new RuleTester(Collections.emptyList(), (Map<String, String>)ImmutableMap.of(), Optional.of(1), (ConnectorFactory)new TestTableConstraintsConnectorFactory(1));
        ConnectorId connectorId = this.tester().getCurrentConnectorId();
        this.functionResolution = new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver());
        this.logicalPropertiesProvider = new LogicalPropertiesProviderImpl(this.functionResolution);
        TpchTableHandle customerTpchTableHandle = new TpchTableHandle("customer", 1.0);
        TpchTableHandle ordersTpchTableHandle = new TpchTableHandle("orders", 1.0);
        TpchTableHandle lineitemTpchTableHandle = new TpchTableHandle("lineitem", 1.0);
        this.customerTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)customerTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(customerTpchTableHandle, TupleDomain.all())));
        this.ordersTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)ordersTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(ordersTpchTableHandle, TupleDomain.all())));
        this.lineitemTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)lineitemTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(lineitemTpchTableHandle, TupleDomain.all())));
        this.customerCustKeyColumn = new TpchColumnHandle("custkey", (Type)BigintType.BIGINT);
        this.customerCommentColumn = new TpchColumnHandle("comment", (Type)VarcharType.VARCHAR);
        this.customerNationKeyColumn = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.mktSegmentColumn = new TpchColumnHandle("mktsegment", (Type)VarcharType.VARCHAR);
        this.acctBalColumn = new TpchColumnHandle("acctbal", (Type)DoubleType.DOUBLE);
        this.ordersCustKeyColumn = new TpchColumnHandle("custkey", (Type)BigintType.BIGINT);
        this.ordersOrderKeyColumn = new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT);
        this.ordersOrderPriorityColumn = new TpchColumnHandle("orderpriority", (Type)BigintType.BIGINT);
        this.shipPriorityColumn = new TpchColumnHandle("shippriority", (Type)IntegerType.INTEGER);
        this.ordersCommentColumn = new TpchColumnHandle("comment", (Type)VarcharType.VARCHAR);
        this.lineitemOrderkeyColumn = new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT);
        this.lineitemLinenumberColumn = new TpchColumnHandle("linenumber", (Type)BigintType.BIGINT);
        this.lineitemExtendedPriceColumn = new TpchColumnHandle("extendedprice", (Type)DoubleType.DOUBLE);
        this.customerCustKeyVariable = new VariableReferenceExpression(Optional.empty(), "c_custkey", (Type)BigintType.BIGINT);
        this.customerNationKeyVariable = new VariableReferenceExpression(Optional.empty(), "nationkey", (Type)BigintType.BIGINT);
        this.customerCommentVariable = new VariableReferenceExpression(Optional.empty(), "c_comment", (Type)VarcharType.VARCHAR);
        this.mktSegmentVariable = new VariableReferenceExpression(Optional.empty(), "c_mktsegment", (Type)VarcharType.VARCHAR);
        this.acctBalVariable = new VariableReferenceExpression(Optional.empty(), "c_acctbal", (Type)DoubleType.DOUBLE);
        this.ordersCustKeyVariable = new VariableReferenceExpression(Optional.empty(), "o_custkey", (Type)BigintType.BIGINT);
        this.ordersOrderKeyVariable = new VariableReferenceExpression(Optional.empty(), "o_orderkey", (Type)BigintType.BIGINT);
        this.ordersOrderPriorityVariable = new VariableReferenceExpression(Optional.empty(), "o_orderpriority", (Type)VarcharType.VARCHAR);
        this.shipPriorityVariable = new VariableReferenceExpression(Optional.empty(), "o_shippriority", (Type)IntegerType.INTEGER);
        this.ordersCommentVariable = new VariableReferenceExpression(Optional.empty(), "o_comment", (Type)DoubleType.DOUBLE);
        this.lineitemOrderkeyVariable = new VariableReferenceExpression(Optional.empty(), "l_orderkey", (Type)BigintType.BIGINT);
        this.lineitemLinenumberVariable = new VariableReferenceExpression(Optional.empty(), "l_linenumber", (Type)BigintType.BIGINT);
        this.lineitemExtendedPriceVariable = new VariableReferenceExpression(Optional.empty(), "l_extendedprice", (Type)DoubleType.DOUBLE);
    }

    @Test
    void testValuesNodeLogicalProperties() {
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression c = p.variable("c");
            return p.aggregation(builder -> builder.singleGroupingSet(c).source((PlanNode)p.values(1, c)));
        }).matches((LogicalProperties)expectedLogicalProperties);
        VariableReferenceExpression a = new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(3L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)a), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)), (Object)ImmutableList.of((Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT)), (Object)ImmutableList.of((Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT))))).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testTableScanNodeLogicalProperties() {
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle))).matches((LogicalProperties)expectedLogicalProperties);
        LinkedHashSet<ColumnHandle> commentcolumnSet = new LinkedHashSet<ColumnHandle>();
        commentcolumnSet.add(this.customerCommentColumn);
        UniqueConstraint commentConstraint = new UniqueConstraint(commentcolumnSet, true, true, false);
        ArrayList<TableConstraint<ColumnHandle>> customerConstraints = new ArrayList<TableConstraint<ColumnHandle>>(this.tester().getTableConstraints(this.customerTableHandle));
        customerConstraints.add((TableConstraint<ColumnHandle>)commentConstraint);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)), (Object)new Key((Set)ImmutableSet.of((Object)this.customerCommentVariable)))));
        ArrayList<TableConstraint<ColumnHandle>> finalCustomerConstraints = customerConstraints;
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerCommentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.customerCommentVariable, (Object)this.customerCommentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), finalCustomerConstraints)).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), finalCustomerConstraints)).matches((LogicalProperties)expectedLogicalProperties);
        LinkedHashSet<ColumnHandle> custkeyCommentColumnSet = new LinkedHashSet<ColumnHandle>();
        custkeyCommentColumnSet.add(this.customerCustKeyColumn);
        custkeyCommentColumnSet.add(this.customerCommentColumn);
        UniqueConstraint custkeyCommentConstraint = new UniqueConstraint(custkeyCommentColumnSet, true, true, false);
        customerConstraints = new ArrayList<TableConstraint<ColumnHandle>>(this.tester().getTableConstraints(this.customerTableHandle));
        customerConstraints.add((TableConstraint<ColumnHandle>)custkeyCommentConstraint);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        ArrayList<TableConstraint<ColumnHandle>> finalCustomerConstraints1 = customerConstraints;
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerCommentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.customerCommentVariable, (Object)this.customerCommentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), finalCustomerConstraints1)).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (List<TableConstraint<ColumnHandle>>)ImmutableList.of((Object)custkeyCommentConstraint))).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerCommentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.customerCommentVariable, (Object)this.customerCommentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), finalCustomerConstraints1)).matches((LogicalProperties)expectedLogicalProperties);
        PrimaryKeyConstraint custkeyCommentPK = new PrimaryKeyConstraint(Optional.of("primarykey"), custkeyCommentColumnSet, true, true, false);
        UniqueConstraint custkeyUniqueConstraint = new UniqueConstraint(new LinkedHashSet(ImmutableList.of((Object)this.customerCustKeyColumn)), true, true, false);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerCommentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.customerCommentVariable, (Object)this.customerCommentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (List<TableConstraint<ColumnHandle>>)ImmutableList.of((Object)custkeyCommentPK, (Object)custkeyUniqueConstraint))).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    void testFilterNodeLogicalProperties() {
        ConstantExpression constExpr = new ConstantExpression((Object)100L, (Type)BigintType.BIGINT);
        EquivalenceClassProperty equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.customerCustKeyVariable, (RowExpression)constExpr);
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerCustKeyVariable);
            return p.filter(p.rowExpression("c_custkey = BIGINT '100'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.acctBalVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.acctBalVariable, (Object)this.acctBalColumn, (Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle)));
        }).matches((LogicalProperties)expectedLogicalProperties);
        TpchColumnHandle colA = new TpchColumnHandle("A", (Type)BigintType.BIGINT);
        TpchColumnHandle colB = new TpchColumnHandle("B", (Type)BigintType.BIGINT);
        TpchColumnHandle colC = new TpchColumnHandle("C", (Type)BigintType.BIGINT);
        PrimaryKeyConstraint primaryKeyConstraint = new PrimaryKeyConstraint(Optional.of("primarykey"), new LinkedHashSet(ImmutableList.of((Object)colA)), true, true, false);
        UniqueConstraint uniqueConstraint = new UniqueConstraint(new LinkedHashSet(ImmutableList.of((Object)colB, (Object)colC)), true, true, false);
        ImmutableList tableConstraints = ImmutableList.of((Object)primaryKeyConstraint, (Object)uniqueConstraint);
        VariableReferenceExpression varA = new VariableReferenceExpression(Optional.empty(), "A", (Type)BigintType.BIGINT);
        VariableReferenceExpression varB = new VariableReferenceExpression(Optional.empty(), "B", (Type)BigintType.BIGINT);
        VariableReferenceExpression varC = new VariableReferenceExpression(Optional.empty(), "C", (Type)BigintType.BIGINT);
        equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)varA, (RowExpression)varB);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)varA)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testFilterNodeLogicalProperties$11(varA, varB, (ColumnHandle)colA, (ColumnHandle)colB, varC, (ColumnHandle)colC, (List)tableConstraints, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        PrimaryKeyConstraint primaryKeyConstraint1 = new PrimaryKeyConstraint(Optional.of("primarykey"), new LinkedHashSet(ImmutableList.of((Object)colA, (Object)colC)), true, true, false);
        UniqueConstraint uniqueConstraint1 = new UniqueConstraint(new LinkedHashSet(ImmutableList.of((Object)colB, (Object)colC)), true, true, false);
        ImmutableList tableConstraints1 = ImmutableList.of((Object)primaryKeyConstraint1, (Object)uniqueConstraint1);
        equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)varA, (RowExpression)Expressions.constant((Object)100L, (Type)BigintType.BIGINT));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)varC)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testFilterNodeLogicalProperties$12(varA, varB, (ColumnHandle)colA, (ColumnHandle)colB, varC, (ColumnHandle)colC, (List)tableConstraints1, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        ImmutableList tableConstraints2 = ImmutableList.of((Object)new PrimaryKeyConstraint(Optional.of("primarykey"), new LinkedHashSet(ImmutableList.of((Object)colA, (Object)colB)), true, true, false));
        equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)varA, (RowExpression)Expressions.constant((Object)100L, (Type)BigintType.BIGINT));
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)varB, (RowExpression)Expressions.constant((Object)50L, (Type)BigintType.BIGINT));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testFilterNodeLogicalProperties$13(varA, varB, (ColumnHandle)colA, (ColumnHandle)colB, varC, (ColumnHandle)colC, (List)tableConstraints2, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)varA, (RowExpression)varB);
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)varA, (RowExpression)Expressions.constant((Object)100L, (Type)BigintType.BIGINT));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testFilterNodeLogicalProperties$14(varA, varB, (ColumnHandle)colA, (ColumnHandle)colB, varC, (ColumnHandle)colC, (List)tableConstraints2, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testProjectNodeLogicalProperties() {
        VariableReferenceExpression projectedCustKeyVariable = new VariableReferenceExpression(Optional.empty(), "newcustkey", (Type)BigintType.BIGINT);
        Assignments assignments = Assignments.builder().put(projectedCustKeyVariable, (RowExpression)this.customerCustKeyVariable).build();
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)projectedCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.project(assignments, (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle)))).matches((LogicalProperties)expectedLogicalProperties);
        TpchColumnHandle colA = new TpchColumnHandle("A", (Type)BigintType.BIGINT);
        TpchColumnHandle colB = new TpchColumnHandle("B", (Type)BigintType.BIGINT);
        VariableReferenceExpression varA = new VariableReferenceExpression(Optional.empty(), "A", (Type)BigintType.BIGINT);
        VariableReferenceExpression varB = new VariableReferenceExpression(Optional.empty(), "B", (Type)BigintType.BIGINT);
        VariableReferenceExpression projectedVarA = new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT);
        ImmutableList tableConstraints = ImmutableList.of((Object)new PrimaryKeyConstraint(Optional.of("primarykey"), new LinkedHashSet(ImmutableList.of((Object)colA, (Object)colB)), true, true, false));
        Assignments assignments1 = Assignments.builder().put(projectedVarA, (RowExpression)varA).build();
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testProjectNodeLogicalProperties$16(varA, varB, assignments1, (ColumnHandle)colA, (ColumnHandle)colB, (List)tableConstraints, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        ImmutableList tableConstraints1 = ImmutableList.of((Object)new PrimaryKeyConstraint(Optional.of("primarykey"), new LinkedHashSet(ImmutableList.of((Object)colA)), true, true, false));
        VariableReferenceExpression projectedA = new VariableReferenceExpression(Optional.empty(), "A1", (Type)BigintType.BIGINT);
        Assignments assignments2 = Assignments.builder().put(projectedA, (RowExpression)varA).build();
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)projectedA)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testProjectNodeLogicalProperties$17(varA, varB, assignments2, (ColumnHandle)colA, (ColumnHandle)colB, (List)tableConstraints1, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        TpchColumnHandle colC = new TpchColumnHandle("C", (Type)BigintType.BIGINT);
        TpchColumnHandle colD = new TpchColumnHandle("D", (Type)BigintType.BIGINT);
        TpchColumnHandle colE = new TpchColumnHandle("E", (Type)BigintType.BIGINT);
        TpchColumnHandle colF = new TpchColumnHandle("F", (Type)BigintType.BIGINT);
        VariableReferenceExpression varC = new VariableReferenceExpression(Optional.empty(), "C", (Type)BigintType.BIGINT);
        VariableReferenceExpression varD = new VariableReferenceExpression(Optional.empty(), "D", (Type)BigintType.BIGINT);
        VariableReferenceExpression varE = new VariableReferenceExpression(Optional.empty(), "E", (Type)BigintType.BIGINT);
        VariableReferenceExpression varF = new VariableReferenceExpression(Optional.empty(), "F", (Type)BigintType.BIGINT);
        VariableReferenceExpression projectedB = new VariableReferenceExpression(Optional.empty(), "B1", (Type)BigintType.BIGINT);
        VariableReferenceExpression projectedC = new VariableReferenceExpression(Optional.empty(), "C1", (Type)BigintType.BIGINT);
        VariableReferenceExpression projectedD = new VariableReferenceExpression(Optional.empty(), "D1", (Type)BigintType.BIGINT);
        VariableReferenceExpression projectedE = new VariableReferenceExpression(Optional.empty(), "E1", (Type)BigintType.BIGINT);
        VariableReferenceExpression projectedF = new VariableReferenceExpression(Optional.empty(), "F1", (Type)BigintType.BIGINT);
        ImmutableMap scanAssignments = new ImmutableMap.Builder().put((Object)varA, (Object)colA).put((Object)varB, (Object)colB).put((Object)varC, (Object)colC).put((Object)varD, (Object)colD).put((Object)varE, (Object)colE).put((Object)varF, (Object)colF).build();
        Assignments projectAssignments = Assignments.builder().put(projectedA, (RowExpression)varA).put(projectedB, (RowExpression)varB).put(projectedC, (RowExpression)varC).put(projectedD, (RowExpression)varD).put(projectedE, (RowExpression)varE).put(projectedF, (RowExpression)varF).build();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty();
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)projectedA, (RowExpression)projectedB);
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)projectedB, (RowExpression)projectedC);
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)projectedD, (RowExpression)projectedE);
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)projectedE, (RowExpression)projectedF);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)projectedA)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testProjectNodeLogicalProperties$18(varA, varB, varC, varD, varE, varF, projectAssignments, (Map)scanAssignments, (List)tableConstraints1, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        Assignments projectAssignments1 = Assignments.builder().put(projectedA, (RowExpression)varA).put(projectedD, (RowExpression)varD).build();
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)projectedA)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testProjectNodeLogicalProperties$19(varA, varB, varC, varD, varE, varF, projectAssignments1, (Map)scanAssignments, (List)tableConstraints1, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        Assignments projectAssignments2 = Assignments.builder().put(projectedB, (RowExpression)varB).put(projectedC, (RowExpression)varC).put(projectedE, (RowExpression)varE).put(projectedF, (RowExpression)varF).build();
        EquivalenceClassProperty equivalenceClassProperty1 = new EquivalenceClassProperty();
        equivalenceClassProperty1 = equivalenceClassProperty1.combineWith((RowExpression)projectedB, (RowExpression)projectedC);
        equivalenceClassProperty1 = equivalenceClassProperty1.combineWith((RowExpression)projectedE, (RowExpression)projectedF);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty1, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)projectedB)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testProjectNodeLogicalProperties$20(varA, varB, varC, varD, varE, varF, projectAssignments2, (Map)scanAssignments, (List)tableConstraints1, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
        Assignments projectAssignments3 = Assignments.builder().put(projectedE, (RowExpression)varE).put(projectedF, (RowExpression)varF).build();
        EquivalenceClassProperty equivalenceClassProperty2 = new EquivalenceClassProperty();
        equivalenceClassProperty2 = equivalenceClassProperty2.combineWith((RowExpression)projectedE, (RowExpression)projectedF);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty2, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(arg_0 -> this.lambda$testProjectNodeLogicalProperties$21(varA, varB, varC, varD, varE, varF, projectAssignments3, (Map)scanAssignments, (List)tableConstraints1, arg_0)).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testJoinNodeLogicalProperties() {
        EquivalenceClassProperty equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.ordersCustKeyVariable, (RowExpression)this.customerCustKeyVariable);
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.shipPriorityVariable, (RowExpression)Expressions.constant((Object)10L, (Type)IntegerType.INTEGER));
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.mktSegmentVariable, (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"BUILDING"), (Type)VarcharType.createVarcharType((int)8)));
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(5L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            p.variable(this.shipPriorityVariable);
            p.variable(this.mktSegmentVariable);
            return p.join(JoinType.INNER, (PlanNode)p.limit(5L, (PlanNode)ordersTableScan), (PlanNode)p.filter(p.rowExpression("c_mktsegment = 'BUILDING'"), (PlanNode)customerTableScan), p.rowExpression("o_shippriority = 10"), new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            p.variable(this.shipPriorityVariable);
            p.variable(this.mktSegmentVariable);
            return p.join(JoinType.INNER, (PlanNode)p.limit(1L, (PlanNode)ordersTableScan), (PlanNode)p.filter(p.rowExpression("c_mktsegment = 'BUILDING'"), (PlanNode)customerTableScan), p.rowExpression("o_shippriority = 10"), new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(6L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            p.variable(this.shipPriorityVariable);
            p.variable(this.mktSegmentVariable);
            return p.join(JoinType.INNER, (PlanNode)p.filter(p.rowExpression("c_mktsegment = 'BUILDING'"), (PlanNode)customerTableScan), (PlanNode)p.limit(6L, (PlanNode)ordersTableScan), p.rowExpression("o_shippriority = 10"), new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty((Set)ImmutableSet.of()));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            p.variable(this.shipPriorityVariable);
            p.variable(this.mktSegmentVariable);
            return p.join(JoinType.INNER, (PlanNode)p.filter(p.rowExpression("c_mktsegment = 'BUILDING'"), (PlanNode)customerTableScan), (PlanNode)p.limit(1L, (PlanNode)ordersTableScan), p.rowExpression("o_shippriority = 10"), new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(7L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.LEFT, (PlanNode)p.limit(7L, (PlanNode)ordersTableScan), (PlanNode)customerTableScan, new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.LEFT, (PlanNode)ordersTableScan, (PlanNode)p.limit(8L, (PlanNode)customerTableScan), new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(9L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.RIGHT, (PlanNode)customerTableScan, (PlanNode)p.limit(9L, (PlanNode)ordersTableScan), new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.RIGHT, (PlanNode)p.limit(10L, (PlanNode)customerTableScan), (PlanNode)ordersTableScan, new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.LEFT, (PlanNode)customerTableScan, (PlanNode)ordersTableScan, new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.INNER, (PlanNode)customerTableScan, (PlanNode)ordersTableScan, Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.ordersCustKeyVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(132L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.INNER, (PlanNode)p.limit(11L, (PlanNode)customerTableScan), (PlanNode)p.limit(12L, (PlanNode)ordersTableScan), Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.ordersCustKeyVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        ArrayList<TableConstraint<ColumnHandle>> customerTableConstraints = new ArrayList<TableConstraint<ColumnHandle>>(this.tester().getTableConstraints(this.customerTableHandle));
        customerTableConstraints.add((TableConstraint<ColumnHandle>)new UniqueConstraint(new LinkedHashSet(ImmutableList.of((Object)this.customerCommentColumn)), true, true, false));
        ArrayList<TableConstraint<ColumnHandle>> orderTableConstraints = new ArrayList<TableConstraint<ColumnHandle>>(this.tester().getTableConstraints(this.ordersTableHandle));
        orderTableConstraints.add((TableConstraint<ColumnHandle>)new UniqueConstraint(new LinkedHashSet(ImmutableList.of((Object)this.ordersCommentColumn)), true, true, false));
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.customerCustKeyVariable)), (Object)new Key((Set)ImmutableSet.of((Object)this.customerCommentVariable, (Object)this.ordersCommentVariable)), (Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.customerCommentVariable)), (Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable, (Object)this.ordersCommentVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerCommentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.customerCommentVariable, (Object)this.customerCommentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), customerTableConstraints);
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.ordersCommentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.ordersCommentVariable, (Object)this.ordersCommentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), orderTableConstraints);
            return p.join(JoinType.INNER, (PlanNode)customerTableScan, (PlanNode)ordersTableScan, Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerCommentVariable, (Object)this.ordersOrderKeyVariable, (Object)this.ordersCustKeyVariable, (Object)this.ordersCommentVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        VariableReferenceExpression c1 = new VariableReferenceExpression(Optional.empty(), "c1", (Type)BigintType.BIGINT);
        VariableReferenceExpression c2 = new VariableReferenceExpression(Optional.empty(), "c2", (Type)BigintType.BIGINT);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode values1 = p.values(1, c1);
            ValuesNode values2 = p.values(1, c2);
            return p.join(JoinType.INNER, (PlanNode)values1, (PlanNode)values2, Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)c1, (Object)c2), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        VariableReferenceExpression c3 = new VariableReferenceExpression(Optional.empty(), "c1", (Type)BigintType.BIGINT);
        VariableReferenceExpression c4 = new VariableReferenceExpression(Optional.empty(), "c2", (Type)BigintType.BIGINT);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode values1 = p.values(1, c3);
            ValuesNode values2 = p.values(1, c4);
            return p.join(JoinType.FULL, (PlanNode)values1, (PlanNode)values2, Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)c3, (Object)c4), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.FULL, (PlanNode)customerTableScan, (PlanNode)ordersTableScan, Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.ordersOrderKeyVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(120L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.FULL, (PlanNode)p.limit(12L, (PlanNode)customerTableScan), (PlanNode)p.limit(10L, (PlanNode)ordersTableScan), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable)), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.ordersOrderKeyVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.INNER, (PlanNode)p.limit(2L, (PlanNode)customerTableScan), (PlanNode)ordersTableScan, Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.ordersCustKeyVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.INNER, (PlanNode)ordersTableScan, (PlanNode)p.limit(2L, (PlanNode)customerTableScan), Collections.emptyList(), (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersOrderKeyVariable, (Object)this.ordersCustKeyVariable, (Object)this.customerCustKeyVariable), Optional.empty());
        }).matches((LogicalProperties)expectedLogicalProperties);
        equivalenceClasses = new EquivalenceClassProperty();
        VariableReferenceExpression c = new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT);
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)c, (RowExpression)this.customerCustKeyVariable);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        VariableReferenceExpression finalC1 = c;
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode values = p.values(1, finalC1);
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.join(JoinType.INNER, (PlanNode)values, (PlanNode)customerTableScan, new EquiJoinClause(finalC1, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        equivalenceClasses = new EquivalenceClassProperty();
        c = new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT);
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)c, (RowExpression)this.customerCustKeyVariable);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        VariableReferenceExpression finalC = c;
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode values = p.values(1, finalC);
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.join(JoinType.INNER, (PlanNode)customerTableScan, (PlanNode)values, new EquiJoinClause(this.customerCustKeyVariable, finalC));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        VariableReferenceExpression finalC2 = c;
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode values = p.values(1, finalC2);
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.join(JoinType.FULL, (PlanNode)customerTableScan, (PlanNode)values, new EquiJoinClause(this.customerCustKeyVariable, finalC2));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        VariableReferenceExpression finalC3 = c;
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode values = p.values(1, finalC3);
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.join(JoinType.FULL, (PlanNode)values, (PlanNode)customerTableScan, new EquiJoinClause(finalC3, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.customerCustKeyVariable, (RowExpression)this.ordersCustKeyVariable);
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.ordersOrderKeyVariable, (RowExpression)this.lineitemOrderkeyVariable);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.lineitemLinenumberVariable, (Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            TableScanNode lineitemTableScan = p.tableScan(this.lineitemTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.lineitemLinenumberVariable, (Object)this.lineitemOrderkeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.lineitemLinenumberVariable, (Object)this.lineitemLinenumberColumn, (Object)this.lineitemOrderkeyVariable, (Object)this.lineitemOrderkeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.lineitemTableHandle));
            JoinNode customerOrderJoin = p.join(JoinType.INNER, (PlanNode)customerTableScan, (PlanNode)p.limit(6L, (PlanNode)ordersTableScan), new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
            return p.join(JoinType.INNER, (PlanNode)customerOrderJoin, (PlanNode)lineitemTableScan, new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderkeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testSemiJoinNodeLogicalProperties() {
        EquivalenceClassProperty equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.ordersCustKeyVariable, (RowExpression)this.customerCustKeyVariable);
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.semiJoin(this.ordersCustKeyVariable, this.customerCustKeyVariable, this.ordersOrderKeyVariable, Optional.empty(), Optional.empty(), (PlanNode)ordersTableScan, (PlanNode)customerTableScan);
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            ValuesNode semiJoinSource = p.values(1, this.ordersCustKeyVariable);
            TableScanNode semiJoinFilteringSource = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.semiJoin(this.ordersCustKeyVariable, this.customerCustKeyVariable, this.ordersOrderKeyVariable, Optional.empty(), Optional.empty(), (PlanNode)semiJoinSource, (PlanNode)semiJoinFilteringSource);
        }).matches((LogicalProperties)expectedLogicalProperties);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty();
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)this.ordersOrderPriorityVariable, (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"URGENT"), (Type)VarcharType.createVarcharType((int)6)));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty, new MaxCardProperty(Long.valueOf(5L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode semiJoinFilteringSource = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            p.variable(this.ordersOrderPriorityVariable);
            LimitNode semiJoinSource = p.limit(5L, (PlanNode)p.filter(p.rowExpression("o_orderpriority = 'URGENT'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.ordersOrderPriorityVariable, (Object)this.ordersOrderPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle))));
            return p.semiJoin(this.ordersCustKeyVariable, this.customerCustKeyVariable, this.ordersOrderKeyVariable, Optional.empty(), Optional.empty(), (PlanNode)semiJoinSource, (PlanNode)semiJoinFilteringSource);
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testAggregationNodeLogicalProperties() {
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerNationKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.aggregation(builder -> builder.singleGroupingSet(this.customerNationKeyVariable).source((PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList())))).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.aggregation(builder -> builder.singleGroupingSet(this.customerCustKeyVariable, this.customerNationKeyVariable).source((PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle))))).matches((LogicalProperties)expectedLogicalProperties);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty();
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)this.customerNationKeyVariable, (RowExpression)Expressions.constant((Object)20L, (Type)BigintType.BIGINT));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerNationKeyVariable);
            return p.aggregation(builder -> builder.singleGroupingSet(this.customerNationKeyVariable).source((PlanNode)p.filter(p.rowExpression("nationkey = BIGINT '20'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList()))));
        }).matches((LogicalProperties)expectedLogicalProperties);
        EquivalenceClassProperty equivalenceClassProperty1 = new EquivalenceClassProperty();
        equivalenceClassProperty1 = equivalenceClassProperty1.combineWith((RowExpression)this.mktSegmentVariable, (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"BUILDING"), (Type)VarcharType.createVarcharType((int)8)));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty1, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerNationKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.mktSegmentVariable);
            return p.aggregation(builder -> builder.singleGroupingSet(this.customerNationKeyVariable, this.mktSegmentVariable).source((PlanNode)p.filter(p.rowExpression("c_mktsegment = 'BUILDING'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle)))));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerNationKeyVariable);
            return p.aggregation(builder -> builder.addAggregation(p.variable("count_nk"), p.rowExpression("count(nationkey)")).globalGrouping().source((PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle))));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerNationKeyVariable);
            return p.aggregation(builder -> builder.singleGroupingSet(this.customerNationKeyVariable).source((PlanNode)p.limit(1L, (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList()))));
        }).matches((LogicalProperties)expectedLogicalProperties);
        EquivalenceClassProperty equivalenceClassProperty2 = new EquivalenceClassProperty((Map)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)ImmutableList.of((Object)this.ordersCustKeyVariable), (Object)this.ordersOrderKeyVariable, (Object)ImmutableList.of((Object)this.lineitemOrderkeyVariable)));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty2, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.shipPriorityVariable, (Object)this.lineitemLinenumberVariable)), (Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.lineitemLinenumberVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            TableScanNode lineitemTableScan = p.tableScan(this.lineitemTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.lineitemLinenumberVariable, (Object)this.lineitemOrderkeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.lineitemLinenumberVariable, (Object)this.lineitemLinenumberColumn, (Object)this.lineitemOrderkeyVariable, (Object)this.lineitemOrderkeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.lineitemTableHandle));
            JoinNode customerOrderJoin = p.join(JoinType.INNER, (PlanNode)customerTableScan, (PlanNode)p.limit(6L, (PlanNode)ordersTableScan), new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
            p.variable(this.lineitemExtendedPriceVariable);
            return p.aggregation(builder -> builder.addAggregation(p.variable("sum_price", (Type)DoubleType.DOUBLE), p.rowExpression("sum(l_extendedprice)")).singleGroupingSet(this.lineitemLinenumberVariable, this.shipPriorityVariable).source((PlanNode)p.join(JoinType.INNER, (PlanNode)customerOrderJoin, (PlanNode)lineitemTableScan, new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderkeyVariable))));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty2, new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable, (Object)this.lineitemLinenumberVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.mktSegmentVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable, (Object)this.shipPriorityVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn, (Object)this.shipPriorityVariable, (Object)this.shipPriorityColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            TableScanNode lineitemTableScan = p.tableScan(this.lineitemTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.lineitemLinenumberVariable, (Object)this.lineitemOrderkeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.lineitemLinenumberVariable, (Object)this.lineitemLinenumberColumn, (Object)this.lineitemOrderkeyVariable, (Object)this.lineitemOrderkeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.lineitemTableHandle));
            JoinNode customerOrderJoin = p.join(JoinType.INNER, (PlanNode)customerTableScan, (PlanNode)p.limit(6L, (PlanNode)ordersTableScan), new EquiJoinClause(this.customerCustKeyVariable, this.ordersCustKeyVariable));
            p.variable(this.lineitemExtendedPriceVariable);
            return p.aggregation(builder -> builder.addAggregation(p.variable("sum_price", (Type)DoubleType.DOUBLE), p.rowExpression("sum(l_extendedprice)")).singleGroupingSet(this.lineitemLinenumberVariable, this.ordersOrderKeyVariable, this.shipPriorityVariable).source((PlanNode)p.join(JoinType.INNER, (PlanNode)customerOrderJoin, (PlanNode)lineitemTableScan, new EquiJoinClause(this.ordersOrderKeyVariable, this.lineitemOrderkeyVariable))));
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    void testAssignUniqueIdNodeLogicalProperties() {
        VariableReferenceExpression c = new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT);
        VariableReferenceExpression unique = new VariableReferenceExpression(Optional.empty(), "unique", (Type)BigintType.BIGINT);
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(5L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)unique)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.assignUniqueId(unique, (PlanNode)p.values(5, c))).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    void testDistinctLimitNodeLogicalProperties() {
        VariableReferenceExpression c = new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT);
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(3L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)c)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.distinctLimit(3L, (List<VariableReferenceExpression>)ImmutableList.of((Object)c), (PlanNode)p.values(5, c))).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(5L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerNationKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.distinctLimit(5L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList()))).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(6L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.distinctLimit(6L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable, (Object)this.customerNationKeyVariable), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle)))).matches((LogicalProperties)expectedLogicalProperties);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty();
        equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)this.customerNationKeyVariable, (RowExpression)Expressions.constant((Object)20L, (Type)BigintType.BIGINT));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerNationKeyVariable);
            return p.distinctLimit(6L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (PlanNode)p.filter(p.rowExpression("nationkey = BIGINT '20'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList())));
        }).matches((LogicalProperties)expectedLogicalProperties);
        EquivalenceClassProperty equivalenceClassProperty1 = new EquivalenceClassProperty();
        equivalenceClassProperty1 = equivalenceClassProperty1.combineWith((RowExpression)this.mktSegmentVariable, (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"BUILDING"), (Type)VarcharType.createVarcharType((int)8)));
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClassProperty1, new MaxCardProperty(Long.valueOf(7L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerNationKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.mktSegmentVariable);
            return p.distinctLimit(7L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable, (Object)this.mktSegmentVariable), (PlanNode)p.filter(p.rowExpression("c_mktsegment = 'BUILDING'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn, (Object)this.mktSegmentVariable, (Object)this.mktSegmentColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle))));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerNationKeyVariable);
            return p.distinctLimit(8L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (PlanNode)p.limit(1L, (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList())));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            p.variable(this.customerNationKeyVariable);
            return p.distinctLimit(1L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerNationKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerNationKeyVariable, (Object)this.customerNationKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Collections.emptyList()));
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testLimitNodeLogicalProperties() {
        EquivalenceClassProperty equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.ordersCustKeyVariable, (RowExpression)this.customerCustKeyVariable);
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(6L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            JoinNode ordersCustomerJoin = p.join(JoinType.INNER, (PlanNode)ordersTableScan, (PlanNode)customerTableScan, new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
            return p.limit(6L, (PlanNode)ordersCustomerJoin);
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(5L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.INNER, (PlanNode)p.limit(5L, (PlanNode)ordersTableScan), (PlanNode)customerTableScan, new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(5L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.limit(10L, (PlanNode)p.values(5, p.variable("c")))).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(6L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.limit(6L, (PlanNode)p.values(10, p.variable("c")))).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.limit(1L, (PlanNode)customerTableScan);
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testTopNNodeLogicalProperties() {
        EquivalenceClassProperty equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.ordersCustKeyVariable, (RowExpression)this.customerCustKeyVariable);
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(6L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            JoinNode ordersCustomerJoin = p.join(JoinType.INNER, (PlanNode)ordersTableScan, (PlanNode)customerTableScan, new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
            return p.topN(6L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (PlanNode)ordersCustomerJoin);
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(5L)), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.ordersOrderKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            TableScanNode ordersTableScan = p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable, (Object)this.ordersOrderKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.ordersCustKeyVariable, (Object)this.ordersCustKeyColumn, (Object)this.ordersOrderKeyVariable, (Object)this.ordersOrderKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.ordersTableHandle));
            return p.join(JoinType.INNER, (PlanNode)p.topN(5L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.ordersCustKeyVariable), (PlanNode)ordersTableScan), (PlanNode)customerTableScan, new EquiJoinClause(this.ordersCustKeyVariable, this.customerCustKeyVariable));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(5L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression var = p.variable("c");
            return p.topN(10L, (List<VariableReferenceExpression>)ImmutableList.of((Object)var), (PlanNode)p.values(5, var));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(6L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression var = p.variable("c");
            return p.topN(6L, (List<VariableReferenceExpression>)ImmutableList.of((Object)var), (PlanNode)p.values(10, var));
        }).matches((LogicalProperties)expectedLogicalProperties);
        expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode customerTableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.topN(1L, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (PlanNode)customerTableScan);
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    void testSortNodeLogicalProperties() {
        LogicalPropertiesImpl expectedLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty((Set)ImmutableSet.of((Object)new Key((Set)ImmutableSet.of((Object)this.customerCustKeyVariable)))));
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode tableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            return p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (PlanNode)tableScan);
        }).matches((LogicalProperties)expectedLogicalProperties);
        ConstantExpression constExpr = new ConstantExpression((Object)100L, (Type)BigintType.BIGINT);
        EquivalenceClassProperty equivalenceClasses = new EquivalenceClassProperty();
        equivalenceClasses = equivalenceClasses.combineWith((RowExpression)this.customerCustKeyVariable, (RowExpression)constExpr);
        expectedLogicalProperties = new LogicalPropertiesImpl(equivalenceClasses, new MaxCardProperty(Long.valueOf(1L)), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            TableScanNode tableScan = p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)this.customerCustKeyVariable, (Object)this.customerCustKeyColumn), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), this.tester().getTableConstraints(this.customerTableHandle));
            p.variable(this.customerCustKeyVariable);
            FilterNode filterNode = p.filter(p.rowExpression("c_custkey = BIGINT '100'"), (PlanNode)tableScan);
            return p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)this.customerCustKeyVariable), (PlanNode)filterNode);
        }).matches((LogicalProperties)expectedLogicalProperties);
    }

    @Test
    public void testDefaultLogicalProperties() {
        LogicalPropertiesImpl defaultLogicalProperties = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty());
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().putAll((Object)p.variable("o1"), (Object[])new VariableReferenceExpression[]{p.variable("s1_c1"), p.variable("s2_c1")}).putAll((Object)p.variable("o2"), (Object[])new VariableReferenceExpression[]{p.variable("s1_c2"), p.variable("s2_c2")}).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, p.variable("s1_c1"), p.variable("s1_c2")), (Object)p.values(2, p.variable("s2_c1"), p.variable("s2_c2"))))).matches((LogicalProperties)defaultLogicalProperties);
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.intersect((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().putAll((Object)p.variable("o1"), (Object[])new VariableReferenceExpression[]{p.variable("s1_c1"), p.variable("s2_c1")}).putAll((Object)p.variable("o2"), (Object[])new VariableReferenceExpression[]{p.variable("s1_c2"), p.variable("s2_c2")}).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, p.variable("s1_c1"), p.variable("s1_c2")), (Object)p.values(2, p.variable("s2_c1"), p.variable("s2_c2"))))).matches((LogicalProperties)defaultLogicalProperties);
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (PlanNode)p.values(p.variable("a")), (PlanNode)p.values(p.variable("a")))).matches((LogicalProperties)defaultLogicalProperties);
        this.tester().assertThat(new NoOpRule(), (LogicalPropertiesProvider)this.logicalPropertiesProvider).on(p -> {
            VariableReferenceExpression key = p.variable("key");
            VariableReferenceExpression mark = p.variable("mark");
            return p.markDistinct(mark, (List<VariableReferenceExpression>)ImmutableList.of((Object)key), (PlanNode)p.values(10, key));
        }).matches((LogicalProperties)defaultLogicalProperties);
    }

    private /* synthetic */ PlanNode lambda$testProjectNodeLogicalProperties$21(VariableReferenceExpression varA, VariableReferenceExpression varB, VariableReferenceExpression varC, VariableReferenceExpression varD, VariableReferenceExpression varE, VariableReferenceExpression varF, Assignments projectAssignments3, Map scanAssignments, List tableConstraints1, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        p.variable(varC);
        p.variable(varD);
        p.variable(varE);
        p.variable(varF);
        return p.project(projectAssignments3, (PlanNode)p.filter(p.rowExpression("A = B AND B = C AND D = E AND E = F"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA, (Object)varB, (Object)varC, (Object)varD, (Object)varE, (Object)varF), scanAssignments, (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints1)));
    }

    private /* synthetic */ PlanNode lambda$testProjectNodeLogicalProperties$20(VariableReferenceExpression varA, VariableReferenceExpression varB, VariableReferenceExpression varC, VariableReferenceExpression varD, VariableReferenceExpression varE, VariableReferenceExpression varF, Assignments projectAssignments2, Map scanAssignments, List tableConstraints1, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        p.variable(varC);
        p.variable(varD);
        p.variable(varE);
        p.variable(varF);
        return p.project(projectAssignments2, (PlanNode)p.filter(p.rowExpression("A = B AND B = C AND D = E AND E = F"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA, (Object)varB, (Object)varC, (Object)varD, (Object)varE, (Object)varF), scanAssignments, (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints1)));
    }

    private /* synthetic */ PlanNode lambda$testProjectNodeLogicalProperties$19(VariableReferenceExpression varA, VariableReferenceExpression varB, VariableReferenceExpression varC, VariableReferenceExpression varD, VariableReferenceExpression varE, VariableReferenceExpression varF, Assignments projectAssignments1, Map scanAssignments, List tableConstraints1, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        p.variable(varC);
        p.variable(varD);
        p.variable(varE);
        p.variable(varF);
        return p.project(projectAssignments1, (PlanNode)p.filter(p.rowExpression("A = B AND B = C AND D = E AND E = F"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA, (Object)varB, (Object)varC, (Object)varD, (Object)varE, (Object)varF), scanAssignments, (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints1)));
    }

    private /* synthetic */ PlanNode lambda$testProjectNodeLogicalProperties$18(VariableReferenceExpression varA, VariableReferenceExpression varB, VariableReferenceExpression varC, VariableReferenceExpression varD, VariableReferenceExpression varE, VariableReferenceExpression varF, Assignments projectAssignments, Map scanAssignments, List tableConstraints1, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        p.variable(varC);
        p.variable(varD);
        p.variable(varE);
        p.variable(varF);
        return p.project(projectAssignments, (PlanNode)p.filter(p.rowExpression("A = B AND B = C AND D = E AND E = F"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA, (Object)varB, (Object)varC, (Object)varD, (Object)varE, (Object)varF), scanAssignments, (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints1)));
    }

    private /* synthetic */ PlanNode lambda$testProjectNodeLogicalProperties$17(VariableReferenceExpression varA, VariableReferenceExpression varB, Assignments assignments2, ColumnHandle colA, ColumnHandle colB, List tableConstraints1, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        return p.project(assignments2, (PlanNode)p.filter(p.rowExpression("A = B"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)varA, (Object)colA, (Object)varB, (Object)colB), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints1)));
    }

    private /* synthetic */ PlanNode lambda$testProjectNodeLogicalProperties$16(VariableReferenceExpression varA, VariableReferenceExpression varB, Assignments assignments1, ColumnHandle colA, ColumnHandle colB, List tableConstraints, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        return p.project(assignments1, (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)varA, (Object)colA, (Object)varB, (Object)colB), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints));
    }

    private /* synthetic */ PlanNode lambda$testFilterNodeLogicalProperties$14(VariableReferenceExpression varA, VariableReferenceExpression varB, ColumnHandle colA, ColumnHandle colB, VariableReferenceExpression varC, ColumnHandle colC, List tableConstraints2, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        return p.filter(p.rowExpression("A = B AND A = BIGINT '100'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)varA, (Object)colA, (Object)varB, (Object)colB, (Object)varC, (Object)colC), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints2));
    }

    private /* synthetic */ PlanNode lambda$testFilterNodeLogicalProperties$13(VariableReferenceExpression varA, VariableReferenceExpression varB, ColumnHandle colA, ColumnHandle colB, VariableReferenceExpression varC, ColumnHandle colC, List tableConstraints2, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        return p.filter(p.rowExpression("A = BIGINT '100' AND B = BIGINT '50'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)varA, (Object)colA, (Object)varB, (Object)colB, (Object)varC, (Object)colC), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints2));
    }

    private /* synthetic */ PlanNode lambda$testFilterNodeLogicalProperties$12(VariableReferenceExpression varA, VariableReferenceExpression varB, ColumnHandle colA, ColumnHandle colB, VariableReferenceExpression varC, ColumnHandle colC, List tableConstraints1, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        return p.filter(p.rowExpression("A = BIGINT '100'"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)varA, (Object)colA, (Object)varB, (Object)colB, (Object)varC, (Object)colC), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints1));
    }

    private /* synthetic */ PlanNode lambda$testFilterNodeLogicalProperties$11(VariableReferenceExpression varA, VariableReferenceExpression varB, ColumnHandle colA, ColumnHandle colB, VariableReferenceExpression varC, ColumnHandle colC, List tableConstraints, PlanBuilder p) {
        p.variable(varA);
        p.variable(varB);
        return p.filter(p.rowExpression("A = B"), (PlanNode)p.tableScan(this.customerTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)varA), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)varA, (Object)colA, (Object)varB, (Object)colB, (Object)varC, (Object)colC), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), tableConstraints));
    }

    private static class NoOpRule
    implements Rule<PlanNode> {
        private final Pattern pattern = Pattern.any();

        private NoOpRule() {
        }

        public Pattern<PlanNode> getPattern() {
            return this.pattern;
        }

        public Rule.Result apply(PlanNode node, Captures captures, Rule.Context context) {
            return Rule.Result.ofPlanNode((PlanNode)node);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).toString();
        }
    }
}

