/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneSemiJoinColumns
extends BaseRuleTest {
    public TestPruneSemiJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testSemiJoinNotNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, variable -> variable.getName().equals("leftValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftValue", (Object)PlanMatchPattern.expression("leftValue")), PlanMatchPattern.values("leftKey", "leftKeyHash", "leftValue")));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, variable -> true)).doesNotFire();
    }

    @Test
    public void testKeysNotNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, variable -> variable.getName().equals("leftValue") || variable.getName().equals("match"))).doesNotFire();
    }

    @Test
    public void testValueNotNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinColumns()).on(p -> TestPruneSemiJoinColumns.buildProjectedSemiJoin(p, variable -> variable.getName().equals("match"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"match", (Object)PlanMatchPattern.expression("match")), PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftKey", (Object)PlanMatchPattern.expression("leftKey"), (Object)"leftKeyHash", (Object)PlanMatchPattern.expression("leftKeyHash")), PlanMatchPattern.values("leftKey", "leftKeyHash", "leftValue")), PlanMatchPattern.values("rightKey"))));
    }

    private static PlanNode buildProjectedSemiJoin(PlanBuilder p, Predicate<VariableReferenceExpression> projectionFilter) {
        VariableReferenceExpression match = p.variable("match");
        VariableReferenceExpression leftKey = p.variable("leftKey");
        VariableReferenceExpression leftKeyHash = p.variable("leftKeyHash");
        VariableReferenceExpression leftValue = p.variable("leftValue");
        VariableReferenceExpression rightKey = p.variable("rightKey");
        ImmutableList outputs = ImmutableList.of((Object)match, (Object)leftKey, (Object)leftKeyHash, (Object)leftValue);
        return p.project(AssignmentUtils.identityAssignments((Collection)((Collection)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.semiJoin(leftKey, rightKey, match, Optional.of(leftKeyHash), Optional.empty(), (PlanNode)p.values(leftKey, leftKeyHash, leftValue), (PlanNode)p.values(rightKey)));
    }
}

