/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneSemiJoinFilteringSourceColumns
extends BaseRuleTest {
    public TestPruneSemiJoinFilteringSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllColumnsReferenced() {
        this.tester().assertThat((Rule)new PruneSemiJoinFilteringSourceColumns()).on(p -> TestPruneSemiJoinFilteringSourceColumns.buildSemiJoin(p, variable -> true)).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.values("leftKey"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightKey", (Object)PlanMatchPattern.expression("rightKey"), (Object)"rightKeyHash", (Object)PlanMatchPattern.expression("rightKeyHash")), PlanMatchPattern.values("rightKey", "rightKeyHash", "rightValue"))));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule)new PruneSemiJoinFilteringSourceColumns()).on(p -> TestPruneSemiJoinFilteringSourceColumns.buildSemiJoin(p, variable -> !variable.getName().equals("rightValue"))).doesNotFire();
    }

    private static PlanNode buildSemiJoin(PlanBuilder p, Predicate<VariableReferenceExpression> filteringSourceVariableFilter) {
        VariableReferenceExpression match = p.variable("match");
        VariableReferenceExpression leftKey = p.variable("leftKey");
        VariableReferenceExpression rightKey = p.variable("rightKey");
        VariableReferenceExpression rightKeyHash = p.variable("rightKeyHash");
        VariableReferenceExpression rightValue = p.variable("rightValue");
        ImmutableList filteringSourceVariables = ImmutableList.of((Object)rightKey, (Object)rightKeyHash, (Object)rightValue);
        List filteredSourceVariables = (List)filteringSourceVariables.stream().filter(filteringSourceVariableFilter).collect(ImmutableList.toImmutableList());
        return p.semiJoin(leftKey, rightKey, match, Optional.empty(), Optional.of(rightKeyHash), (PlanNode)p.values(leftKey), (PlanNode)p.values(filteredSourceVariables, (List<List<RowExpression>>)ImmutableList.of()));
    }
}

