/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushOffsetThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushOffsetThroughProject
extends BaseRuleTest {
    public TestPushOffsetThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownOffsetNonIdentityProjection() {
        this.tester().assertThat((Rule)new PushOffsetThroughProject()).setSystemProperty("offset_clause_enabled", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a");
            return p.offset(5L, (PlanNode)p.project(Assignments.of((VariableReferenceExpression)a, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT), (PlanNode)p.values()));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.offset(5L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testDoNotPushdownOffsetThroughIdentityProjection() {
        this.tester().assertThat((Rule)new PushOffsetThroughProject()).setSystemProperty("offset_clause_enabled", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a");
            return p.offset(5L, (PlanNode)p.project(Assignments.of((VariableReferenceExpression)a, (RowExpression)a), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

